/*
 * Decompiled with CFR 0.152.
 */
package com.sun.etl.engine.impl;

import com.sun.etl.engine.ETLEngineContext;
import com.sun.etl.engine.ETLTask;
import com.sun.etl.engine.ETLTaskNode;
import com.sun.etl.engine.utils.ETLException;
import com.sun.etl.engine.utils.MessageManager;
import com.sun.sql.framework.exception.BaseException;
import com.sun.sql.framework.jdbc.DBConnectionFactory;
import com.sun.sql.framework.jdbc.DBConnectionParameters;
import com.sun.sql.framework.jdbc.SQLPart;
import com.sun.sql.framework.jdbc.SQLUtils;
import com.sun.sql.framework.utils.Logger;
import com.sun.sql.framework.utils.StringUtil;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class SimpleTask
implements ETLTask {
    private static final String LOG_CATEGORY = SimpleTask.class.getName();
    private static final MessageManager MSG_MGR = MessageManager.getManager("com.sun.etl.engine.impl");
    protected static final String NL = System.getProperty("line.separator", "\n");
    protected String DN = "";
    private Connection statsConn;
    private final String URL_PREFIX = "jdbc:axiondb:";

    public void cleanUp() {
        if (this.statsConn != null) {
            DBConnectionFactory.getInstance().closeConnection(this.statsConn);
        }
    }

    public void handleException(ETLException ex) {
    }

    public String process(ETLTaskNode node) throws ETLException {
        return "Success";
    }

    protected void closeResultSet(ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected void closeStatement(Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    protected void computeRowCountStatistics(ETLTaskNode node, String tableName, Connection conn) throws ETLException {
        SQLPart selectRejectedRowCountPart = node.getTableSpecificStatement(tableName, "selectRejectedRowCountFromDetailsTable");
        PreparedStatement stmt = null;
        ETLEngineContext.CollabStatistics stats = node.getContext().getStatistics();
        long insertCt = stats.getRowsInsertedCount(tableName);
        long rejectedRows = 0L;
        long extractedRows = insertCt;
        try {
            if (selectRejectedRowCountPart != null) {
                int executionId = stats.getTableExecutionId(tableName);
                String selectSql = selectRejectedRowCountPart.getSQL();
                stmt = conn.prepareStatement(selectSql);
                stmt.setInt(1, executionId);
                ResultSet rs = stmt.executeQuery();
                rs.next();
                rejectedRows = rs.getInt(1);
                extractedRows = insertCt + rejectedRows;
            }
        }
        catch (Exception e) {
            throw new ETLException(e);
        }
        finally {
            this.closeStatement(stmt);
            stats.setRowsRejectedCount(tableName, rejectedRows);
            stats.setRowsExtractedCount(tableName, extractedRows);
        }
    }

    protected boolean createBeforeProcess(ETLTaskNode node, Connection con) throws ETLException {
        Statement stmt = null;
        boolean originalState = false;
        boolean tableCreated = false;
        try {
            String ifExists;
            SQLPart createSQLPart = node.getStatement("createBeforeProcess");
            if (createSQLPart == null) {
                boolean bl = tableCreated;
                return bl;
            }
            originalState = con.getAutoCommit();
            DBConnectionFactory.getInstance().setAutoCommit(con, true);
            stmt = con.createStatement();
            Iterator stmtIter = createSQLPart.getIterator();
            if (stmtIter.hasNext() && !this.isTableExists(con, ifExists = (String)stmtIter.next(), node) && stmtIter.hasNext()) {
                do {
                    String doCreate = (String)stmtIter.next();
                    String msg = MSG_MGR.getString("MSG_simple_show_create_stmt", doCreate);
                    Logger.print(10000, LOG_CATEGORY, this.DN + msg);
                    node.fireETLEngineLogEvent(NL + msg + NL);
                    stmt.executeUpdate(doCreate);
                } while (stmtIter.hasNext());
                tableCreated = true;
            }
            this.closeStatement(stmt);
            this.resetCommitState(con, originalState);
        }
        catch (Exception e) {
            throw new ETLException("Error occurred while attempting to create table", e);
        }
        finally {
            this.closeStatement(stmt);
            this.resetCommitState(con, originalState);
        }
        return tableCreated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Timestamp createExecutionEntryInSummaryTable(ETLTaskNode node) throws BaseException {
        SQLPart insertStartDatePart = node.getStatement("insertExecutionRecordStatement");
        PreparedStatement stmt = null;
        Timestamp timeUsed = null;
        if (insertStartDatePart == null) return timeUsed;
        Class<SimpleTask> clazz = SimpleTask.class;
        synchronized (SimpleTask.class) {
            try {
                String connPoolName = insertStartDatePart.getConnectionPoolName();
                if (this.statsConn == null) {
                    this.statsConn = this.getConnection(connPoolName, node.getParent().getConnectionDefList());
                }
                this.statsConn.setAutoCommit(true);
                String insertStmt = insertStartDatePart.getSQL();
                stmt = this.statsConn.prepareStatement(insertStmt);
                timeUsed = new Timestamp(System.currentTimeMillis());
                stmt.setTimestamp(1, timeUsed);
                stmt.executeUpdate();
                this.closeStatement(stmt);
            }
            catch (SQLException e) {
                try {
                    throw new BaseException(e);
                }
                catch (Throwable throwable) {
                    this.closeStatement(stmt);
                    throw throwable;
                }
            }
            return timeUsed;
        }
    }

    protected void createSummaryTable(ETLTaskNode node) throws ETLException {
        SQLPart summarySql = node.getStatement("createSummaryTableStatement");
        if (null != summarySql) {
            Statement stmt = null;
            try {
                String poolName = summarySql.getConnectionPoolName();
                if (null == this.statsConn) {
                    this.statsConn = this.getConnection(poolName, node.getParent().getConnectionDefList());
                }
                this.statsConn.setAutoCommit(true);
                stmt = this.statsConn.createStatement();
                stmt.executeUpdate(summarySql.getSQL());
                this.closeStatement(stmt);
            }
            catch (Exception e) {
                try {
                    Logger.print(40000, LOG_CATEGORY, (Object)(this.DN + "Failed to execute InitTask"), e);
                    throw new ETLException(this.DN + "Failed to execute InitTask.", e);
                }
                catch (Throwable throwable) {
                    this.closeStatement(stmt);
                    throw throwable;
                }
            }
        }
    }

    protected Connection getConnection(String poolName, List connList) throws BaseException {
        DBConnectionFactory factory = DBConnectionFactory.getInstance();
        DBConnectionParameters dbConDefn = this.lookupConnDefinitionBy(poolName, connList);
        if (dbConDefn != null) {
            Connection con = factory.getConnection(dbConDefn);
            return con;
        }
        throw new BaseException("Could not locate connection definition for pool name " + poolName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int getExecutionEntryIdFromSummaryTable(ETLTaskNode node, Timestamp startTime) throws BaseException {
        int executionId = -1;
        SQLPart selectExecutionIdPart = node.getStatement("selectExecutionIdFromSummaryTable");
        PreparedStatement stmt = null;
        if (selectExecutionIdPart == null) return executionId;
        Class<SimpleTask> clazz = SimpleTask.class;
        synchronized (SimpleTask.class) {
            try {
                String connPoolName = selectExecutionIdPart.getConnectionPoolName();
                if (this.statsConn == null) {
                    this.statsConn = this.getConnection(connPoolName, node.getParent().getConnectionDefList());
                }
                this.statsConn.setAutoCommit(true);
                String selectSql = selectExecutionIdPart.getSQL();
                stmt = this.statsConn.prepareStatement(selectSql);
                stmt.setTimestamp(1, startTime);
                stmt.setString(2, selectExecutionIdPart.getTableName());
                ResultSet rs = stmt.executeQuery();
                if (!rs.next()) {
                    throw new BaseException(MSG_MGR.getString("MSG_common_execid_notfound"));
                }
                executionId = rs.getInt(1);
                this.closeStatement(stmt);
            }
            catch (SQLException e) {
                try {
                    throw new BaseException(e);
                }
                catch (Throwable throwable) {
                    this.closeStatement(stmt);
                    throw throwable;
                }
            }
            return executionId;
        }
    }

    protected String getMetadataDir(String url) {
        String temp;
        StringTokenizer st;
        String metaData = null;
        String prefixStripped = url.substring("jdbc:axiondb:".length());
        int colon = prefixStripped.indexOf(":");
        if (colon != -1 && prefixStripped.length() - 1 != colon && (st = new StringTokenizer(temp = prefixStripped.substring(colon + 1), ";")).hasMoreTokens()) {
            metaData = st.nextToken();
            return metaData;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isTableExists(Connection conn, String checkSQL, ETLTaskNode node) throws BaseException {
        boolean isTableExist = false;
        ResultSet rs = null;
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            Map attribMap = node.getParent().getInputAttrMap();
            checkSQL = SQLUtils.replaceTableNameFromRuntimeArguments(checkSQL, attribMap);
            rs = stmt.executeQuery(checkSQL);
            isTableExist = true;
            isTableExist = checkSQL.indexOf("SELECT 1 FROM") >= 0 ? true : rs.next();
            this.closeResultSet(rs);
            this.closeStatement(stmt);
        }
        catch (SQLException e) {
            isTableExist = false;
        }
        finally {
            this.closeResultSet(rs);
            this.closeStatement(stmt);
        }
        return isTableExist;
    }

    protected void logSQLException(int logLevel, String logCategory, SQLException e) {
        if (logCategory == null) {
            logCategory = LOG_CATEGORY;
        }
        String sqlState = e.getSQLState();
        String vendorCode = Integer.toString(e.getErrorCode());
        String msg = MSG_MGR.getString("MSG_common_sqlexception", this.DN, sqlState, vendorCode, e.getLocalizedMessage());
        Logger.print(logLevel, logCategory, msg);
    }

    protected DBConnectionParameters lookupConnDefinitionBy(String name, List defList) {
        if (defList == null || name == null) {
            return null;
        }
        DBConnectionParameters result = null;
        for (DBConnectionParameters item : defList) {
            if (!item.getName().equalsIgnoreCase(name)) continue;
            result = item;
            break;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void truncateBeforeProcess(ETLTaskNode node, Connection con) {
        SQLPart truncateSQLPart;
        boolean originalState;
        String doTruncate;
        Statement stmt;
        block5: {
            stmt = null;
            doTruncate = null;
            originalState = false;
            truncateSQLPart = node.getStatement("truncateBeforeProcessStatement");
            if (truncateSQLPart != null) break block5;
            this.closeStatement(stmt);
            this.resetCommitState(con, originalState);
            return;
        }
        try {
            originalState = con.getAutoCommit();
            DBConnectionFactory.getInstance().setAutoCommit(con, true);
            stmt = con.createStatement();
            this.truncateTable(node, con, stmt, truncateSQLPart);
            this.closeStatement(stmt);
            this.resetCommitState(con, originalState);
        }
        catch (Exception e) {
            try {
                String msg = MSG_MGR.getString("MSG_simple_truncate_failed");
                Logger.printThrowable(10000, LOG_CATEGORY, this.DN, msg, e);
                node.fireETLEngineLogEvent(msg);
                this.deleteOnFailedTruncate(node, con, doTruncate);
                this.closeStatement(stmt);
                this.resetCommitState(con, originalState);
            }
            catch (Throwable throwable) {
                this.closeStatement(stmt);
                this.resetCommitState(con, originalState);
                throw throwable;
            }
        }
    }

    protected void setAutoCommitIfRequired(Connection conn, boolean flag) {
        try {
            DatabaseMetaData dbmd = conn.getMetaData();
            String url = dbmd.getURL();
            if (!StringUtil.isNullString(url) && url.toUpperCase().indexOf(":SYBASE:") != -1) {
                conn.commit();
                conn.setAutoCommit(flag);
            }
        }
        catch (SQLException ignore) {
            Logger.print(10000, LOG_CATEGORY, "Could not determine database vendor in order to set autocommit flag - continuing.");
        }
    }

    protected Throwable unwrapThrowable(Throwable t) {
        while (t.getCause() != null && (t = t.getCause()).getCause() != t) {
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteOnFailedTruncate(ETLTaskNode node, Connection con, String truncateSql) {
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            SQLPart deleteSQLPart = node.getStatement("deleteBeforeProcessStatement");
            if (deleteSQLPart == null || truncateSql == null) {
                return;
            }
            String doDelete = deleteSQLPart.getSQL();
            if (doDelete != null && truncateSql != null && !doDelete.trim().equalsIgnoreCase(truncateSql.trim())) {
                String msg = MSG_MGR.getString("MSG_simple_truncate_fallback");
                Logger.print(10000, LOG_CATEGORY, this.DN + msg);
                node.fireETLEngineLogEvent(msg);
                this.truncateTable(node, con, stmt, deleteSQLPart);
                msg = MSG_MGR.getString("MSG_simple_truncate_fallback_success");
                Logger.print(10000, LOG_CATEGORY, this.DN + msg);
                node.fireETLEngineLogEvent(msg);
            }
        }
        catch (Exception e) {
            String msg = MSG_MGR.getString("MSG_simple_truncate_fallback_failure", e.getMessage());
            Logger.printThrowable(10000, LOG_CATEGORY, this.DN, msg, e);
            node.fireETLEngineLogEvent(msg);
        }
        finally {
            this.closeStatement(stmt);
        }
    }

    private void resetCommitState(Connection con, boolean originalState) {
        try {
            if (con != null) {
                con.setAutoCommit(originalState);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void truncateTable(ETLTaskNode node, Connection con, Statement stmt, SQLPart truncateSQLPart) throws BaseException, SQLException {
        String ifExists;
        Iterator stmtIter = truncateSQLPart.getIterator();
        if (stmtIter.hasNext() && this.isTableExists(con, ifExists = (String)stmtIter.next(), node) && stmtIter.hasNext()) {
            String msg = MSG_MGR.getString("MSG_simple_truncate_attempt");
            Logger.print(10000, LOG_CATEGORY, this.DN + msg);
            node.fireETLEngineLogEvent(msg);
            do {
                String doDelete = (String)stmtIter.next();
                msg = MSG_MGR.getString("MSG_common_using_sql", doDelete);
                Logger.print(10000, LOG_CATEGORY, this.DN + msg);
                node.fireETLEngineLogEvent(msg);
                stmt.executeUpdate(doDelete);
            } while (stmtIter.hasNext());
            msg = MSG_MGR.getString("MSG_simple_truncate_success");
            Logger.print(10000, LOG_CATEGORY, this.DN + msg);
            node.fireETLEngineLogEvent(msg + NL);
        }
    }
}

