/*
 * Decompiled with CFR 0.152.
 */
package com.sun.etl.engine.impl;

import com.sun.etl.engine.ETLEngineExecEvent;
import com.sun.etl.engine.ETLEngineListener;
import com.sun.etl.engine.impl.WaitTask;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class ETLTaskThreadManager {
    private boolean active = true;
    private ETLEngineListener execListener;
    private String name;
    private int resumeCounter = 0;
    private Object startThreadWait = new Object();
    private HashMap taskDependents = new HashMap();

    public ETLTaskThreadManager(String name) {
        this.name = name;
    }

    public void addEngineListener(ETLEngineListener listener) {
        this.execListener = listener;
    }

    public synchronized void addWaitDependency(String taskName, WaitTask waitTask) {
        this.taskDependents.put(taskName, waitTask);
    }

    public synchronized void clearTaskThread(String taskName) {
        this.taskDependents.remove(taskName);
    }

    public void fireETLEngineExecEvent(int status, String msg) {
        if (this.execListener != null) {
            this.execListener.executionPerformed(new ETLEngineExecEvent(this.name, status, new Exception(msg)));
        }
    }

    public void fireETLEngineExecEvent(int status, Throwable cause) {
        if (this.execListener != null) {
            this.execListener.executionPerformed(new ETLEngineExecEvent(this.name, status, cause));
        }
    }

    public ETLEngineListener getEngineListener() {
        return this.execListener;
    }

    public boolean isActive() {
        return this.active;
    }

    public synchronized boolean isDependentExists(String taskName) {
        Object dependencyTracker = this.taskDependents.get(taskName);
        if (dependencyTracker instanceof List) {
            List dependentList = (List)dependencyTracker;
            if (dependentList == null || dependentList.isEmpty()) {
                return false;
            }
        } else if (dependencyTracker instanceof WaitTask) {
            WaitTask wait = (WaitTask)dependencyTracker;
            return wait.hasActiveDependencies();
        }
        return true;
    }

    public synchronized boolean isTaskThreadExists(String taskName) {
        Set taskSet = this.taskDependents.keySet();
        return taskSet.contains(taskName);
    }

    public synchronized void markDependencyAsFailed(String taskName, String dependentName) {
        Object dependencyTracker = this.taskDependents.get(taskName);
        if (dependencyTracker instanceof WaitTask) {
            WaitTask wait = (WaitTask)dependencyTracker;
            wait.markAsFailure(dependentName);
        }
    }

    public synchronized void markDependencyAsSucceeded(String taskName, String dependentName) {
        Object dependencyTracker = this.taskDependents.get(taskName);
        if (dependencyTracker instanceof WaitTask) {
            WaitTask wait = (WaitTask)dependencyTracker;
            wait.markAsSuccess(dependentName);
        }
    }

    public synchronized boolean removeWaitDependency(String taskName) {
        return this.taskDependents.remove(taskName) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeStartThread() {
        Object object = this.startThreadWait;
        synchronized (object) {
            if (this.resumeCounter < 0) {
                this.startThreadWait.notify();
            } else {
                ++this.resumeCounter;
            }
        }
    }

    public void setEngineListener(ETLEngineListener listener) {
        this.execListener = listener;
    }

    public void stopETLEngine() {
        this.active = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspendStartThread() {
        Object object = this.startThreadWait;
        synchronized (object) {
            if (this.resumeCounter > 0) {
                this.resumeCounter = 0;
            } else {
                --this.resumeCounter;
                try {
                    this.startThreadWait.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.resumeCounter = 0;
            }
        }
    }
}

