/*
 * Decompiled with CFR 0.152.
 */
package com.sun.etl.engine.impl;

import com.sun.etl.engine.ETLTaskNode;
import com.sun.etl.engine.impl.SimpleTask;
import com.sun.etl.engine.utils.ETLException;
import com.sun.etl.engine.utils.MessageManager;
import com.sun.sql.framework.utils.Logger;
import com.sun.sql.framework.utils.StringUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.ListIterator;

public class CommitTask
extends SimpleTask {
    private static final String LOG_CATEGORY = CommitTask.class.getName();
    private static final MessageManager MSG_MGR = MessageManager.getManager("com.sun.etl.engine.impl");
    private ETLTaskNode taskNode;

    public void cleanUp() {
        this.taskNode = null;
        super.cleanUp();
    }

    public void handleException(ETLException ex) {
        Logger.print(10000, LOG_CATEGORY, this.DN + "Handling Exception for commit task....");
        Logger.printThrowable(40000, LOG_CATEGORY, this, "Caught exception while processing commit task", ex);
    }

    public String process(ETLTaskNode node) throws ETLException {
        if (node == null) {
            throw new ETLException("No associated task node - cannot obtain commit list!");
        }
        this.taskNode = node;
        if (!StringUtil.isNullString(node.getDisplayName())) {
            this.DN = this.DN + " <" + node.getDisplayName().trim() + ">";
        }
        String status = "Success";
        int commitCt = 0;
        int closeCt = 0;
        List connCommitList = this.taskNode.getParent().getContext().getConnectionListToCommit();
        String startMsg = MSG_MGR.getString("MSG_commit_attempt", new Integer(connCommitList.size()));
        Logger.print(10000, LOG_CATEGORY, this.DN + startMsg);
        node.fireETLEngineLogEvent(startMsg);
        ListIterator iter = connCommitList.listIterator();
        while (iter.hasNext()) {
            Connection victim = (Connection)iter.next();
            try {
                if (!victim.getAutoCommit()) {
                    victim.commit();
                    String commitMsg = MSG_MGR.getString("MSG_commit_success", new Integer(iter.nextIndex()));
                    node.fireETLEngineLogEvent(commitMsg);
                    ++commitCt;
                    continue;
                }
                String errMsg = MSG_MGR.getString("MSG_commit_autocommitted", new Integer(iter.nextIndex()));
                node.fireETLEngineLogEvent(errMsg);
            }
            catch (SQLException ex) {
                String errMsg = MSG_MGR.getString("MSG_commit_exception", ex.getMessage());
                node.fireETLEngineLogEvent(errMsg);
                status = "Exception";
                throw new ETLException(errMsg, ex);
            }
            finally {
                this.taskNode.getContext().closeAndReleaseLater(victim);
                ++closeCt;
                String markMsg = MSG_MGR.getString("MSG_commit_marked", new Integer(iter.nextIndex()));
                Logger.print(10000, LOG_CATEGORY, this.DN + markMsg);
            }
        }
        String doneMsg = MSG_MGR.getString("MSG_commit_finished");
        this.taskNode.fireETLEngineLogEvent(doneMsg);
        doneMsg = MSG_MGR.getString("MSG_commit_finished_specs", new Integer(commitCt), new Integer(closeCt));
        Logger.print(10000, LOG_CATEGORY, this.DN + doneMsg);
        return status;
    }
}

