/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mw.jco.util;

import com.sap.mw.jco.util.BasicSAPConverter;
import com.sap.mw.jco.util.SAPCharToByteConverter;

public class SAPCharToUTF8ByteConverter
extends BasicSAPConverter
implements SAPCharToByteConverter {
    protected SAPCharToUTF8ByteConverter(String charEncoding) {
        super(charEncoding);
        this.codepageType = 1;
    }

    public int convert(char[] in, int inBeginIndex, int inEndIndex, byte[] out, int outBeginIndex, int outEndIndex) {
        if (in == null) {
            return 0;
        }
        if (inBeginIndex < 0) {
            return 0;
        }
        if (inBeginIndex >= in.length) {
            return 0;
        }
        if (inEndIndex >= in.length) {
            inEndIndex = in.length - 1;
        }
        if (inBeginIndex > inEndIndex) {
            return 0;
        }
        if (out == null) {
            return 0;
        }
        if (outBeginIndex < 0) {
            return 0;
        }
        if (outBeginIndex >= out.length) {
            return 0;
        }
        if (outEndIndex >= out.length) {
            outEndIndex = out.length - 1;
        }
        if (outBeginIndex > outEndIndex) {
            return 0;
        }
        int inIndex = inBeginIndex;
        int outIndex = outBeginIndex;
        while (inIndex <= inEndIndex && outIndex <= outEndIndex) {
            if (in[inIndex] < '\u0080') {
                out[outIndex++] = (byte)in[inIndex++];
                continue;
            }
            if (in[inIndex] < '\u0800') {
                if (outIndex == outEndIndex) break;
                out[outIndex++] = (byte)(in[inIndex] >> 6 | 0xC0);
                out[outIndex++] = (byte)(in[inIndex++] & 0x3F | 0x80);
                continue;
            }
            if (in[inIndex] < '\ud800' || in[inIndex] > '\udfff') {
                if (outIndex + 2 > outEndIndex) break;
                out[outIndex++] = (byte)(in[inIndex] >> 12 | 0xE0);
                out[outIndex++] = (byte)(in[inIndex] >> 6 & 0x3F | 0x80);
                out[outIndex++] = (byte)(in[inIndex++] & 0x3F | 0x80);
                continue;
            }
            if (in[inIndex] > '\udbff') {
                out[outIndex++] = 35;
                ++inIndex;
                continue;
            }
            if (inIndex == inEndIndex) {
                out[outIndex++] = 35;
                break;
            }
            if (in[inIndex + 1] < '\udc00' || in[inIndex + 1] > '\udfff') {
                out[outIndex++] = 35;
                ++inIndex;
                continue;
            }
            if (outIndex + 3 > outEndIndex) break;
            int charid = ((in[inIndex] & 0x3FF) << 10 | in[inIndex + 1] & 0x3FF) + 65536;
            out[outIndex++] = (byte)(charid >> 18 | 0xF0);
            out[outIndex++] = (byte)(charid >> 12 & 0x3F | 0x80);
            out[outIndex++] = (byte)(charid >> 6 & 0x3F | 0x80);
            out[outIndex++] = (byte)(charid & 0x3F | 0x80);
            inIndex += 2;
        }
        return outIndex - outBeginIndex;
    }

    public byte[] convert(char[] in, int inBeginIndex, int inEndIndex) {
        if (in == null) {
            return new byte[0];
        }
        if (inBeginIndex < 0) {
            return new byte[0];
        }
        if (inBeginIndex >= in.length) {
            return new byte[0];
        }
        if (inEndIndex >= in.length) {
            inEndIndex = in.length - 1;
        }
        if (inBeginIndex > inEndIndex) {
            return new byte[0];
        }
        int outLength = this.outLength(in, inBeginIndex, inEndIndex);
        byte[] out = new byte[outLength];
        this.convert(in, inBeginIndex, inEndIndex, out, 0, outLength - 1);
        return out;
    }

    public byte[] convert(char[] in) {
        if (in == null) {
            return new byte[0];
        }
        int outLength = this.outLength(in, 0, in.length - 1);
        byte[] out = new byte[outLength];
        this.convert(in, 0, in.length - 1, out, 0, outLength - 1);
        return out;
    }

    public int outLength(char[] in, int inBeginIndex, int inEndIndex) {
        if (in == null) {
            return 0;
        }
        if (inBeginIndex < 0) {
            return 0;
        }
        if (inBeginIndex >= in.length) {
            return 0;
        }
        if (inEndIndex >= in.length) {
            inEndIndex = in.length - 1;
        }
        if (inBeginIndex > inEndIndex) {
            return 0;
        }
        int outLength = 0;
        int inIndex = inBeginIndex;
        while (inIndex <= inEndIndex) {
            if (in[inIndex] < '\u0080') {
                ++outLength;
                ++inIndex;
                continue;
            }
            if (in[inIndex] < '\u0800') {
                outLength += 2;
                ++inIndex;
                continue;
            }
            if (in[inIndex] < '\ud800' || in[inIndex] > '\udfff') {
                outLength += 3;
                ++inIndex;
                continue;
            }
            if (in[inIndex] > '\udbff') {
                ++outLength;
                ++inIndex;
                continue;
            }
            if (inIndex == inEndIndex) {
                ++outLength;
                break;
            }
            if (in[inIndex + 1] < '\udc00' || in[inIndex + 1] > '\udfff') {
                ++outLength;
                ++inIndex;
                continue;
            }
            outLength += 4;
            inIndex += 2;
        }
        return outLength;
    }

    public int outLength(char[] in) {
        if (in == null) {
            return 0;
        }
        return this.outLength(in, 0, in.length - 1);
    }
}

