/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mw.jco.util;

import com.sap.jdsr.writer.DsrFactory;
import com.sap.jdsr.writer.DsrIMainRecord;
import com.sap.jdsr.writer.DsrIPassport;
import com.sap.jdsr.writer.DsrIRecordSet;
import com.sap.mw.jco.JCO;

public class Dsr {
    private static String dsrCompName = "SAP Java Connector";
    private static final byte INITED = 1;
    private static final byte DSR_IN_CLASSPATH = 2;
    private static final byte RFC_DSR_INITED = 4;
    private static final byte DSR_STATE_ON = 8;
    public static final int DSR_ACTION_CLIENT_EXECUTE = 0;
    public static final int DSR_ACTION_SERVER_DISPATCH = 1;
    private static final String[] action_info = new String[]{"JCO.Client.execute", "JCO.Server.dispatchRequest"};
    private int action_type = 0;
    private static byte dsr_state = 0;
    private DsrIRecordSet dsrRecordSet;
    private DsrIMainRecord dsrMainRecord;
    private DsrIPassport dsrPassport;

    public static void setDsrComponentName(String dsrName) {
        if (dsrName != null && dsrName.length() > 0) {
            dsrCompName = dsrName;
        }
    }

    public static void setState(String value) {
        if (value == null) {
            return;
        }
        if ("1".equals(value)) {
            if (!Dsr.initDsr()) {
                JCO.fireTrace(1, "[JAV-LAYER] jDSR library not found in CLASSPATH. Please check CLASSPATH.");
                throw new JCO.Exception(150, "JCO_ERROR_DSR_LOAD_ERROR", "jDSR library not found in CLASSPATH. Please check CLASSPATH.");
            }
            if ((dsr_state & 4) == 0) {
                try {
                    dsr_state = (byte)(dsr_state | 4);
                    Dsr.nativeInitRfcDsr(dsrCompName);
                }
                catch (Exception ex) {
                    JCO.fireTrace(1, "[JAV-LAYER] DSR init of dsr context in native layer caused: " + ex.toString());
                }
            }
            dsr_state = (byte)(dsr_state | 8);
            JCO.setMiddlewareProperty("jco.middleware.mode", "1");
        } else if ("0".equals(value)) {
            dsr_state = (byte)(dsr_state & 0xFFFFFFF7);
        }
    }

    public static Dsr createMonitor() {
        if (dsr_state == 15) {
            return new Dsr();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean initDsr() {
        block5: {
            if ((dsr_state & 1) == 0) {
                try {
                    try {
                        Class.forName("com.sap.jdsr.writer.DsrFactory");
                        dsr_state = (byte)(dsr_state | 2);
                    }
                    catch (Exception ex) {
                        Object var2_1 = null;
                        dsr_state = (byte)(dsr_state | 1);
                        break block5;
                    }
                    Object var2 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    dsr_state = (byte)(dsr_state | 1);
                    throw throwable;
                }
                dsr_state = (byte)(dsr_state | 1);
            }
        }
        if ((dsr_state & 2) == 0) return false;
        return true;
    }

    public void openDsrRecord(long handle, int action_type, byte[] passport_bytes, long start_time) {
        int trace_level = JCO.getTraceLevel();
        if (trace_level > 4) {
            JCO.fireTrace(5, "[JAV-LAYER] openDsrRecord for connection with handle " + handle + " [enter]");
        }
        if (passport_bytes != null) {
            if (this.dsrPassport == null) {
                this.dsrPassport = DsrFactory.makeDsrPassport();
            }
            if (this.dsrRecordSet == null) {
                if (action_type == 1) {
                    this.dsrRecordSet = DsrFactory.makeDsrRecordSet((String)dsrCompName);
                } else {
                    this.dsrPassport.setByNetPassport(passport_bytes);
                    this.dsrRecordSet = DsrFactory.makeDsrRecordSet((String)this.dsrPassport.getCompName());
                }
            }
            this.dsrRecordSet.getCertRecord().setByNetPassport(passport_bytes);
            this.dsrMainRecord = this.dsrRecordSet.getMainRecord();
            this.dsrMainRecord.setStartTime(start_time);
        } else if (trace_level > 0) {
            JCO.fireTrace(1, "[JAV-LAYER] openDsrRecord(): passport isn't set");
        }
        if (trace_level > 4) {
            JCO.fireTrace(5, "[JAV-LAYER] openDsrRecord for connection with handle " + handle + "   [leave]");
        }
    }

    public void closeDsrRecord(long handle, int dsr_action, String rfm_name, long time_total, long time_middleware, long time_handle_request, long num_sent_bytes, long num_received_bytes) {
        int trace_level = JCO.getTraceLevel();
        boolean isWritten = false;
        if (trace_level > 4) {
            JCO.fireTrace(5, "[JAV-LAYER] closeDsrRecord for connection with handle " + handle + "  [enter]");
        }
        if (this.dsrMainRecord != null) {
            this.dsrMainRecord.setAction(action_info[dsr_action]);
            this.dsrMainRecord.setActionType(dsr_action);
            this.dsrMainRecord.setRespTime((int)time_total);
            this.dsrMainRecord.setCpuTime(0);
            this.dsrMainRecord.setWaitTime(dsr_action == 0 ? (int)time_middleware : (int)time_handle_request);
            StringBuffer addInfo = new StringBuffer("Calling rfc module ");
            addInfo.append(rfm_name);
            addInfo.append(" [bytes received ");
            addInfo.append(num_received_bytes);
            addInfo.append(", bytes sent ");
            addInfo.append(num_sent_bytes);
            addInfo.append("]");
            this.dsrMainRecord.setAddInfo(addInfo.toString());
            this.dsrMainRecord.setGenTime(0);
            this.dsrMainRecord.setLoadTime(0);
            this.dsrMainRecord.setMaxMem(0);
            this.dsrMainRecord.setNetTime(0);
            this.dsrMainRecord.setService(0);
            this.dsrMainRecord.setTransId(this.dsrPassport.getTransId());
            isWritten = this.dsrRecordSet.write();
        }
        if (!isWritten) {
            JCO.fireTrace(1, "[JAV-LAYER] Dsr Recordset cannot be written.");
        }
        if (trace_level > 4) {
            JCO.fireTrace(5, "[JAV-LAYER] writeDsrRecord for connection with handle " + handle + " returns " + isWritten);
        }
        this.dsrRecordSet.clear();
        this.dsrMainRecord.clear();
        this.dsrPassport.clear();
        if (trace_level > 4) {
            JCO.fireTrace(5, "[JAV-LAYER] closeDsrRecord for connection with handle " + handle + "  [leave]");
        }
    }

    protected static native void nativeInitRfcDsr(String var0);
}

