/*
 * Decompiled with CFR 0.152.
 */
package com.sun.encoder.hl7.xsdbuilder;

import com.sun.encoder.codegen.Emit;
import com.sun.encoder.hl7.xsdbuilder.BaseGenerator;
import com.sun.encoder.hl7.xsdbuilder.GeneratorException;
import com.sun.encoder.hl7.xsdbuilder.NameGenerator;
import com.sun.encoder.hl7.xsdbuilder.XSDGenerator;
import com.sun.encoder.util.UnicodeFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Writer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SegmentsGenerator
extends BaseGenerator
implements XSDGenerator {
    public static final String SEGMENTS_SQL = "com/sun/encoder/hl7/xsdbuilder/segments.sql";
    public static final String SEGMENTFIELDS_SQL = "com/sun/encoder/hl7/xsdbuilder/segmentfields.sql";
    private final NameGenerator mNameGen;

    SegmentsGenerator(Connection conn, String version, File targetLocation, NameGenerator nameGen) {
        super(conn, version, targetLocation);
        this.mNameGen = nameGen;
    }

    /*
     * Loose catch block
     */
    @Override
    public void generate() throws GeneratorException {
        block25: {
            SQLException e2222;
            SQLException expRet;
            ResultSet rs;
            Statement pstmtOneSegment;
            Statement pstmtAllSegments;
            block22: {
                pstmtAllSegments = null;
                pstmtOneSegment = null;
                rs = null;
                Emit emit = null;
                emit = new Emit(this.getWriter(), 0, 4);
                this.printHeader(emit);
                String sqlAllSegments = this.getSQLStmt(SEGMENTS_SQL);
                pstmtAllSegments = this.mConn.prepareStatement(sqlAllSegments, 1004, 1007);
                pstmtAllSegments.setString(1, this.mHL7Version);
                rs = pstmtAllSegments.executeQuery();
                String sqlOneSegment = this.getSQLStmt(SEGMENTFIELDS_SQL);
                pstmtOneSegment = this.mConn.prepareStatement(sqlOneSegment, 1004, 1007);
                ArrayList<String> allSegments = new ArrayList<String>();
                rs.beforeFirst();
                while (rs.next()) {
                    String seg_code = rs.getString("seg_code");
                    System.out.println(seg_code);
                    if (!this.printOneSegment((PreparedStatement)pstmtOneSegment, emit, seg_code)) continue;
                    allSegments.add(seg_code);
                }
                this.printFooter(emit, allSegments);
                emit.flush();
                emit.close();
                emit = null;
                this.moveFile(this.getTempTargetFile(), this.getTargetFile());
                Object var10_11 = null;
                expRet = null;
                if (rs == null) break block22;
                try {
                    rs.close();
                }
                catch (SQLException e2222) {
                    expRet = e2222;
                }
            }
            if (pstmtAllSegments != null) {
                try {
                    pstmtAllSegments.close();
                }
                catch (SQLException e2222) {
                    expRet = e2222;
                }
            }
            if (pstmtOneSegment != null) {
                try {
                    pstmtOneSegment.close();
                }
                catch (SQLException e2222) {
                    expRet = e2222;
                }
            }
            this.getTempTargetFile().delete();
            if (expRet != null) {
                throw new GeneratorException(expRet);
            }
            break block25;
            {
                catch (IOException e3) {
                    throw new GeneratorException(e3);
                }
                catch (SQLException e4) {
                    throw new GeneratorException(e4);
                }
            }
            catch (Throwable throwable) {
                SQLException e2222;
                Object var10_12 = null;
                expRet = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e2222) {
                        expRet = e2222;
                    }
                }
                if (pstmtAllSegments != null) {
                    try {
                        pstmtAllSegments.close();
                    }
                    catch (SQLException e2222) {
                        expRet = e2222;
                    }
                }
                if (pstmtOneSegment != null) {
                    try {
                        pstmtOneSegment.close();
                    }
                    catch (SQLException e2222) {
                        expRet = e2222;
                    }
                }
                this.getTempTargetFile().delete();
                if (expRet != null) {
                    throw new GeneratorException(expRet);
                }
                throw throwable;
            }
        }
    }

    private void printHeader(Emit emit) {
        emit.emit("<?xml version =\"1.0\" encoding=\"UTF-8\"?>");
        emit.down("<!--");
        emit.emit("v2.xml Message Definitions Version v" + this.mHL7Version + "  - segments");
        emit.emit("Copyright (C) Sun Microsystems. All rights reserved.");
        emit.done("-->");
        emit.down("<xsd:schema");
        emit.emit("xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
        emit.emit("xmlns=\"urn:hl7-org:v2xml\"");
        emit.emit("xmlns:hl7=\"urn:com.sun:encoder-hl7-1.0\"");
        emit.emit("targetNamespace=\"urn:hl7-org:v2xml\" xmlns:jaxb=\"http://java.sun.com/xml/ns/jaxb\" jaxb:version=\"2.0\">");
        emit.emit();
        emit.emit("<!-- include fields definitions for version v" + this.mHL7Version + " -->");
        emit.emit("<xsd:include schemaLocation=\"fields.xsd\"/>");
        emit.emit();
        emit.down("<xsd:annotation>");
        emit.down("<xsd:appinfo source=\"urn:com.sun:encoder\">");
        emit.emit("<encoding xmlns=\"urn:com.sun:encoder\" name=\"HL7 v2 Encoding\" namespace=\"urn:com.sun:encoder-hl7-1.0\" style=\"hl7encoder-1.0\"/>");
        emit.done("</xsd:appinfo>");
        emit.done("</xsd:annotation>");
        emit.emit();
    }

    private void printFooter(Emit emit, List<String> allSegments) {
        emit.emit("<!-- .. all HL7 segment definitions -->");
        emit.down("<xsd:complexType name=\"anyHL7Segment.TYPE\">");
        emit.down("<xsd:choice>");
        Iterator<String> iter = allSegments.iterator();
        while (iter.hasNext()) {
            emit.emit("<xsd:element ref=\"" + iter.next() + "\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>");
        }
        emit.done("</xsd:choice>");
        emit.done("</xsd:complexType>");
        emit.emit("<xsd:element name=\"anyHL7Segment\" type=\"anyHL7Segment.TYPE\"/>");
        emit.emit("<!-- .. any Z segment definition -->");
        emit.down("<xsd:complexType name=\"anyZSegment.TYPE\">");
        emit.down("<xsd:sequence>");
        emit.emit("<xsd:any processContents=\"lax\" namespace=\"##any\"/>");
        emit.done("</xsd:sequence>");
        emit.done("</xsd:complexType>");
        emit.emit("<xsd:element name=\"anyZSegment\" type=\"anyZSegment.TYPE\"/>");
        emit.done("</xsd:schema>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean printOneSegment(PreparedStatement pstmt, Emit emit, String seg_code) throws SQLException {
        pstmt.setString(1, this.mHL7Version);
        pstmt.setString(2, seg_code);
        ResultSet rs = null;
        try {
            StringBuffer sb = new StringBuffer();
            rs = pstmt.executeQuery();
            rs.beforeFirst();
            boolean printStart = false;
            int seq_no = 1;
            while (rs.next()) {
                if (!printStart) {
                    emit.down("<!--");
                    emit.emit("SEGMENT " + seg_code);
                    emit.done("-->");
                    sb.setLength(0);
                    String ctName = seg_code + ".CONTENT";
                    emit.down(sb.append("<xsd:complexType name=\"").append(ctName).append("\">").toString());
                    if (!this.mNameGen.nameExists(ctName)) {
                        this.mNameGen.markUsed(ctName);
                    } else {
                        emit.down("<xsd:annotation>");
                        SegmentsGenerator.printJAXBCustomization(emit, this.mNameGen.suggestClassName(ctName));
                        emit.done("</xsd:annotation>");
                    }
                    emit.down("<xsd:sequence>");
                    printStart = true;
                }
                String elemName = seg_code + "." + seq_no;
                ++seq_no;
                String minOccurs = "R".equals(rs.getString("req_opt")) ? "1" : "0";
                String maxOccurs = "Y".equals(rs.getString("repetitional")) ? "unbounded" : "1";
                sb.setLength(0);
                emit.emit(sb.append("<xsd:element ref=\"").append(elemName).append("\" minOccurs=\"" + minOccurs + "\" maxOccurs=\"" + maxOccurs + "\"/>").toString());
            }
            if (printStart) {
                emit.emit("<xsd:any processContents=\"lax\" namespace=\"##other\" minOccurs=\"0\"/>");
                emit.done("</xsd:sequence>");
                emit.done("</xsd:complexType>");
                if (!this.mNameGen.nameExists(seg_code)) {
                    emit.emit("<xsd:element name=\"" + seg_code + "\" type=\"" + seg_code + ".CONTENT\"/>");
                    this.mNameGen.markUsed(seg_code);
                } else {
                    emit.down("<xsd:element name=\"" + seg_code + "\" type=\"" + seg_code + ".CONTENT\">");
                    emit.down("<xsd:annotation>");
                    SegmentsGenerator.printJAXBCustomization(emit, this.mNameGen.suggestClassName(seg_code));
                    emit.done("</xsd:annotation>");
                    emit.done("</xsd:element>");
                }
                boolean bl = true;
                return bl;
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
        return false;
    }

    private Writer getWriter() throws FileNotFoundException, IOException {
        return UnicodeFile.makeOutputWriter((File)this.getTempTargetFile());
    }

    private File getTempTargetFile() {
        return new File(this.mTargetLocation, "segments.xsd.~temp");
    }

    private File getTargetFile() {
        return new File(this.mTargetLocation, "segments.xsd");
    }
}

