/*
 * Decompiled with CFR 0.152.
 */
package com.sun.encoder.hl7.xsdbuilder;

import com.sun.encoder.hl7.xsdbuilder.BaseGenerator;
import com.sun.encoder.hl7.xsdbuilder.DataTypesGenerator;
import com.sun.encoder.hl7.xsdbuilder.FieldsGenerator;
import com.sun.encoder.hl7.xsdbuilder.GeneratorException;
import com.sun.encoder.hl7.xsdbuilder.HL7DBConnection;
import com.sun.encoder.hl7.xsdbuilder.MessagesGenerator;
import com.sun.encoder.hl7.xsdbuilder.NameGenerator;
import com.sun.encoder.hl7.xsdbuilder.SegmentsGenerator;
import java.io.File;
import java.sql.SQLException;

public class MainGenerator {
    public void generate(String dbFileLocation, String targetLocation, String version) throws GeneratorException {
        HL7DBConnection hl7DBConn = null;
        try {
            hl7DBConn = new HL7DBConnection(dbFileLocation);
            File fileLocation = new File(targetLocation);
            NameGenerator nameGen = new NameGenerator();
            fileLocation.mkdirs();
            BaseGenerator generator = new DataTypesGenerator(hl7DBConn.getConn(), version, fileLocation, nameGen);
            generator.generate();
            generator = new FieldsGenerator(hl7DBConn.getConn(), version, fileLocation, nameGen);
            generator.generate();
            generator = new SegmentsGenerator(hl7DBConn.getConn(), version, fileLocation, nameGen);
            generator.generate();
            generator = new MessagesGenerator(hl7DBConn.getConn(), version, fileLocation, nameGen);
            generator.generate();
        }
        catch (ClassNotFoundException e) {
            throw new GeneratorException(e);
        }
        catch (SQLException e) {
            throw new GeneratorException(e);
        }
        finally {
            if (hl7DBConn != null) {
                try {
                    hl7DBConn.close();
                }
                catch (SQLException e) {
                    throw new GeneratorException(e);
                }
            }
        }
    }

    public static void main(String[] args) {
        String dbLocation = null;
        String outputLocation = null;
        String version = null;
        version = "2.5";
        dbLocation = System.getProperty("ENCODER_SHAREDLIBRARY") + "hl7/metadata/hl7_56.mdb";
        outputLocation = System.getProperty("ENCODER_SHAREDLIBRARY") + "hl7/dist/xsd/" + version;
        for (int i = 0; args != null && i < args.length; ++i) {
            if ("-i".equals(args[i])) {
                dbLocation = args[i + 1];
                continue;
            }
            if ("-o".equals(args[i])) {
                outputLocation = args[i + 1];
                continue;
            }
            if (!"-v".equals(args[i])) continue;
            version = args[i + 1];
        }
        if (dbLocation == null || outputLocation == null || version == null) {
            System.out.println("Usage: java MainGenerator -i <DB location> -o <output location> -v <HL7 version>");
            System.exit(1);
        }
        MainGenerator generator = new MainGenerator();
        try {
            generator.generate(dbLocation, outputLocation, version);
        }
        catch (GeneratorException e) {
            e.printStackTrace();
            System.exit(2);
        }
    }
}

