/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.model.BaseValue;
import com.sun.perseus.model.ElementNode;
import com.sun.perseus.model.RefValues;
import com.sun.perseus.model.TraitAnimationNode;
import org.w3c.dom.DOMException;

abstract class TraitAnim
implements BaseValue {
    String traitType;
    TraitAnimationNode rootAnim;
    ElementNode targetElement;
    String traitName;
    String traitNamespace;
    String specifiedTraitValue;
    boolean active;

    TraitAnim(ElementNode targetElement, String traitNamespace, String traitName, String traitType) {
        if (targetElement == null || traitName == null || traitNamespace == null || traitType == null) {
            throw new NullPointerException();
        }
        this.targetElement = targetElement;
        this.traitNamespace = traitNamespace;
        this.traitName = traitName;
        this.traitType = traitType;
    }

    public String getSpecifiedTraitNS() {
        if (this.specifiedTraitValue == null) {
            this.specifiedTraitValue = this.targetElement.getSpecifiedTraitNSImpl(this.traitNamespace, this.traitName);
        }
        return this.specifiedTraitValue;
    }

    final void restore() {
        if (this.traitNamespace == "#!null/ns@!") {
            this.targetElement.setTraitImpl(this.traitName, this.specifiedTraitValue);
        } else {
            this.targetElement.setTraitNSImpl(this.traitNamespace, this.traitName, this.specifiedTraitValue);
        }
    }

    void addAnimation(TraitAnimationNode newAnim) {
        if (newAnim == null) {
            throw new NullPointerException();
        }
        if (this.rootAnim == null) {
            this.rootAnim = newAnim;
            newAnim.baseVal = this;
            this.targetElement.ownerDocument.activeTraitAnims.addElement(this);
            this.specifiedTraitValue = this.targetElement.getSpecifiedTraitNSImpl(this.traitNamespace, this.traitName);
        } else {
            newAnim.baseVal = this.rootAnim;
            this.rootAnim = newAnim;
        }
        this.active = true;
    }

    void removeAnimation(TraitAnimationNode removedAnim) {
        if (removedAnim == null) {
            throw new NullPointerException();
        }
        if (removedAnim == this.rootAnim) {
            if (removedAnim.baseVal == this) {
                this.targetElement.ownerDocument.activeTraitAnims.removeElement(this);
                this.rootAnim = null;
                this.active = false;
                this.restore();
            } else {
                this.rootAnim = (TraitAnimationNode)removedAnim.baseVal;
            }
        } else if (this.rootAnim != null) {
            TraitAnimationNode prevAnim = null;
            TraitAnimationNode curAnim = this.rootAnim;
            while (curAnim.baseVal != this) {
                if (curAnim.baseVal == removedAnim) {
                    prevAnim = curAnim;
                    break;
                }
                curAnim = (TraitAnimationNode)curAnim.baseVal;
            }
            if (prevAnim != null) {
                prevAnim.baseVal = removedAnim.baseVal;
            }
        }
    }

    final String getTrait(String traitType) throws DOMException {
        if ("string".equals(traitType) || this.traitType.equals(traitType)) {
            return this.getTraitImpl();
        }
        throw this.targetElement.unsupportedTraitTypeNS(this.traitName, this.traitNamespace, traitType);
    }

    protected abstract String getTraitImpl();

    final void setTrait(String value, String traitType) throws DOMException {
        if (!"string".equals(traitType) && !this.traitType.equals(traitType)) {
            throw this.targetElement.unsupportedTraitTypeNS(this.traitName, this.traitNamespace, traitType);
        }
        this.setTraitImpl(value);
    }

    abstract void setTraitImpl(String var1) throws DOMException;

    abstract void apply();

    abstract RefValues toRefValues(TraitAnimationNode var1, String[] var2, String var3, String var4) throws DOMException;

    abstract Object[] sum(Object[] var1, Object[] var2);

    abstract Object[] multiply(Object[] var1, int var2);

    boolean supportsInterpolation() {
        return false;
    }
}

