/* 
 *   Creation Date: <1999/02/22 23:22:17 samuel>
 *   Time-stamp: <2001/03/11 19:17:22 samuel>
 *   
 *	<prom.h>
 *	
 *	Guarded inclusion of <asm/prom.h>
 *   
 *   Copyright (C) 1999, 2000 Samuel Rydh (samuel@ibrium.se)
 *   
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation
 *   
 */

#ifndef _H_PROM
#define _H_PROM

typedef void *p_phandle_t;

typedef struct p_address_range {
	unsigned int space;
	unsigned int address;
	unsigned int size;
} p_address_range_t;

typedef struct p_interrupt_info {
	int	line;
	int	sense;		/* +ve/-ve logic, edge or level, etc. */
} p_interrupt_info_t;

typedef struct p_property {
	char	*name;
	int	length;
	unsigned char *value;
	struct p_property *next;
} p_property_t;

typedef struct mol_device_node {
	char			*name;
	char			*type;
	p_phandle_t		node;
	int			n_addrs;
	p_address_range_t	*addrs;
	int			n_intrs;
	p_interrupt_info_t	*intrs;
	char			*full_name;
	char			*unit_string;
	struct	p_property 	*properties;
	struct	mol_device_node *parent;
	struct	mol_device_node *child;
	struct	mol_device_node *sibling;
	struct	mol_device_node *next;		/* next device of same type */
	struct	mol_device_node *allnext;	/* next in list of all nodes */
} mol_device_node_t;

#endif   /* _H_PROM */


