/* 
 *   Creation Date: <1999/03/29 11:09:18 samuel>
 *   Time-stamp: <2001/06/21 12:05:47 samuel>
 *   
 *	<default_options.h>
 *	
 *	Default resources 
 *   
 *   Copyright (C) 1999, 2000, 2001 Samuel Rydh (samuel@ibrium.se)
 *   
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation
 *   
 */

static char helpstr[] =
	"usage: startmol [OPTIONS]\n"
	"Boots MacOS, <http://www.maconlinux.org>\n\n"
	" -h, --help\t\tprint this help text\n"
	" -d, --debug\t\tactivate debugger nub\n"
	" -V\t\t\tprint version info\n"
	"     --ram=SIZE\t\tRAM size (in Mb)\n"
	"     --vt=num\t\twanted vt number\n"
	" --test\t\trun self-test\n"
	" --elf=image Run static ELF-image inside MOL\n"
	"\nThis program must be run with root privileges. "
	"Report bugs to <samuel@ibrium.se>\n";

enum{ 
	optRamSize=1000, optVTNum, optSessNum, optTest, optElfImage
};

static struct option opt[] = {
	{"help",	0, 0, 'h'},
	{"ram",		1, 0, optRamSize },
	{"debug",	0, 0, 'd' },
	{"vt",		1, 0, optVTNum },
	{"session",	1, 0, optSessNum },
	{"test",	0, 0, optTest },
	{"elfimage",	1, 0, optElfImage },
	{0,0,0,0}
};

struct opt_res_entry {
	int	opt_code;
	int	root_only;	/* true if allowed for root only */
	char	*res_name;
};

/* option code -> resource name */
/* IMPORTANT: don't forget security issues... */
static struct opt_res_entry or_table[] = {
	{optRamSize,	0, "ram_size"},
	{optVTNum,	0, "vt"},
	{optVTNum,	0, "vt"},
	{optTest,	0, "boot_method: elf" },
	{optTest,	0, "elf_image: bin/selftest" },
	{optElfImage,	1, "boot_method: elf" },
	{optElfImage,	1, "elf_image" },
	{0,0,0}
};

	
