/* 
 *   Creation Date: <2001/06/20 23:03:30 samuel>
 *   Time-stamp: <2001/06/24 18:06:16 samuel>
 *   
 *	<performance.S>
 *	
 *	
 *   
 *   Copyright (C) 2001 Samuel Rydh (samuel@ibrium.se)
 *   
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation
 *   
 */

#include "mol_config.h"
#include "asmdefs.h"
#include "processor.h"
#include "os_interface.h"
		
.macro PRE_
	li	r9,1
1:	mtctr	r9
	mftb	r10
2:
.endm
.macro POST_ str
	bdnz	2b
	mftb	r11
	cmpwi	r9,1
	li	r9,10240
	beq	1b
	.data
4:	.ascii "\str\0"
	.balign	4
	.text
3:	LOADI	r3,4b
	sub	r4,r11,r10
	bl	perf_print
.endm
.macro PRINT str
	.data
10:	.ascii "\str\n\0"
	.balign 4
	.text
	LOADI	r3,10b
	bl	printf
.endm	
.macro PUSH_STACK
	mflr	r0
	stwu	r1,-16(r1)
	stw	r0,20(r1)
.endm
.macro POP_STACK
	lwz	r0,20(r1)
	addi	r1,r1,16
	mtlr	r0
.endm
	
#define PRE PRE_ ; .irp nn,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15 ;
#define POST(str) ; .endr ; POST_ str ; 

	
/************************************************************************/
/*	Test the implementation speed					*/
/************************************************************************/

GLOBL(performance):
	// r6-r8 unmodified by PRE/POST	
	PUSH_STACK
	PRE	nop			POST("nop calibration");

	// Unemulated user instructions
	PRINT "--------- USER MODE ----------"
	PRE	li	r3,3		POST("li");
	PRE	lwz	r3,0(0)		POST("lwz r3,0(0)");
	PRE	lfd	fr3,0(0)	POST("lfd fr3,0(0)");
	PRE	stfd	fr3,0(0)	POST("stfd fr3,0(0)");
	PRE	44: b	44b + 4		POST("b +4");
	PRE	mftb	r3		POST("mftb");
	PRE	mfctr	r3		POST("mfctr");
	PRE	mtlr	r3		POST("mtlr");
	PRE	mflr	r3		POST("mflr");
	PRE	isync			POST("isync");	
	PRE	mfcr	r3		POST("mfcr");
	PRE	mtcrf	1,r3		POST("mtcrf 1,r3");	

	PRINT "--------- PRIVILEGED MODE ----"
	PRE	mfmsr	r3		POST("mfmsr");
	PRE	mfmsr	r3 ; mtmsr r3 	POST("mfmsr r3 . mtmsr r3");
	PRE	tlbie	r3	 	POST("tlbie r3");
	PRE	tlbsync			POST("tlbsync");
	PRE	mfsr	r3,0		POST("mfsr");
	PRE	mtsr	0,r3		POST("mtsr");
	PRE	mfsrin	r3,r4		POST("mfsrin");
	PRE	mtsrin	r3,r4		POST("mtsrin");		
	PRE	mtsrr1  r3		POST("mtsrr1");
	PRE	mfsrr1  r3		POST("mfsrr1");
	PRE	mfdec	r3		POST("mfdec");
	PRE	mtdec	r3		POST("mtdec");
	PRE	mtdbatu	0,r3		POST("mtdbatu 0,r3");
	PRE	mtdbatl	0,r3		POST("mtdbatl 0,r3");
	PRE	mtibatl	0,r3		POST("mtibatu 0,r3");
	PRE	mtibatu	0,r3		POST("mtibatl 0,r3");
	PRE	mfspr r3,HID0	 	POST("mfspr r3, HID0");
	PRE	mtspr HID0,r3	 	POST("mtspr HID0,r3");	
	PRE	mfspr r3,HID1	 	POST("mfspr r3, HID1");
	PRE	mfspr r3,DABR	 	POST("mfspr r3, DBAR");
	POP_STACK
	blr



