/* 
 *   Creation Date: <2001/05/09 23:33:05 samuel>
 *   Time-stamp: <2001/05/12 16:46:05 samuel>
 *   
 *	<depgen.c>
 *	
 *	Hack to generate dependencies
 *   
 *   Copyright (C) 2001 Samuel Rydh (samuel@ibrium.se)
 *   
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation
 *   
 */

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <dirent.h>
#include <fcntl.h>
#include <string.h>

#define MAX_INODES	256

static ino_t		inodes[MAX_INODES];
static int 		num_inodes=0;
static int		verbose = 0;

static char *prefix_list0[] = { "", "include/", "xinclude/", NULL };
static char *prefix_list1[] = { "", "include/", "../include/", "../sinclude/", "xinclude/", NULL };
static char *prefix_list2[] = { "", "include/", "../include/", "../../include/", "../../sinclude/", "xinclude", NULL };

static char *rel_list[] = { "", "include/", "xinclude/", NULL };

int
process_file( char *objname, char *name, char *cosmdir, char **dlist )
{
	struct stat 	st;
	char 		*s, buf[256], buf2[256];
	FILE 		*f;
	int 		i;

	if( num_inodes >= MAX_INODES )
		return 1;

	if( stat( name, &st ) < 0 )
		return -1;

	for(i=0; i<num_inodes; i++ )
		if( inodes[i] == st.st_ino ) {
			// fprintf(stderr, "Same inode\n");
			return 1;
		}
	inodes[num_inodes++] = st.st_ino;

	if( !(f=fopen( name,"ro" )) )
		return -1;

	while( fgets(buf, sizeof(buf), f) ) {
		char **dp, *s2, basename[256];
		int err=-1;

		if( sscanf(buf, "#include %s", buf2 ) != 1 )
			continue;
		if( buf2[0] != '"' )
			continue;
		buf2[ strlen(buf2)-1 ] = 0;
		s = buf2+1;
		
		// search regular include paths
		for( dp=dlist ; *dp ; dp++ ) {
			char ss[256];
			snprintf( ss, sizeof(ss), "%s%s", *dp, s );

			if( !(err=process_file( objname, ss, cosmdir, dlist )) )
				printf("%-20s\t%s\n", objname, ss );
			if( err >= 0 )
				break;
		}
		if( err >= 0 )
			continue;

		// relative pathname?
		strcpy( basename, name );
		if( (s2 = strrchr( basename, '/' )) ) {
			*(++s2)=0;
			strcat( basename, s );
			err = process_file(objname, basename, cosmdir, dlist );
		}

		// search cosmdir relative directories
		for( dp=rel_list ; err < 0 && cosmdir && *dp; dp ++ ) {
			strcpy( basename, cosmdir );
			strcat( basename, *dp );
			strcat( basename, s );
			err = process_file(objname, basename, cosmdir, dlist );
		}
		if( !err ) {
			printf("%-20s\t%s\n", objname, basename );
		}
		
		if( err < 0 && verbose )
			fprintf( stderr, "DEPGEN: '%s' not found (included by %s).\n", name, s );
	}
	return 0;
}


int
main( int argc, char **argv )
{
	DIR	*dir, *dir2;
	struct dirent *de;
	char 	*dirname;
	int 	i, fd;
	char	cosmdir[256];
	char	curdir[256];

	if( argc <= 1 ) {
		fprintf(stderr, "Usage: depgen [-v] dir [dir, ...]\n");
		return 1;
	}
	if( !getcwd(curdir, sizeof(curdir)) ) {
		perror("getcwd");
		return 1;
	}

	for( i=1; i<argc; i++ ) {
		char *prefix = "";
		char **plist;

		// option parsing
		if( argv[i][0] == '-' ){
			if( argv[i][1] == 'v' )
				verbose = 1;
			continue;
		}

		strcpy( cosmdir, argv[i] );
		strcat( cosmdir, "/Makefile");
		if( (fd=open( cosmdir, O_RDONLY )) > 0) {
			close( fd );
			if( chdir( argv[i] ) )
				continue;
			cosmdir[0] = 0;
			dirname = "./";
			freopen(".depend", "w", stdout );
			printf("DEPEND_BUILT := 1\n\n");
		} else {
			// cosmetic sub dir - add obj and relativ prefix
			if( chdir( curdir ))
				continue;
			sprintf( cosmdir, "%s/", argv[i] );
			if( !(dir=opendir(cosmdir)) )
				continue;
			dirname = cosmdir;
			freopen(".depend", "a+", stdout );
			printf("\n# COSMETIC SUBDIR\n\n");
		}

		if( (dir2=opendir("obj/")) ) {
			closedir(dir2);
			prefix = "obj/";
		}
		plist = prefix_list0;
		if( (fd=open("../Rules.make", O_RDONLY)) > 0 ) {
			plist = prefix_list1;
		} else if( (fd=open("../../Rules.make", O_RDONLY)) > 0 ){
			plist = prefix_list2;
		}
		if( fd >= 0 )
			close(fd);

		if( !(dir=opendir( dirname )) )
			continue;	       

		while( (de=readdir(dir)) ){
			char objname[256], namebuf[256];
			char *s = de->d_name;
			int n = strlen(s);

			if( n<=3 || (s[n-1] != 'c' && s[n-1] != 'S') || s[n-2] != '.' )
				continue;
			snprintf( objname, sizeof(objname), "%s%s%s", cosmdir, prefix, de->d_name );
			n = strlen(objname);
			objname[n-2] = 0;
			strcat( objname, ".o:" );
			
			num_inodes = 0;
			strcpy( namebuf, cosmdir );
			strcat( namebuf, de->d_name );
			process_file( objname, namebuf, cosmdir, plist );
		}
		closedir(dir);
	}
	return 0;
}
