/* 
 *   Creation Date: <1999/11/05 20:14:37 samuel>
 *   Time-stamp: <1999/11/07 18:03:01 samuel>
 *   
 *	<phandles.h>
 *	
 *	phandle/ihandle identifiers
 *   
 *   Copyright (C) 1999 Samuel Rydh (samuel@ibrium.se)
 *   
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation
 *   
 */

#ifndef _H_PHANDLES
#define _H_PHANDLES

enum {
	molih_stdin=1,
	molih_stdout,
	molih_memory,
	molih_mmu,
	molih_nvram,
	molih_rtas,
#if 0
	molih_intctrl,			/* interrupt controller */
#endif
	molih__next_free		/* must be last */
};

extern ulong 	ihandle_to_phandle( ulong ihandle );
extern int 	ihandle_to_molih( ulong ihandle );
extern ulong 	molih_to_ihandle( int molih );
extern ulong	phandle_to_ihandle( ulong phandle );
extern int	phandle_to_molih( ulong phandle );

extern ulong 	add_ihandle( int molih, ulong ihandle, ulong phandle );


#endif   /* _H_PHANDLES */
