# -*-makefile -*-
#
#   Creation Date: <1999/03/28 04:20:31 samuel>
#   Time-stamp: <2001/10/16 01:40:23 samuel>
#   
#	<Rules.make>
#	
#	Common rules for recursive make	
#   
#   Copyright (C) 1999, 2000, 2001 Samuel Rydh (samuel@ibrium.se)
#   
#   This program is free software; you can redistribute it and/or
#   modify it under the terms of the GNU General Public License
#   as published by the Free Software Foundation
#

# Path to the kernel source

_KERNEL_TREE	= /usr/src/linux

# don't change these... the install directories are in the Makefile

SHEADERS_PATH 	= $(TOP_DIR)/sinclude
MOL_LIB_DIR	= $(TOP_DIR)/mollib
MOL_BIN_DIR	= $(MOL_LIB_DIR)/bin
MOL_MODULE_DIR	= $(MOL_LIB_DIR)/modules/

CURDIR 		:= $(shell if [ "$$PWD" != "" ]; then echo $$PWD; else pwd; fi)

CC		= gcc
CPP		= cpp
AS		= as
LD		= ld
RM		= rm -f
SMAKE		= $(MAKE) --no-print-directory

CFLAGS		= -pipe
ASMFLAGS	= -D__ASSEMBLY__

# flags for the mol C-objects (-msoft-float, -mmultiple removed)
CFLAGS_MM	= -O3 -Wall
ifdef PROFILE
CFLAGS_MM	= -g -O2 -pg -Wall -mmultiple
endif

#
# Find out where the mol directory is (useful for makefiles in subdirectories)
#
TOP_DIR 	:= $(shell ( test -f $(CURDIR)/Rules.make && cd $(CURDIR) && pwd ) || \
		    ( test -f $(CURDIR)/../Rules.make && cd $(CURDIR)/../ && pwd ) || \
		    ( test -f $(CURDIR)/../../Rules.make && cd $(CURDIR)/../../ && pwd ) || \
			echo TOP_DIR_NOT_FOUND )

DEPGEN		:= $(TOP_DIR)/buildtools/depgen

#
# main target
#
all: 		autodeps sub_dirs $(O_TARGET) $(O_TARGET2) $(P_TARGET) $(P_TARGET2) $(C_TARGET)

utils: 		autodeps


#
# Include dependencies
#
-include .depend
ifdef DEPEND_BUILT
autodeps:	dummy
else
autodeps:	depend
endif

# dummy rule doing nothing
.PHONY: dummy

# we just do something to avoid multiple "nothing-to-do"
# messages for each subdirectory
dummy:
	@true

#
# Implicit rules
#

obj/%.o %.o: %.c
	$(CC) $(CFLAGS) $(CFLAGS_EXTRA) -c -o $@ $<
obj/%.o %.o: %.S
	$(CPP) $(ALTIVEC_FLAGS) $(ASMFLAGS) $(ASMFLAGS_EXTRA) $< | $(AS) $(ALTIVEC_AS) -o $@

ifdef COSM_DIR1
CLEAN_DIRS	+= $(COSM_DIR1) $(COSM_DIR1)/include
$(addprefix $(COSM_DIR1), /obj/%.o /%.o): $(addprefix $(COSM_DIR1), /%.c)
	$(CC) $(CFLAGS) $(CFLAGS_EXTRA) $(CFLAGS_COSM1) -c -o $@ $<
$(addprefix $(COSM_DIR1), /obj/%.o /%.o): $(addprefix $(COSM_DIR1), /%.S)
	$(CPP) $(ALTIVEC_FLAGS) $(ASMFLAGS) $(ASMFLAGS_EXTRA) $(ASMFLAGS_COSM1) $< | $(AS) $(ALTIVEC_AS) -o $@
ifdef COSM_DIR2
CLEAN_DIRS	+= $(COSM_DIR2) $(COSM_DIR2)/include
$(addprefix $(COSM_DIR2), /obj/%.o /%.o): $(addprefix $(COSM_DIR2), /%.c)
	$(CC) $(CFLAGS) $(CFLAGS_EXTRA) $(CFLAGS_COSM2) -c -o $@ $<
$(addprefix $(COSM_DIR2), /obj/%.o /%.o): $(addprefix $(COSM_DIR2), /%.S)
	$(CPP) $(ALTIVEC_FLAGS) $(ASMFLAGS) $(ASMFLAGS_EXTRA) $(ASMFLAGS_COMS2) $< | $(AS) $(ALTIVEC_AS) -o $@
ifdef COSM_DIR3
CLEAN_DIRS	+= $(COSM_DIR3) $(COSM_DIR3)/include
$(addprefix $(COSM_DIR3), /obj/%.o /%.o): $(addprefix $(COSM_DIR3), /%.c)
	$(CC) $(CFLAGS) $(CFLAGS_EXTRA) $(CFLAGS_COSM3) -c -o $@ $<
$(addprefix $(COSM_DIR3), /obj/%.o /%.o): $(addprefix $(COSM_DIR3), /%.S)
	$(CPP) $(ALTIVEC_FLAGS) $(ASMFLAGS) $(ASMFLAGS_EXTRA) $(ASMFLAGS_COMS3) $< | $(AS) $(ALTIVEC_AS) -o $@
ifdef COSM_DIR4
CLEAN_DIRS	+= $(COSM_DIR4) $(COSM_DIR4)/include
$(addprefix $(COSM_DIR4), /obj/%.o /%.o): $(addprefix $(COSM_DIR4), /%.c)
	$(CC) $(CFLAGS) $(CFLAGS_EXTRA) $(CFLAGS_COSM4) -c -o $@ $<
$(addprefix $(COSM_DIR4), /obj/%.o /%.o): $(addprefix $(COSM_DIR4), /%.S)
	$(CPP) $(ALTIVEC_FLAGS) $(ASMFLAGS) $(ASMFLAGS_EXTRA) $(ASMFLAGS_COMS3) $< | $(AS) $(ALTIVEC_AS) -o $@
endif
endif
endif
endif

# Automatic checkout rule for BK
% :: SCCS/s.%
	bk co $<

#
# O_TARGET (.o target)
#
ifdef O_TARGET
$(O_TARGET): $(O_OBJS)
	@rm -f $@
	$(LD) $(LDFLAGS_EXTRA) -r -o $@ $(O_OBJS) $(STATIC_LIBS)
	$(O_TARGET_HOOK)
	$(O_TARGET_HOOK2)
endif

ifdef O_TARGET2
$(O_TARGET2): $(O_OBJS2)
	@rm -f $@
	$(LD) $(LDFLAGS_EXTRA) -r -o $@ $(O_OBJS2)
	$(O_TARGET2_HOOK)
endif

#
# P_TARGET (program target)
#
ifdef P_TARGET
$(P_TARGET): sub_dirs $(O_OBJS)
	$(CC) $(LDFLAGS) $(LDFLAGS_EXTRA) $(LDFLAGS_TARGET1) -o $@ $(O_OBJS) $(STATIC_LIBS)
	$(P_TARGET_HOOK)
endif

ifdef P_TARGET2
$(P_TARGET2): sub_dirs $(O_OBJS2)
	$(CC) $(LDFLAGS) $(LDFLAGS_EXTRA) $(LDFLAGS_TARGET2) -o $@ $(O_OBJS2) $(STATIC_LIBS2)
	$(P_TARGET2_HOOK)
endif

#
# C_TARGET (custom target, no build rules)
#
ifdef C_TARGET
$(C_TARGET): sub_dirs $(O_OBJS)
endif

#
# A rule to make subdirectories
#
sub_dirs: dummy $(patsubst %,_subdir_%,$(SUB_DIRS))

ifdef SUB_DIRS
$(patsubst %,_subdir_%,$(SUB_DIRS)) : dummy $(SUBDIR_DEPS)
	@echo Entering \'$(CURDIR)/$(patsubst _subdir_%,%,$@)\' 
	@$(SMAKE) -C $(patsubst _subdir_%,%,$@)
endif


#
# A cleaning rule
#
clean: 	dummy $(patsubst %,_sdir_clean_%,$(SUB_DIRS))
	@echo Cleaning $(CURDIR)
	@$(RM) *.o obj/*.o *~ .*~ core .depend \
		$(O_TARGET) $(O_TARGET2) $(O_OBJS) $(O_OBJS2) \
		$(P_TARGET) $(P_TARGET2) $(C_TARGET) $(CLEAN_FILES) \
		$(CLEAN_DIRS:=/*~) 2> /dev/null ; true

distclean: $(patsubst %,_sdir_distclean_%,$(SUB_DIRS))
	@$(RM) .depend

ifdef SUB_DIRS
$(patsubst %,_sdir_clean_%,$(SUB_DIRS)) : dummy
	@$(SMAKE) -C $(patsubst _sdir_clean_%,%,$@) clean
$(patsubst %,_sdir_distclean_%,$(SUB_DIRS)) : dummy
	@$(SMAKE) -C $(patsubst _sdir_distclean_%,%,$@) distclean
endif

#
# Dependencies
#

dep: depend

depend: dummy $(patsubst %,_sdir_dep_%,$(SUB_DIRS))
	@test -f $(DEPGEN) || $(SMAKE) -C $(TOP_DIR)/buildtools depgen 
	@echo Building deps in $(CURDIR)
	@$(DEPGEN) $(CURDIR) $(COSM_DIR1) $(COSM_DIR2) $(COSM_DIR3) $(COSM_DIR4) ; true
	@$(DEP_HOOK)

ifdef SUB_DIRS
$(patsubst %,_sdir_dep_%,$(SUB_DIRS)) : dummy
	@$(SMAKE) -C $(patsubst _sdir_dep_%,%,$@) depend
endif


#############################################################
# Common rules for kernel modules
#############################################################

GET_UNAME	= $(TOP_DIR)/scripts/get_uname $(TOP_DIR)

ifndef KERNEL_TREE
KERNEL_TREE	= $(_KERNEL_TREE)
endif
export 		KERNEL_TREE

ifdef KMOD_BUILD

KHEADERS	:= $(KERNEL_TREE)/include
UNAME		:= $(shell $(TOP_DIR)/scripts/get_uname $(TOP_DIR) "$(KERNEL_TREE)")

kuname_check:	dummy
	@[ -n "$(UNAME)" ]

print_uname: kuname_check dummy
	@echo
	@echo ===============================================================
	@echo "   Compiling for $(UNAME) '$(KERNEL_TREE)'"
	@echo ===============================================================
	@echo
endif

