/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.lib.sql;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.xalan.lib.sql.QueryParameter;
import org.apache.xalan.lib.sql.RowSet;
import org.apache.xalan.lib.sql.StreamableNode;
import org.apache.xalan.lib.sql.XConnection;
import org.apache.xpath.axes.ContextNodeList;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;

public class XStatement
extends StreamableNode
implements NodeIterator,
ContextNodeList,
Cloneable {
    private static final boolean DEBUG = false;
    private Statement m_statement;
    private PreparedStatement m_pstatement;
    private int m_nodeCounter = 0;
    ResultSet m_resultSet;
    private XConnection m_xconnection;
    private String m_queryString;
    RowSet m_rowset;
    boolean m_nextHasBeenCalled = false;
    static final String S_DOCELEMENTNAME = "row-set";
    static final String S_COLUMNHEADERNAME = "column-header";
    static final String S_ROWNAME = "row";
    static final String S_COLUMNNAME = "col";
    private int m_last = 0;

    public XStatement(XConnection xConnection, String string) throws SQLException {
        super(null);
        this.m_xconnection = xConnection;
        this.m_statement = this.m_xconnection.m_connection.createStatement();
        this.m_queryString = string;
        this.m_resultSet = this.m_statement.executeQuery(this.m_queryString);
        this.m_rowset = new RowSet(this);
    }

    public XStatement(XConnection xConnection, String string, Vector vector) throws SQLException {
        super(null);
        this.m_xconnection = xConnection;
        this.m_queryString = string;
        this.m_pstatement = this.m_xconnection.m_connection.prepareStatement(this.m_queryString);
        Enumeration enumeration = vector.elements();
        int n = 1;
        while (enumeration.hasMoreElements()) {
            QueryParameter queryParameter = (QueryParameter)enumeration.nextElement();
            this.setParameter(n, this.m_pstatement, queryParameter);
            ++n;
        }
        this.m_resultSet = this.m_pstatement.executeQuery();
        this.m_rowset = new RowSet(this);
        this.m_statement = this.m_pstatement;
    }

    public Object clone() throws CloneNotSupportedException {
        XStatement xStatement = (XStatement)super.clone();
        return xStatement;
    }

    public NodeIterator cloneWithReset() throws CloneNotSupportedException {
        XStatement xStatement = (XStatement)super.clone();
        xStatement.reset();
        return xStatement;
    }

    public void detach() {
        try {
            this.m_statement.close();
            this.m_statement = null;
            this.m_resultSet = null;
        }
        catch (SQLException sQLException) {}
    }

    int getAndIncrementNodeCounter() {
        int n = this.m_nodeCounter++;
        return n;
    }

    public Node getCurrentNode() {
        return this.m_rowset;
    }

    public int getCurrentPos() {
        return 0;
    }

    public boolean getExpandEntityReferences() {
        return true;
    }

    public NodeFilter getFilter() {
        return null;
    }

    public Node getFirstChild() {
        try {
            if (this.getNodeTest().getNamespace() == null && this.getNodeTest().getLocalName().equals(S_DOCELEMENTNAME)) {
                return this.m_rowset;
            }
            return null;
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
            throw nullPointerException;
        }
    }

    public int getLast() {
        return this.m_last;
    }

    public Node getNextSibling() {
        return null;
    }

    public String getNodeName() {
        return "#Document";
    }

    public short getNodeType() {
        return 9;
    }

    public Document getOwnerDocument() {
        return null;
    }

    public Node getParentNode() {
        return null;
    }

    public ResultSet getResultSet() {
        return this.m_resultSet;
    }

    public Node getRoot() {
        return this;
    }

    public Statement getStatement() {
        return this.m_statement;
    }

    public int getWhatToShow() {
        return -17;
    }

    public XStatement getXStatement() {
        return this;
    }

    public boolean hasChildNodes() {
        return true;
    }

    public boolean isFresh() {
        return this.m_nextHasBeenCalled ^ true;
    }

    public Node nextNode() throws DOMException {
        if (!this.m_nextHasBeenCalled) {
            this.m_nextHasBeenCalled = true;
            return this;
        }
        return null;
    }

    public Node previousNode() throws DOMException {
        this.error(80);
        return null;
    }

    public void reset() {
        this.m_nextHasBeenCalled = false;
    }

    public void runTo(int n) {
    }

    public void setCurrentPos(int n) {
    }

    public void setLast(int n) {
        this.m_last = n;
    }

    public void setParameter(int n, PreparedStatement preparedStatement, QueryParameter queryParameter) throws SQLException {
        Number number;
        String string = queryParameter.getType();
        if (string.equalsIgnoreCase("string")) {
            preparedStatement.setString(n, queryParameter.getValue());
        }
        if (string.equalsIgnoreCase("bigdecimal")) {
            preparedStatement.setBigDecimal(n, new BigDecimal(queryParameter.getValue()));
        }
        if (string.equalsIgnoreCase("boolean")) {
            number = new Integer(queryParameter.getValue());
            boolean bl = (Integer)number == 0;
            preparedStatement.setBoolean(n, bl);
        }
        if (string.equalsIgnoreCase("bytes")) {
            preparedStatement.setBytes(n, queryParameter.getValue().getBytes());
        }
        if (string.equalsIgnoreCase("date")) {
            preparedStatement.setDate(n, Date.valueOf(queryParameter.getValue()));
        }
        if (string.equalsIgnoreCase("double")) {
            number = new Double(queryParameter.getValue());
            preparedStatement.setDouble(n, (Double)number);
        }
        if (string.equalsIgnoreCase("float")) {
            number = new Float(queryParameter.getValue());
            preparedStatement.setFloat(n, ((Float)number).floatValue());
        }
        if (string.equalsIgnoreCase("long")) {
            number = new Long(queryParameter.getValue());
            preparedStatement.setLong(n, (Long)number);
        }
        if (string.equalsIgnoreCase("short")) {
            number = new Short(queryParameter.getValue());
            preparedStatement.setShort(n, (Short)number);
        }
        if (string.equalsIgnoreCase("time")) {
            preparedStatement.setTime(n, Time.valueOf(queryParameter.getValue()));
        }
        if (string.equalsIgnoreCase("timestamp")) {
            preparedStatement.setTimestamp(n, Timestamp.valueOf(queryParameter.getValue()));
        }
    }

    public void setShouldCacheNodes(boolean bl) {
    }

    public int size() {
        return 1;
    }

    public String toString() {
        return "XStatement: " + this.m_queryString;
    }
}

