package com.ibm.bsf.util;

import java.util.Hashtable;
import java.io.*;

/**
 * This class loader knows to load a class from the tempDir dir
 * of the environment of the given manager. 
 * 
 * @author   Sanjiva Weerawarana
 */
class BSFClassLoader extends ClassLoader {
  Hashtable cache = new Hashtable ();
  String tempDir = ".";

  // note the non-public constructor - this is only avail within
  // this package.
  BSFClassLoader () {
  }

  public void setTempDir (String tempDir) {
    this.tempDir = tempDir;
  }

  private byte[] loadClassData (String name) throws Exception {
    String fileName = tempDir + File.separatorChar + name + ".class";
    FileInputStream fi = new FileInputStream (fileName);
    byte[] data = new byte[fi.available ()];
    fi.read (data);
    fi.close();
    return data;
  }

  public synchronized Class loadClass (String name, boolean resolve)
                                               throws ClassNotFoundException {
    Class c = (Class) cache.get (name);
    if (c == null) {
      // is it a system class
      try {
	c = findSystemClass (name);
	cache.put (name, c);
	return c;
      } catch (ClassNotFoundException e) {
	// nope
      }
      try {
	byte[] data = loadClassData (name);
	c = defineClass (name, data, 0, data.length);
	cache.put (name, c); 
      } catch (Exception e) {
	e.printStackTrace ();
	throw new ClassNotFoundException ("unable to resolve class '" + 
					  name + "'");
      }
    }
    if (resolve)
      resolveClass (c); 
    return c;  
  }  
}