/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.structures.attributes;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.gjt.jclasslib.structures.AttributeInfo;
import org.gjt.jclasslib.structures.InvalidByteCodeException;
import org.gjt.jclasslib.structures.attributes.LocalVariableTableEntry;

public class LocalVariableTableAttribute
extends AttributeInfo {
    public static final String ATTRIBUTE_NAME = "LocalVariableTable";
    private static final int INITIAL_LENGTH = 2;
    private LocalVariableTableEntry[] localVariableTable;

    public LocalVariableTableEntry[] getLocalVariableTable() {
        return this.localVariableTable;
    }

    public void setLocalVariableTable(LocalVariableTableEntry[] localVariableTableEntryArray) {
        this.localVariableTable = localVariableTableEntryArray;
    }

    public void read(DataInput dataInput) throws InvalidByteCodeException, IOException {
        int n = dataInput.readUnsignedShort();
        this.localVariableTable = new LocalVariableTableEntry[n];
        int n2 = 0;
        while (n2 < n) {
            this.localVariableTable[n2] = LocalVariableTableEntry.create(dataInput, this.classFile);
            ++n2;
        }
        if (this.debug) {
            this.debug("read ");
        }
    }

    public void write(DataOutput dataOutput) throws InvalidByteCodeException, IOException {
        super.write(dataOutput);
        int n = this.getLength(this.localVariableTable);
        dataOutput.writeShort(n);
        int n2 = 0;
        while (n2 < n) {
            this.localVariableTable[n2].write(dataOutput);
            ++n2;
        }
        if (this.debug) {
            this.debug("wrote ");
        }
    }

    public int getAttributeLength() {
        return 2 + this.getLength(this.localVariableTable) * 10;
    }

    protected void debug(String string) {
        super.debug(string + "LocalVariableTable attribute with " + this.getLength(this.localVariableTable) + " entries");
    }
}

