/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.browser;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.gjt.jclasslib.browser.BrowserDetailPane;
import org.gjt.jclasslib.browser.BrowserHistory;
import org.gjt.jclasslib.browser.BrowserServices;
import org.gjt.jclasslib.browser.BrowserTreeNode;
import org.gjt.jclasslib.browser.BrowserTreePane;
import org.gjt.jclasslib.browser.config.window.BrowserPath;
import org.gjt.jclasslib.browser.config.window.CategoryHolder;
import org.gjt.jclasslib.browser.config.window.IndexHolder;
import org.gjt.jclasslib.browser.config.window.PathComponent;
import org.gjt.jclasslib.browser.config.window.ReferenceHolder;
import org.gjt.jclasslib.structures.ClassMember;
import org.gjt.jclasslib.structures.FieldInfo;
import org.gjt.jclasslib.structures.InvalidByteCodeException;
import org.gjt.jclasslib.structures.MethodInfo;

public class BrowserComponent
extends JComponent
implements TreeSelectionListener {
    private BrowserHistory history;
    private BrowserServices services;
    private JSplitPane splitPane;
    private BrowserTreePane treePane;
    private BrowserDetailPane detailPane;

    public BrowserComponent(BrowserServices browserServices) {
        this.services = browserServices;
        this.setupComponent();
    }

    public BrowserTreePane getTreePane() {
        return this.treePane;
    }

    public BrowserDetailPane getDetailPane() {
        return this.detailPane;
    }

    public BrowserHistory getHistory() {
        return this.history;
    }

    public BrowserPath getBrowserPath() {
        TreePath treePath = this.treePane.getTree().getSelectionPath();
        if (treePath == null || treePath.getPathCount() < 3) {
            return null;
        }
        BrowserTreeNode browserTreeNode = (BrowserTreeNode)treePath.getPathComponent(2);
        String string = browserTreeNode.getType();
        if (string.equals("noContent")) {
            return null;
        }
        BrowserPath browserPath = new BrowserPath();
        browserPath.addPathComponent(new CategoryHolder(string));
        int n = browserTreeNode.getIndex();
        if (string.equals("constantPool")) {
            --n;
        }
        if (string.equals("method")) {
            MethodInfo methodInfo = this.services.getClassFile().getMethods()[n];
            this.addClassMemberPathComponent(methodInfo, browserPath, treePath);
        } else if (string.equals("field")) {
            FieldInfo fieldInfo = this.services.getClassFile().getFields()[n];
            this.addClassMemberPathComponent(fieldInfo, browserPath, treePath);
        } else {
            browserPath.addPathComponent(new IndexHolder(n));
        }
        return browserPath;
    }

    /*
     * Unable to fully structure code
     */
    public void setBrowserPath(BrowserPath var1_1) {
        if (var1_1 == null) {
            return;
        }
        var2_2 = var1_1.getPathComponents();
        var3_3 = var2_2.iterator();
        if (!var3_3.hasNext()) {
            return;
        }
        var4_4 = (CategoryHolder)var3_3.next();
        var5_5 = var4_4.getCategory();
        var6_6 = this.treePane.getPathForCategory(var5_5);
        if (var6_6 != null) ** GOTO lbl29
        return;
lbl-1000:
        // 1 sources

        {
            block9: {
                var7_7 = (PathComponent)var3_3.next();
                if (var7_7 instanceof ReferenceHolder) {
                    var9_10 = (ReferenceHolder)var7_7;
                    try {
                        if (var5_5.equals("method")) {
                            var8_8 = this.services.getClassFile().getMethodIndex(var9_10.getName(), var9_10.getType());
                        } else {
                            if (!var5_5.equals("field")) break;
                            var8_8 = this.services.getClassFile().getFieldIndex(var9_10.getName(), var9_10.getType());
                        }
                        break block9;
                    }
                    catch (InvalidByteCodeException var10_11) {
                        break;
                    }
                }
                if (!(var7_7 instanceof IndexHolder)) break;
                var8_8 = ((IndexHolder)var7_7).getIndex();
            }
            if (var8_8 >= (var9_10 = (BrowserTreeNode)var6_6.getLastPathComponent()).getChildCount()) break;
            var6_6 = var6_6.pathByAddingChild(var9_10.getChildAt(var8_8));
lbl29:
            // 2 sources

            ** while (var3_3.hasNext())
        }
lbl30:
        // 5 sources

        var7_7 = this.treePane.getTree();
        var7_7.expandPath(var6_6);
        var7_7.setSelectionPath(var6_6);
        var8_9 = var6_6.getPath();
        if (var8_9.length > 2) {
            var9_10 = new TreePath(new Object[]{var8_9[0], var8_9[1], var8_9[2]});
            var7_7.scrollPathToVisible((TreePath)var9_10);
        }
    }

    public void rebuild() {
        BrowserPath browserPath = this.getBrowserPath();
        JTree jTree = this.treePane.getTree();
        jTree.removeTreeSelectionListener(this);
        this.treePane.rebuild();
        this.history.clear();
        jTree.addTreeSelectionListener(this);
        if (browserPath == null) {
            this.checkSelection();
        } else {
            this.setBrowserPath(browserPath);
        }
    }

    public void checkSelection() {
        JTree jTree = this.treePane.getTree();
        if (this.services.getClassFile() == null) {
            ((CardLayout)this.detailPane.getLayout()).show(this.detailPane, "noContent");
        } else if (jTree.getSelectionPath() == null) {
            BrowserTreeNode browserTreeNode = (BrowserTreeNode)jTree.getModel().getRoot();
            jTree.setSelectionPath(new TreePath(new Object[]{browserTreeNode, browserTreeNode.getFirstChild()}));
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.services.activate();
        TreePath treePath = treeSelectionEvent.getPath();
        this.history.updateHistory(treePath);
        this.showDetailPaneForPath(treePath);
    }

    private void addClassMemberPathComponent(ClassMember classMember, BrowserPath browserPath, TreePath treePath) {
        block3: {
            try {
                browserPath.addPathComponent(new ReferenceHolder(classMember.getName(), classMember.getDescriptor()));
                if (treePath.getPathCount() <= 3) break block3;
                int n = 3;
                while (n < treePath.getPathCount()) {
                    BrowserTreeNode browserTreeNode = (BrowserTreeNode)treePath.getPathComponent(n);
                    browserPath.addPathComponent(new IndexHolder(browserTreeNode.getIndex()));
                    ++n;
                }
            }
            catch (InvalidByteCodeException invalidByteCodeException) {}
        }
    }

    private void showDetailPaneForPath(TreePath treePath) {
        BrowserTreeNode browserTreeNode = (BrowserTreeNode)treePath.getLastPathComponent();
        String string = browserTreeNode.getType();
        this.detailPane.showPane(string, treePath);
    }

    private void setupComponent() {
        this.setLayout(new BorderLayout());
        this.detailPane = new BrowserDetailPane(this.services);
        this.splitPane = new JSplitPane(1, this.buildTreePane(), this.detailPane);
        this.add((Component)this.splitPane, "Center");
    }

    private BrowserTreePane buildTreePane() {
        this.treePane = new BrowserTreePane(this.services);
        JTree jTree = this.treePane.getTree();
        jTree.addTreeSelectionListener(this);
        this.history = new BrowserHistory(this.services);
        return this.treePane;
    }
}

