/*********************************************************************
 *
 *	Copyright (C) 2000 Nathan Fiedler
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * PROJECT:     Utilities
 * MODULE:      Name/Value Pair
 * FILE:        NameValuePair.java
 *
 * AUTHOR:      Nathan Fiedler
 *
 * REVISION HISTORY:
 *      Name    Date            Description
 *      ----    ----            -----------
 *      nf      06/10/00        Initial version
 *
 * DESCRIPTION:
 *      Defines the name/value pair class.
 *
 * $Id: NameValuePair.java,v 1.1 2000/06/29 07:17:36 nfiedler Exp $
 *
 ********************************************************************/

package com.bluemarsh.util;

/**
 * Defines a name/value pair class, a simple data type for holding
 * a name and an associated value.
 *
 * @author  Nathan Fiedler
 * @version 1.0  6/10/00
 */
public class NameValuePair {
    /** Name of the value. */
    private String name;
    /** Value. */
    private Object value;

    /**
     * Constructs a new NameValuePair object.
     *
     * @param  name   Name of value.
     * @param  value  Value.
     */
    public NameValuePair(String name, Object value) {
        this.name = name;
        this.value = value;
    } // NameValuePair

    /**
     * Returns the name of the value.
     *
     * @return  Name of value.
     */
    public String getName() {
        return name;
    } // getName

    /**
     * Returns the value.
     *
     * @return  Value.
     */
    public Object getValue() {
        return value;
    } // getValue
} // NameValuePair
