/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger;

import com.sun.jdi.BooleanValue;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.ClassUnloadEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventIterator;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.event.ExceptionEvent;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.event.MethodExitEvent;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import com.sun.jdi.event.VMStartEvent;
import com.sun.jdi.event.WatchpointEvent;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.ExceptionRequest;
import java.util.ArrayList;
import java.util.Iterator;
import jde.debugger.Application;
import jde.debugger.Debug;
import jde.debugger.Etc;
import jde.debugger.LispForm;
import jde.debugger.Protocol;
import jde.debugger.Rep;
import jde.debugger.ThreadCommands;
import jde.debugger.spec.EventRequestSpec;
import jde.debugger.spec.WatchpointSpec;

public class EventHandler
implements Runnable,
Protocol {
    boolean connected = true;
    final Application app;
    final Integer my_id;
    final Thread thread;
    boolean completed = false;
    boolean resumeApp;

    public EventHandler(Application application) {
        this.app = application;
        this.my_id = application.getId();
        this.thread = new Thread((Runnable)this, "Event Handler for App #" + this.my_id);
        this.thread.start();
    }

    public void shutdown() {
        this.connected = false;
        this.thread.interrupt();
        while (!this.completed) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void run() {
        Object object;
        EventQueue eventQueue = this.app.getEventQueue();
        while (this.connected) {
            try {
                Object object2;
                object = eventQueue.remove();
                this.resumeApp = true;
                ArrayList<Object> arrayList = new ArrayList<Object>();
                EventIterator eventIterator = object.eventIterator();
                while (eventIterator.hasNext()) {
                    object2 = this.handleEvent(eventIterator.nextEvent());
                    if (object2 == null) continue;
                    arrayList.add(object2);
                }
                if (arrayList.size() == 0) {
                    object.resume();
                    continue;
                }
                if (this.resumeApp) {
                    object2 = "none";
                    object.resume();
                } else {
                    switch (object.suspendPolicy()) {
                        case 2: {
                            object2 = "all";
                            break;
                        }
                        case 1: {
                            object2 = "thread";
                            break;
                        }
                        case 0: {
                            object2 = "none";
                            object.resume();
                            break;
                        }
                        default: {
                            object2 = "invalid";
                        }
                    }
                }
                String string = "\"" + (String)object2 + "\"";
                ThreadReference threadReference = this.getCurrentThread((EventSet)object);
                string = threadReference == null ? string + " nil" : string + Protocol.BR + Rep.getThreadRep(threadReference, this.app.getStore());
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    string = string + Protocol.BR + iterator.next();
                }
                this.app.signal("event-set", new LispForm(string));
            }
            catch (InterruptedException interruptedException) {
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                Debug.printIf(vMDisconnectedException);
                this.handleDisconnectedException();
            }
        }
        object = this;
        synchronized (object) {
            this.completed = true;
            this.notifyAll();
        }
    }

    private LispForm handleEvent(Event event) {
        if (event instanceof BreakpointEvent) {
            return this.breakpointEvent((BreakpointEvent)event);
        }
        if (event instanceof StepEvent) {
            return this.stepEvent((StepEvent)event);
        }
        if (event instanceof WatchpointEvent) {
            return this.watchpointEvent((WatchpointEvent)event);
        }
        if (event instanceof ExceptionEvent) {
            return this.exceptionEvent((ExceptionEvent)event);
        }
        if (event instanceof ThreadStartEvent) {
            return this.threadStartEvent((ThreadStartEvent)event);
        }
        if (event instanceof ThreadDeathEvent) {
            return this.threadDeathEvent((ThreadDeathEvent)event);
        }
        if (event instanceof MethodEntryEvent) {
            return this.methodEntryEvent((MethodEntryEvent)event);
        }
        if (event instanceof MethodExitEvent) {
            return this.methodExitEvent((MethodExitEvent)event);
        }
        if (event instanceof ClassPrepareEvent) {
            return this.classPrepareEvent((ClassPrepareEvent)event);
        }
        if (event instanceof VMStartEvent) {
            return this.vmStartEvent((VMStartEvent)event);
        }
        if (event instanceof VMDeathEvent) {
            return this.vmDeathEvent((VMDeathEvent)event);
        }
        if (event instanceof VMDisconnectEvent) {
            return this.vmDisconnectEvent((VMDisconnectEvent)event);
        }
        return this.otherEvent(event);
    }

    private LispForm otherEvent(Event event) {
        this.resumeApp &= true;
        return new LispForm("(list 'jde-dbo-event-other)");
    }

    private void handleDisconnectedException() {
        EventQueue eventQueue = this.app.getEventQueue();
        while (this.connected) {
            try {
                EventSet eventSet = eventQueue.remove();
                EventIterator eventIterator = eventSet.eventIterator();
                while (eventIterator.hasNext()) {
                    Event event = (Event)eventIterator.next();
                    if (event instanceof VMDeathEvent) {
                        this.vmDeathEvent(event);
                        continue;
                    }
                    if (!(event instanceof VMDisconnectEvent)) continue;
                    this.vmDisconnectEvent(event);
                }
            }
            catch (InterruptedException interruptedException) {
                Debug.printIf(interruptedException);
            }
        }
    }

    private ThreadReference getCurrentThread(EventSet eventSet) {
        ThreadReference threadReference;
        if (eventSet.size() > 0) {
            Event event = (Event)eventSet.iterator().next();
            threadReference = this.getEventThread(event);
        } else {
            threadReference = null;
        }
        return threadReference;
    }

    private ThreadReference getEventThread(Event event) {
        if (event instanceof ClassPrepareEvent) {
            return ((ClassPrepareEvent)event).thread();
        }
        if (event instanceof LocatableEvent) {
            return ((LocatableEvent)event).thread();
        }
        if (event instanceof ThreadStartEvent) {
            return ((ThreadStartEvent)event).thread();
        }
        if (event instanceof ThreadDeathEvent) {
            return ((ThreadDeathEvent)event).thread();
        }
        if (event instanceof VMStartEvent) {
            return ((VMStartEvent)event).thread();
        }
        return null;
    }

    private String threadMatch(Event event) {
        Object object = event.request().getProperty(EventRequestSpec.threadKey);
        if (object == null) {
            return "nil";
        }
        if (object instanceof Long) {
            ThreadReference threadReference = this.getEventThread(event);
            if (threadReference.uniqueID() == ((Long)object).longValue()) {
                return "(list \"on_thread_id\" " + threadReference.uniqueID() + ")";
            }
            return null;
        }
        if (object instanceof String) {
            ThreadReference threadReference = ThreadCommands.getThread(this.app.getVM(), object.toString());
            ThreadReference threadReference2 = this.getEventThread(event);
            if (threadReference2.equals(threadReference)) {
                return "(list \"on_thread_name\" \"" + object.toString() + "\")";
            }
            return null;
        }
        return "\"Error matching thread\"";
    }

    private String expressionSuccess(Event event) {
        Object object = event.request().getProperty(EventRequestSpec.expressionKey);
        if (object != null) {
            String string = object.toString();
            try {
                StackFrame stackFrame = this.getEventThread(event).frame(0);
                Value value = Etc.evaluate(string, stackFrame);
                if (!value.type().name().equals("boolean")) {
                    return "\"Expression evaluates to non-boolean\"";
                }
                BooleanValue booleanValue = (BooleanValue)value;
                if (booleanValue.value()) {
                    return "(list \"" + string + "\")";
                }
                return null;
            }
            catch (Exception exception) {
                Debug.printIf(exception);
                return "\"Expression didn't evaluate correctly\"";
            }
        }
        return "nil";
    }

    private String objectIDMatches(WatchpointEvent watchpointEvent) {
        Object object = watchpointEvent.request().getProperty(WatchpointSpec.objectIDKey);
        if (object == null) {
            return "nil";
        }
        if (object instanceof Long) {
            Long l = (Long)object;
            if (watchpointEvent.object() == null) {
                return "(list " + l + ")";
            }
            if (watchpointEvent.object().uniqueID() == l.longValue()) {
                return "(list " + l + ")";
            }
            return null;
        }
        return "\"Object ID was not a Long\"";
    }

    private LispForm breakpointEvent(BreakpointEvent breakpointEvent) {
        Long l = ((EventRequestSpec)breakpointEvent.request().getProperty(EventRequestSpec.specPropertyKey)).getID();
        String string = this.threadMatch(breakpointEvent);
        if (string == null) {
            this.resumeApp &= true;
            return null;
        }
        String string2 = this.expressionSuccess(breakpointEvent);
        if (string2 == null) {
            this.resumeApp &= true;
            return null;
        }
        this.resumeApp &= false;
        return new LispForm("(list 'jde-dbo-breakpoint-hit-event " + l + Protocol.BR + Rep.getLocationRep(breakpointEvent.location()) + " " + string + " " + string2 + ")");
    }

    private LispForm stepEvent(StepEvent stepEvent) {
        this.resumeApp &= false;
        return new LispForm("(list 'jde-dbo-step-event " + Rep.getLocationRep(stepEvent.location()) + ")");
    }

    private LispForm watchpointEvent(WatchpointEvent watchpointEvent) {
        Long l = ((EventRequestSpec)watchpointEvent.request().getProperty(EventRequestSpec.specPropertyKey)).getID();
        String string = this.threadMatch(watchpointEvent);
        if (string == null) {
            this.resumeApp &= true;
            return null;
        }
        String string2 = this.expressionSuccess(watchpointEvent);
        if (string2 == null) {
            this.resumeApp &= true;
            return null;
        }
        String string3 = this.objectIDMatches(watchpointEvent);
        if (string3 == null) {
            this.resumeApp &= true;
            return null;
        }
        String string4 = Rep.getFieldValueRep(watchpointEvent.field(), watchpointEvent.valueCurrent(), this.app.getStore()).toString();
        String string5 = Rep.getObjectRep(watchpointEvent.object(), this.app.getStore()).toString();
        this.resumeApp &= false;
        return new LispForm("(list 'jde-dbo-watchpoint-hit-event " + l + Protocol.BR + string5 + Protocol.BR + string4 + Protocol.BR + Rep.getLocationRep(watchpointEvent.location()) + Protocol.BR + string3 + " " + string + " " + string2 + ")");
    }

    private LispForm exceptionEvent(ExceptionEvent exceptionEvent) {
        if (exceptionEvent.request() == null) {
            this.resumeApp &= true;
            return null;
        }
        Long l = ((EventRequestSpec)exceptionEvent.request().getProperty(EventRequestSpec.specPropertyKey)).getID();
        ExceptionRequest exceptionRequest = (ExceptionRequest)exceptionEvent.request();
        String string = this.threadMatch(exceptionEvent);
        if (string == null) {
            this.resumeApp &= true;
            return null;
        }
        this.resumeApp &= false;
        return new LispForm("(list 'jde-dbo-exception-event " + l + Protocol.BR + Rep.getObjectRep(exceptionEvent.exception(), this.app.getStore()) + Protocol.BR + string + ")");
    }

    private LispForm methodEntryEvent(MethodEntryEvent methodEntryEvent) {
        this.resumeApp &= false;
        return new LispForm("(list 'jde-dbo-method-entry-event" + Protocol.BR + Rep.getMethodRep(methodEntryEvent.method()) + ")");
    }

    private LispForm methodExitEvent(MethodExitEvent methodExitEvent) {
        this.resumeApp &= false;
        return new LispForm("(list 'jde-dbo-method-exit-event" + Protocol.BR + Rep.getMethodRep(methodExitEvent.method()) + ")");
    }

    private LispForm threadStartEvent(ThreadStartEvent threadStartEvent) {
        this.resumeApp &= false;
        return new LispForm("(list 'jde-dbo-thread-start-event" + Protocol.BR + Rep.getThreadRep(threadStartEvent.thread(), this.app.getStore()) + ")");
    }

    private LispForm threadDeathEvent(ThreadDeathEvent threadDeathEvent) {
        this.resumeApp &= false;
        return new LispForm("(list 'jde-dbo-thread-death-event" + Protocol.BR + Rep.getThreadRep(threadDeathEvent.thread(), this.app.getStore()) + ")");
    }

    private LispForm classPrepareEvent(ClassPrepareEvent classPrepareEvent) {
        this.app.resolve(classPrepareEvent.referenceType());
        EventRequest eventRequest = classPrepareEvent.request();
        if (eventRequest.getProperty("default") == null) {
            this.resumeApp &= false;
            return new LispForm("(list 'jde-dbo-class-prepare-event \"" + classPrepareEvent.referenceType().name() + "\")");
        }
        this.resumeApp &= true;
        return null;
    }

    private LispForm classUnloadEvent(ClassUnloadEvent classUnloadEvent) {
        this.resumeApp &= false;
        return new LispForm("(list 'jde-dbo-class-unload-event \"" + classUnloadEvent.className() + "\")");
    }

    private LispForm vmStartEvent(Event event) {
        this.resumeApp &= false;
        return new LispForm("(list 'jde-dbo-vm-start-event)");
    }

    private LispForm vmDeathEvent(Event event) {
        this.resumeApp &= true;
        return new LispForm("(list 'jde-dbo-vm-death-event)");
    }

    private LispForm vmDisconnectEvent(Event event) {
        this.connected = false;
        this.resumeApp &= true;
        this.app.shutdown();
        return new LispForm("(list 'jde-dbo-vm-disconnected-event)");
    }
}

