/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger;

import com.sun.jdi.ReferenceType;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.request.ClassPrepareRequest;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import jde.debugger.Debug;
import jde.debugger.EventHandler;
import jde.debugger.GeneralCommands;
import jde.debugger.JDEException;
import jde.debugger.Jdebug;
import jde.debugger.LispForm;
import jde.debugger.ObjectStore;
import jde.debugger.Protocol;
import jde.debugger.SpecCommands;
import jde.debugger.ThreadCommands;
import jde.debugger.spec.BreakpointSpec;
import jde.debugger.spec.EventRequestSpec;
import jde.debugger.spec.EventRequestSpecList;
import jde.debugger.spec.ExceptionSpec;
import jde.debugger.spec.WatchpointSpec;

public class Application
implements Protocol {
    final Integer appID;
    final Jdebug jdebug;
    Socket sioSocket = null;
    EventHandler eventHandler;
    VirtualMachine vm;
    EventRequestSpecList eventRequestSpecs;
    Collection pendingCommands;
    ObjectStore store;
    private long objIdCounter = 0L;
    GeneralCommands generalCommands;
    SpecCommands specCommands;
    ThreadCommands threadCommands;
    private boolean shuttingDown = false;
    Thread standardIOConnectThread;
    StandardInputProcessor standardInputProcessor;
    StandardOutputProcessor standardOutputProcessor;
    StandardErrorProcessor standardErrorProcessor;
    StandardOutputWriter standardOutputWriter;

    public Application(Jdebug jdebug, Integer n, VirtualMachine virtualMachine) {
        this.jdebug = jdebug;
        this.appID = n;
        this.vm = virtualMachine;
        this.pendingCommands = Collections.synchronizedSet(new HashSet());
        this.store = new ObjectStore(this);
        this.eventHandler = new EventHandler(this);
        this.eventRequestSpecs = new EventRequestSpecList(this);
        ClassPrepareRequest classPrepareRequest = virtualMachine.eventRequestManager().createClassPrepareRequest();
        classPrepareRequest.putProperty("default", "default");
        classPrepareRequest.setSuspendPolicy(2);
        classPrepareRequest.enable();
        this.generalCommands = new GeneralCommands(this, this.store);
        this.specCommands = new SpecCommands(this, this.eventRequestSpecs, this.store);
        this.threadCommands = new ThreadCommands(this, this.store);
    }

    public final VirtualMachine getVM() {
        return this.vm;
    }

    public final Integer getId() {
        return this.appID;
    }

    public final Long generateObjectID() {
        Integer n = Jdebug.debuggerID;
        synchronized (n) {
            Long l = new Long(this.objIdCounter++);
            return l;
        }
    }

    public final ObjectStore getStore() {
        return this.store;
    }

    public final EventQueue getEventQueue() {
        return this.vm.eventQueue();
    }

    public final void shutdown() {
        this.shuttingDown = true;
        Process process = null;
        if (this.vm != null) {
            process = this.vm.process();
        }
        try {
            try {
                if (this.vm != null) {
                    this.vm.dispose();
                    this.vm = null;
                    this.eventHandler.shutdown();
                }
                this.sioSocket.close();
            }
            catch (Exception exception) {
                Object var4_3 = null;
                if (process != null) {
                    process.destroy();
                }
                this.jdebug.removeApplication(this.appID);
            }
            Object var4_2 = null;
            if (process != null) {
                process.destroy();
            }
            this.jdebug.removeApplication(this.appID);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (process != null) {
                process.destroy();
            }
            this.jdebug.removeApplication(this.appID);
            throw throwable;
        }
    }

    public int initSIOConnect() throws JDEException {
        this.signal("message", "initSIOConnect: starting standard I/O handshake.");
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(0);
        }
        catch (IOException iOException) {
            throw new JDEException("Unable to create a server socket");
        }
        final ServerSocket serverSocket2 = serverSocket;
        final int n = serverSocket.getLocalPort();
        this.standardIOConnectThread = new Thread("Standard I/O Thread for App #" + this.appID){

            public void run() {
                try {
                    Application.this.signal("message", "Debugger waiting for Emacs to connect to app SIO port " + n + ".");
                    Application.this.sioSocket = serverSocket2.accept();
                    serverSocket2.close();
                }
                catch (IOException iOException) {
                    Application.this.signal("error", "IOException occurred while connecting to app SIO port " + n + ". Shutting down...");
                    Application.this.shutdown();
                }
                catch (SecurityException securityException) {
                    Application.this.signal("error", "Security exception occurred while connecting to app SIO port " + n);
                }
            }
        };
        this.signal("message", "initSIOConnect: starting SIO connect thread.");
        this.standardIOConnectThread.start();
        return n;
    }

    public void initSIOTransport() {
        try {
            this.standardIOConnectThread.join();
            this.signal("message", "Debugger connected to standard I/O socket.");
            Process process = this.vm.process();
            this.standardInputProcessor = new StandardInputProcessor(process.getOutputStream());
            this.standardInputProcessor.start();
            this.standardOutputWriter = new StandardOutputWriter(this.sioSocket);
            this.standardOutputProcessor = new StandardOutputProcessor(process.getInputStream());
            this.standardOutputProcessor.start();
            this.standardErrorProcessor = new StandardErrorProcessor(process.getErrorStream());
            this.standardErrorProcessor.start();
        }
        catch (InterruptedException interruptedException) {
            this.signal("error", "Debugger interrupted while waiting for Emacs to connect to standard I/O socket.");
        }
    }

    public List findClassesMatchingPattern(String string) throws JDEException {
        if (this.vm == null) {
            return null;
        }
        ArrayList<ReferenceType> arrayList = new ArrayList<ReferenceType>();
        if (string.startsWith("*.")) {
            string = string.substring(1);
            List<ReferenceType> list = this.vm.allClasses();
            Iterator<ReferenceType> iterator = list.iterator();
            while (iterator.hasNext()) {
                ReferenceType referenceType = iterator.next();
                if (!referenceType.name().endsWith(string)) continue;
                arrayList.add(referenceType);
            }
            return arrayList;
        }
        return this.vm.classesByName(string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleCommand(Integer n, String string, List list) {
        Collection collection;
        Collection collection2 = this.pendingCommands;
        synchronized (collection2) {
            if (this.pendingCommands.contains(n)) {
                this.signalCommandError(new Integer(-1), "Duplicate command id '" + n + "'");
            }
        }
        try {
            try {
                string = string.toLowerCase();
                if (string.equals("finish")) {
                    this.generalCommands.doFinish(n, list);
                }
                if (string.equals("get_object")) {
                    this.generalCommands.doGetObject(n, list);
                }
                if (string.equals("get_loaded_classes")) {
                    this.generalCommands.doGetLoadedClasses(n, list);
                }
                if (string.equals("get_path_information")) {
                    this.generalCommands.doGetPathInformation(n, list);
                }
                if (string.equals("trace_classes")) {
                    this.generalCommands.doTraceClasses(n, list);
                }
                if (string.equals("cancel_trace_classes")) {
                    this.generalCommands.doCancelTraceClasses(n, list);
                }
                if (string.equals("trace_exceptions")) {
                    this.specCommands.doTraceExceptions(n, list);
                }
                if (string.equals("watch")) {
                    this.specCommands.doWatch(n, list);
                }
                if (string.equals("break")) {
                    this.specCommands.doBreak(n, list);
                }
                if (string.equals("clear")) {
                    this.specCommands.doClear(n, list);
                }
                if (string.equals("trace_methods")) {
                    this.generalCommands.doTraceMethods(n, list);
                }
                if (string.equals("cancel_trace_methods")) {
                    this.generalCommands.doCancelTraceMethods(n, list);
                }
                if (string.equals("suspend")) {
                    this.threadCommands.doSuspend(n, list);
                }
                if (string.equals("resume")) {
                    this.threadCommands.doResume(n, list);
                }
                if (string.equals("interrupt")) {
                    this.threadCommands.doInterrupt(n, list);
                }
                if (string.equals("kill_thread")) {
                    this.threadCommands.doKillThread(n, list);
                }
                if (string.equals("get_threads")) {
                    this.threadCommands.doGetThreads(n, list);
                }
                if (string.equals("get_thread")) {
                    this.threadCommands.doGetThread(n, list);
                }
                if (string.equals("get_object_monitors")) {
                    this.threadCommands.doGetObjectMonitors(n, list);
                }
                if (string.equals("trace_threads")) {
                    this.threadCommands.doTraceThreads(n, list);
                }
                if (string.equals("cancel_trace_threads")) {
                    this.threadCommands.doCancelTraceThreads(n, list);
                }
                this.signalCommandError(n, "'" + string + "' is not supported");
            }
            catch (JDEException jDEException) {
                Debug.printIf(jDEException);
                this.signalCommandError(n, jDEException);
                Object var8_6 = null;
                Collection collection3 = this.pendingCommands;
                synchronized (collection3) {
                    this.pendingCommands.remove(n);
                    return;
                }
            }
            catch (Exception exception) {
                Debug.printIf(exception);
                this.signalCommandError(n, "An unspecified error occured: '" + exception.toString() + "'");
                Object var8_7 = null;
                Collection collection4 = this.pendingCommands;
                synchronized (collection4) {
                    this.pendingCommands.remove(n);
                    return;
                }
            }
            Object var8_5 = null;
            collection = this.pendingCommands;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            Collection collection4 = this.pendingCommands;
            synchronized (collection4) {
                this.pendingCommands.remove(n);
                throw throwable;
            }
        }
        synchronized (collection) {
            this.pendingCommands.remove(n);
            return;
        }
    }

    public void resolve(ReferenceType referenceType) {
        this.eventRequestSpecs.resolve(referenceType);
    }

    public void informJDEInstallSuccessful(EventRequestSpec eventRequestSpec) {
        this.signal("spec-resolved", eventRequestSpec.getID());
    }

    public void removeSpecAndInformJDE(EventRequestSpec eventRequestSpec, String string) {
        if (eventRequestSpec instanceof BreakpointSpec) {
            this.signal("invalid-break", new LispForm(eventRequestSpec.getID() + " \"" + string + "\""));
        } else if (eventRequestSpec instanceof WatchpointSpec) {
            this.signal("invalid-watch", new LispForm(eventRequestSpec.getID() + " \"" + string + "\""));
        } else if (eventRequestSpec instanceof ExceptionSpec) {
            this.signal("invalid-trace_exceptions", new LispForm(eventRequestSpec.getID() + " \"" + string + "\""));
        }
        this.eventRequestSpecs.delete(eventRequestSpec);
    }

    public void signal(String string, Object object) {
        this.jdebug.signal(this.appID, string, object);
    }

    public void signalCommandResult(Integer n) {
        this.jdebug.signalCommandResult(this.appID, n);
    }

    public void signalCommandResult(Integer n, Object object) {
        this.jdebug.signalCommandResult(this.appID, n, object);
    }

    public void signalCommandError(Integer n, String string) {
        this.jdebug.signalCommandError(this.appID, n, string);
    }

    public void signalCommandError(Integer n, JDEException jDEException) {
        this.jdebug.signalCommandError(this.appID, n, jDEException.getMessage());
    }

    private boolean isShuttingDown() {
        return this.shuttingDown;
    }

    private class StandardErrorProcessor
    extends Thread {
        BufferedReader fromVM;

        public StandardErrorProcessor(InputStream inputStream) {
            super("Standard Error Processor for App #" + Application.this.appID);
            this.fromVM = new BufferedReader(new InputStreamReader(inputStream));
            this.setPriority(9);
        }

        public void run() {
            try {
                int n;
                char[] cArray = new char[256];
                while ((n = this.fromVM.read(cArray, 0, 256)) != -1) {
                    StandardOutputWriter standardOutputWriter = Application.this.standardOutputWriter;
                    synchronized (standardOutputWriter) {
                        if (Application.this.standardOutputWriter != null) {
                            Application.this.standardOutputWriter.write(cArray, n);
                        }
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!Application.this.isShuttingDown()) {
                try {
                    Application.this.signal("message", "Closed transport for application's standard error output.");
                }
                catch (Exception exception) {
                    Application.this.signal("error", "Could not close application standard error output transport.");
                }
            }
        }
    }

    private class StandardOutputProcessor
    extends Thread {
        BufferedReader fromVM;

        public StandardOutputProcessor(InputStream inputStream) {
            this.fromVM = new BufferedReader(new InputStreamReader(inputStream));
            this.setPriority(9);
        }

        public void run() {
            try {
                int n;
                char[] cArray = new char[256];
                while ((n = this.fromVM.read(cArray, 0, 256)) != -1) {
                    StandardOutputWriter standardOutputWriter = Application.this.standardOutputWriter;
                    synchronized (standardOutputWriter) {
                        if (Application.this.standardOutputWriter != null) {
                            Application.this.standardOutputWriter.write(cArray, n);
                        }
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!Application.this.isShuttingDown()) {
                try {
                    Application.this.signal("message", "Closed transport for application's standard output.");
                }
                catch (Exception exception) {
                    Application.this.signal("error", "Could not close application standard output transport.");
                }
            }
        }
    }

    private class StandardOutputWriter {
        BufferedWriter toEmacs;

        public StandardOutputWriter(Socket socket) {
            OutputStream outputStream;
            if (socket == null) {
                Application.this.signal("error", "Could not transport app output. Transport socket does not exist.");
                return;
            }
            try {
                outputStream = socket.getOutputStream();
                if (outputStream == null) {
                    Application.this.signal("error", "Could not transport app output. Transport socket closed.");
                    return;
                }
            }
            catch (IOException iOException) {
                Application.this.signal("error", "Could not transport app output. Transport socket closed.");
                return;
            }
            this.toEmacs = new BufferedWriter(new OutputStreamWriter(outputStream));
        }

        public void write(char[] cArray, int n) {
            if (this.toEmacs != null) {
                try {
                    this.toEmacs.write(cArray, 0, n);
                    this.toEmacs.flush();
                }
                catch (IOException iOException) {
                    Application.this.signal("error", "I/O error: could not pipe application output to Emacs.");
                }
            }
        }
    }

    private class StandardInputProcessor
    extends Thread {
        PrintStream toVM;
        BufferedReader fromEmacs;

        public StandardInputProcessor(OutputStream outputStream) {
            super("Input Processor for App #" + Application.this.appID);
            this.toVM = new PrintStream(outputStream, true);
            try {
                this.fromEmacs = new BufferedReader(new InputStreamReader(Application.this.sioSocket.getInputStream()));
            }
            catch (IOException iOException) {
                Application.this.signal("error", "Could not get standard input stream from Emacs.");
            }
            this.setPriority(9);
        }

        public void run() {
            block9: {
                if (this.fromEmacs == null) {
                    return;
                }
                try {
                    String string;
                    while ((string = this.fromEmacs.readLine()) != null) {
                        this.toVM.println(string);
                        this.toVM.flush();
                    }
                    if (!Application.this.isShuttingDown()) {
                        try {
                            Application.this.signal("message", "Application closed its standard input.");
                        }
                        catch (Exception exception) {
                            Application.this.signal("message", "Couldn't close socket to standard input.");
                        }
                    }
                }
                catch (IOException iOException) {
                    if (Application.this.isShuttingDown()) break block9;
                    try {
                        Application.this.signal("error", "Input error; application I/O closed");
                    }
                    catch (Exception exception) {
                        Application.this.signal("error", "Input error; couldn't close application I/O");
                    }
                }
            }
        }
    }
}

