/*
  File autogenerated by gengetopt version 2.14
  generated with the following command:
  gengetopt --conf-parser -i ivtv-tune.ggo 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "getopt.h"

#include "cmdline.h"

static
void clear_given (struct gengetopt_args_info *args_info);
static
void clear_args (struct gengetopt_args_info *args_info);

static int
cmdline_parser_internal (int argc, char * const *argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required, const char *additional_error);

struct line_list
{
  char * string_arg;
  struct line_list * next;
};

struct line_list *cmd_line_list = 0;
struct line_list *cmd_line_list_tmp = 0;


static char *
gengetopt_strdup (const char *s);

static
void clear_given (struct gengetopt_args_info *args_info)
{
  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->channel_given = 0 ;
  args_info->device_given = 0 ;
  args_info->frequency_given = 0 ;
  args_info->list_channels_given = 0 ;
  args_info->list_freqtable_given = 0 ;
  args_info->freqtable_given = 0 ;
  args_info->xawtv_given = 0 ;
}

static
void clear_args (struct gengetopt_args_info *args_info)
{
  args_info->channel_arg = NULL;
  args_info->channel_orig = NULL;
  args_info->device_arg = NULL;
  args_info->device_orig = NULL;
  args_info->frequency_orig = NULL;
  args_info->list_channels_flag = 0;
  args_info->list_freqtable_flag = 0;
  args_info->freqtable_arg = NULL;
  args_info->freqtable_orig = NULL;
  args_info->xawtv_arg = NULL;
  args_info->xawtv_orig = NULL;
  
}

void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n", CMDLINE_PARSER_PACKAGE, CMDLINE_PARSER_VERSION);
}

void
cmdline_parser_print_help (void)
{
  cmdline_parser_print_version ();
  printf("\n%s\n", "Channel/Frequency changer for V4L2 compatible video encoders");
  printf("\nUsage: ivtv-tune [OPTIONS]...\n\n");
  printf("%s\n","  -h, --help              Print help and exit");
  printf("%s\n","  -V, --version           Print version and exit");
  printf("%s\n","  -c, --channel=CHANNEL   set new channel");
  printf("%s\n","  -d, --device=DEVICE     set video device node");
  printf("%s\n","  -f, --frequency=FREQ    set new frequency (MHz)");
  printf("%s\n","  -l, --list-channels     list all channels and their frequencies  \n                            (default=off)");
  printf("%s\n","  -L, --list-freqtable    list all available frequency mappings  (default=off)");
  printf("%s\n","  -t, --freqtable=STRING  set frequency map to use");
  printf("%s\n","  -x, --xawtv=CHANNEL     set new channel using custom map from ~/.xawtv");
  
}

void
cmdline_parser_init (struct gengetopt_args_info *args_info)
{
  clear_given (args_info);
  clear_args (args_info);
}

static void
cmdline_parser_release (struct gengetopt_args_info *args_info)
{
  
  if (args_info->channel_arg)
    {
      free (args_info->channel_arg); /* free previous argument */
      args_info->channel_arg = 0;
    }
  if (args_info->channel_orig)
    {
      free (args_info->channel_orig); /* free previous argument */
      args_info->channel_orig = 0;
    }
  if (args_info->device_arg)
    {
      free (args_info->device_arg); /* free previous argument */
      args_info->device_arg = 0;
    }
  if (args_info->device_orig)
    {
      free (args_info->device_orig); /* free previous argument */
      args_info->device_orig = 0;
    }
  if (args_info->frequency_orig)
    {
      free (args_info->frequency_orig); /* free previous argument */
      args_info->frequency_orig = 0;
    }
  if (args_info->freqtable_arg)
    {
      free (args_info->freqtable_arg); /* free previous argument */
      args_info->freqtable_arg = 0;
    }
  if (args_info->freqtable_orig)
    {
      free (args_info->freqtable_orig); /* free previous argument */
      args_info->freqtable_orig = 0;
    }
  if (args_info->xawtv_arg)
    {
      free (args_info->xawtv_arg); /* free previous argument */
      args_info->xawtv_arg = 0;
    }
  if (args_info->xawtv_orig)
    {
      free (args_info->xawtv_orig); /* free previous argument */
      args_info->xawtv_orig = 0;
    }
  
  clear_given (args_info);
}

int
cmdline_parser_file_save(const char *filename, struct gengetopt_args_info *args_info)
{
  FILE *outfile;
  int i = 0;

  outfile = fopen(filename, "w");

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot open file for writing: %s\n", CMDLINE_PARSER_PACKAGE, filename);
      return EXIT_FAILURE;
    }

  if (args_info->help_given) {
    fprintf(outfile, "%s\n", "help");
  }
  if (args_info->version_given) {
    fprintf(outfile, "%s\n", "version");
  }
  if (args_info->channel_given) {
    if (args_info->channel_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "channel", args_info->channel_orig);
    } else {
      fprintf(outfile, "%s\n", "channel");
    }
  }
  if (args_info->device_given) {
    if (args_info->device_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "device", args_info->device_orig);
    } else {
      fprintf(outfile, "%s\n", "device");
    }
  }
  if (args_info->frequency_given) {
    if (args_info->frequency_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "frequency", args_info->frequency_orig);
    } else {
      fprintf(outfile, "%s\n", "frequency");
    }
  }
  if (args_info->list_channels_given) {
    fprintf(outfile, "%s\n", "list-channels");
  }
  if (args_info->list_freqtable_given) {
    fprintf(outfile, "%s\n", "list-freqtable");
  }
  if (args_info->freqtable_given) {
    if (args_info->freqtable_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "freqtable", args_info->freqtable_orig);
    } else {
      fprintf(outfile, "%s\n", "freqtable");
    }
  }
  if (args_info->xawtv_given) {
    if (args_info->xawtv_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "xawtv", args_info->xawtv_orig);
    } else {
      fprintf(outfile, "%s\n", "xawtv");
    }
  }
  
  fclose (outfile);

  i = EXIT_SUCCESS;
  return i;
}

void
cmdline_parser_free (struct gengetopt_args_info *args_info)
{
  cmdline_parser_release (args_info);
  if (cmd_line_list)
    {
      /* free the list of a previous call */
      while (cmd_line_list) {
        cmd_line_list_tmp = cmd_line_list;
        cmd_line_list = cmd_line_list->next;
        free (cmd_line_list_tmp->string_arg);
        free (cmd_line_list_tmp);
      }
    }
}


/* gengetopt_strdup() */
/* strdup.c replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = NULL;
  if (!s)
    return result;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

int
cmdline_parser (int argc, char * const *argv, struct gengetopt_args_info *args_info)
{
  return cmdline_parser2 (argc, argv, args_info, 0, 1, 1);
}

int
cmdline_parser2 (int argc, char * const *argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required)
{
  int result;

  result = cmdline_parser_internal (argc, argv, args_info, override, initialize, check_required, NULL);

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser_required (struct gengetopt_args_info *args_info, const char *prog_name)
{
  return EXIT_SUCCESS;
}

int
cmdline_parser_internal (int argc, char * const *argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required, const char *additional_error)
{
  int c;	/* Character of the parsed option.  */

  int error = 0;
  struct gengetopt_args_info local_args_info;

  if (initialize)
    cmdline_parser_init (args_info);

  cmdline_parser_init (&local_args_info);

  optarg = 0;
  optind = 1;
  opterr = 1;
  optopt = '?';

  while (1)
    {
      int option_index = 0;
      char *stop_char;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { "channel",	1, NULL, 'c' },
        { "device",	1, NULL, 'd' },
        { "frequency",	1, NULL, 'f' },
        { "list-channels",	0, NULL, 'l' },
        { "list-freqtable",	0, NULL, 'L' },
        { "freqtable",	1, NULL, 't' },
        { "xawtv",	1, NULL, 'x' },
        { NULL,	0, NULL, 0 }
      };

      stop_char = 0;
      c = getopt_long (argc, argv, "hVc:d:f:lLt:x:", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          cmdline_parser_print_help ();
          cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'V':	/* Print version and exit.  */
          cmdline_parser_print_version ();
          cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'c':	/* set new channel.  */
          if (local_args_info.channel_given)
            {
              fprintf (stderr, "%s: `--channel' (`-c') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->channel_given && ! override)
            continue;
          local_args_info.channel_given = 1;
          args_info->channel_given = 1;
          if (args_info->channel_arg)
            free (args_info->channel_arg); /* free previous string */
          args_info->channel_arg = gengetopt_strdup (optarg);
          if (args_info->channel_orig)
            free (args_info->channel_orig); /* free previous string */
          args_info->channel_orig = gengetopt_strdup (optarg);
          break;

        case 'd':	/* set video device node.  */
          if (local_args_info.device_given)
            {
              fprintf (stderr, "%s: `--device' (`-d') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->device_given && ! override)
            continue;
          local_args_info.device_given = 1;
          args_info->device_given = 1;
          if (args_info->device_arg)
            free (args_info->device_arg); /* free previous string */
          args_info->device_arg = gengetopt_strdup (optarg);
          if (args_info->device_orig)
            free (args_info->device_orig); /* free previous string */
          args_info->device_orig = gengetopt_strdup (optarg);
          break;

        case 'f':	/* set new frequency (MHz).  */
          if (local_args_info.frequency_given)
            {
              fprintf (stderr, "%s: `--frequency' (`-f') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->frequency_given && ! override)
            continue;
          local_args_info.frequency_given = 1;
          args_info->frequency_given = 1;
          args_info->frequency_arg = (float)strtod (optarg, NULL);
          if (args_info->frequency_orig)
            free (args_info->frequency_orig); /* free previous string */
          args_info->frequency_orig = gengetopt_strdup (optarg);
          break;

        case 'l':	/* list all channels and their frequencies.  */
          if (local_args_info.list_channels_given)
            {
              fprintf (stderr, "%s: `--list-channels' (`-l') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->list_channels_given && ! override)
            continue;
          local_args_info.list_channels_given = 1;
          args_info->list_channels_given = 1;
          args_info->list_channels_flag = !(args_info->list_channels_flag);
          break;

        case 'L':	/* list all available frequency mappings.  */
          if (local_args_info.list_freqtable_given)
            {
              fprintf (stderr, "%s: `--list-freqtable' (`-L') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->list_freqtable_given && ! override)
            continue;
          local_args_info.list_freqtable_given = 1;
          args_info->list_freqtable_given = 1;
          args_info->list_freqtable_flag = !(args_info->list_freqtable_flag);
          break;

        case 't':	/* set frequency map to use.  */
          if (local_args_info.freqtable_given)
            {
              fprintf (stderr, "%s: `--freqtable' (`-t') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->freqtable_given && ! override)
            continue;
          local_args_info.freqtable_given = 1;
          args_info->freqtable_given = 1;
          if (args_info->freqtable_arg)
            free (args_info->freqtable_arg); /* free previous string */
          args_info->freqtable_arg = gengetopt_strdup (optarg);
          if (args_info->freqtable_orig)
            free (args_info->freqtable_orig); /* free previous string */
          args_info->freqtable_orig = gengetopt_strdup (optarg);
          break;

        case 'x':	/* set new channel using custom map from ~/.xawtv.  */
          if (local_args_info.xawtv_given)
            {
              fprintf (stderr, "%s: `--xawtv' (`-x') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->xawtv_given && ! override)
            continue;
          local_args_info.xawtv_given = 1;
          args_info->xawtv_given = 1;
          if (args_info->xawtv_arg)
            free (args_info->xawtv_arg); /* free previous string */
          args_info->xawtv_arg = gengetopt_strdup (optarg);
          if (args_info->xawtv_orig)
            free (args_info->xawtv_orig); /* free previous string */
          args_info->xawtv_orig = gengetopt_strdup (optarg);
          break;


        case 0:	/* Long option with no short option */
        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          goto failure;

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c%s\n", CMDLINE_PARSER_PACKAGE, c, (additional_error ? additional_error : ""));
          exit (1);
        } /* switch */
    } /* while */




  cmdline_parser_release (&local_args_info);

  if ( error )
    return (EXIT_FAILURE);

  return 0;

failure:
  
  cmdline_parser_release (&local_args_info);
  return (EXIT_FAILURE);
}

#ifndef CONFIG_FILE_LINE_SIZE
#define CONFIG_FILE_LINE_SIZE 2048
#endif
#define ADDITIONAL_ERROR " in configuration file "

#define CONFIG_FILE_LINE_BUFFER_SIZE (CONFIG_FILE_LINE_SIZE+3)
/* 3 is for "--" and "=" */

char my_argv[CONFIG_FILE_LINE_BUFFER_SIZE+1];

int
cmdline_parser_configfile (char * const filename, struct gengetopt_args_info *args_info, int override, int initialize, int check_required)
{
  FILE* file;
  char linebuf[CONFIG_FILE_LINE_SIZE];
  int line_num = 0;
  int i, result, equal;
  char *fopt, *farg;
  char *str_index;
  size_t len, next_token;
  char delimiter;
  int my_argc = 0;
  char **my_argv_arg;
  char *additional_error;

  /* store the program name */
  cmd_line_list_tmp = (struct line_list *) malloc (sizeof (struct line_list));
  cmd_line_list_tmp->next = cmd_line_list;
  cmd_line_list = cmd_line_list_tmp;
  cmd_line_list->string_arg = gengetopt_strdup (CMDLINE_PARSER_PACKAGE);

  if ((file = fopen(filename, "r")) == NULL)
    {
      fprintf (stderr, "%s: Error opening configuration file '%s'\n",
               CMDLINE_PARSER_PACKAGE, filename);
      result = EXIT_FAILURE;
      goto conf_failure;
    }

  while ((fgets(linebuf, CONFIG_FILE_LINE_SIZE, file)) != NULL)
    {
      ++line_num;
      my_argv[0] = '\0';
      len = strlen(linebuf);
      if (len > (CONFIG_FILE_LINE_BUFFER_SIZE-1))
        {
          fprintf (stderr, "%s:%s:%d: Line too long in configuration file\n",
                   CMDLINE_PARSER_PACKAGE, filename, line_num);
          result = EXIT_FAILURE;
          goto conf_failure;
        }

      /* find first non-whitespace character in the line */
      next_token = strspn ( linebuf, " \t\r\n");
      str_index  = linebuf + next_token;

      if ( str_index[0] == '\0' || str_index[0] == '#')
        continue; /* empty line or comment line is skipped */

      fopt = str_index;

      /* truncate fopt at the end of the first non-valid character */
      next_token = strcspn (fopt, " \t\r\n=");

      if (fopt[next_token] == '\0') /* the line is over */
        {
          farg  = NULL;
          equal = 0;
          goto noarg;
        }

      /* remember if equal sign is present */
      equal = (fopt[next_token] == '=');
      fopt[next_token++] = '\0';

      /* advance pointers to the next token after the end of fopt */
      next_token += strspn (fopt + next_token, " \t\r\n");
      /* check for the presence of equal sign, and if so, skip it */
      if ( !equal )
        if ((equal = (fopt[next_token] == '=')))
          {
            next_token++;
            next_token += strspn (fopt + next_token, " \t\r\n");
          }
      str_index  += next_token;

      /* find argument */
      farg = str_index;
      if ( farg[0] == '\"' || farg[0] == '\'' )
        { /* quoted argument */
          str_index = strchr (++farg, str_index[0] ); /* skip opening quote */
          if (! str_index)
            {
              fprintf
                (stderr,
                 "%s:%s:%d: unterminated string in configuration file\n",
                 CMDLINE_PARSER_PACKAGE, filename, line_num);
              result = EXIT_FAILURE;
              goto conf_failure;
            }
        }
      else
        { /* read up the remaining part up to a delimiter */
          next_token = strcspn (farg, " \t\r\n#\'\"");
          str_index += next_token;
        }

      /* truncate farg at the delimiter and store it for further check */
      delimiter = *str_index, *str_index++ = '\0';

      /* everything but comment is illegal at the end of line */
      if (delimiter != '\0' && delimiter != '#')
        {
          str_index += strspn(str_index, " \t\r\n");
          if (*str_index != '\0' && *str_index != '#')
            {
              fprintf
                (stderr,
                 "%s:%s:%d: malformed string in configuration file\n",
                 CMDLINE_PARSER_PACKAGE, filename, line_num);
              result = EXIT_FAILURE;
              goto conf_failure;
            }
        }

    noarg:
      ++my_argc;
      len = strlen(fopt);

      strcat (my_argv, len > 1 ? "--" : "-");
      strcat (my_argv, fopt);
      if (len > 1 && ((farg &&*farg) || equal))
          strcat (my_argv, "=");
      if (farg && *farg)
          strcat (my_argv, farg);

      cmd_line_list_tmp = (struct line_list *) malloc (sizeof (struct line_list));
      cmd_line_list_tmp->next = cmd_line_list;
      cmd_line_list = cmd_line_list_tmp;
      cmd_line_list->string_arg = gengetopt_strdup(my_argv);
    } /* while */

  ++my_argc; /* for program name */
  my_argv_arg = (char **) malloc((my_argc+1) * sizeof(char *));
  cmd_line_list_tmp = cmd_line_list;
  for (i = my_argc - 1; i >= 0; --i) {
    my_argv_arg[i] = cmd_line_list_tmp->string_arg;
    cmd_line_list_tmp = cmd_line_list_tmp->next;
  }
  my_argv_arg[my_argc] = 0;

  additional_error = (char *)malloc(strlen(filename) + strlen(ADDITIONAL_ERROR) + 1);
  strcpy (additional_error, ADDITIONAL_ERROR);
  strcat (additional_error, filename);
  result =
    cmdline_parser_internal (my_argc, my_argv_arg, args_info, override, initialize, check_required, additional_error);

  free (additional_error);
  free (my_argv_arg);

conf_failure:
  if (file)
    fclose(file);
  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}
