/*
 * HPTalx
 * A PC<->HP48/49 communication program for Linux
 *
 * (C) 1999 by Bruno Barberi Gnecco
 *
 * rev 0.2:	Splitted icon functions to this file
 *		
 */

/*
    Copyright note:

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "icons.h"

GdkPixmap *dir_icon;
GdkBitmap *dir_mask;
GdkPixmap *file_icon;
GdkBitmap *file_mask;
GdkPixmap *list_icon;
GdkBitmap *list_mask;
GdkPixmap *library_icon;
GdkBitmap *library_mask;
GdkPixmap *program_icon;
GdkBitmap *program_mask;
GdkPixmap *string_icon;
GdkBitmap *string_mask;
GdkPixmap *algebraic_icon;
GdkBitmap *algebraic_mask;
GdkPixmap *array_icon;
GdkBitmap *array_mask;
GdkPixmap *real_icon;
GdkBitmap *real_mask;
GdkPixmap *complex_icon;
GdkBitmap *complex_mask;

static const char *dir_icon_xpm[] = {
	"16 16 3 1",
	" 	c None",
	"x	c #000000000000",
	".	c #FFFFFFFFFFFF",
	"                ",
	" ......         ",
	" .xxxx..        ",
	" .x...x........ ",
	" .x....xxxxxxx. ",
	" .x..........x. ",
	" .x..........x. ",
	" .x..........x. ",
	" .x..........x. ",
	" .x..........x. ",
	" .x..........x. ",
	" .x..........x. ",
	" .x..........x. ",
	" .xxxxxxxxxxxx. ",
	" .............. ",
	"                "
};

static const char *file_icon_xpm[] = {
	"16 16 3 1",
	" 	c None",
	"x	c #000000000000",
	".	c #FFFFFFFFFFFF",
	"                ",
	" .............. ",
	" .xxxxxxxxxxxx. ",
	" .x..........x. ",
	" .x..........x. ",
	" .x.xxxxxxxx.x. ",
	" .x..........x. ",
	" .x.xxxxxxxx.x. ",
	" .x..........x. ",
	" .x.xxxxxxxx.x. ",
	" .x..........x. ",
	" .x.xxxxxxxx.x. ",
	" .x..........x. ",
	" .xxxxxxxxxxxx. ",
	" .............. ",
	"                "
};

static const char *list_icon_xpm[] = {
	"16 16 3 1",
	" 	c None",
	"x	c #000000000000",
	".	c #FFFFFFFFFFFF",
	"                ",
	"                ",
	"   x.      .x   ",
	"  x.        .x  ",
	"  x.        .x  ",
	"  x.        .x  ",
	"  x.        .x  ",
	" x.          .x ",
	"  x.        .x  ",
	"  x.        .x  ",
	"  x.        .x  ",
	"  x.        .x  ",
	"  x.        .x  ",
	"   x.      .x   ",
	"                ",
	"                "
};

static const char *library_icon_xpm[] = {
	"16 16 3 1",
	" 	c None",
	"x	c #000000000000",
	".	c #FFFFFFFFFFFF",
	"                ",
	"                ",
	" x.    x. xxx.  ",
	" x.    x. x. x. ",
	" x.    x. x.  x.",
	" x.    x. x.  x.",
	" x.    x. x. x. ",
	" x.    x. xxxx. ",
	" x.    x. x.  x.",
	" x.    x. x.  x.",
	" x.    x. x.  x.",
	" x.    x. x.  x.",
	" x.    x. x.  x.",
	" xxxx. x. xxxx. ",
	"                ",
	"                "
};


static const char *program_icon_xpm[] = {
	"16 16 3 1",
	" 	c None",
	"x	c #000000000000",
	".	c #FFFFFFFFFFFF",
	"                " 
	" xxxxxxxx       ",
	" x.......       ",
	" x.  x.    x.   ",
	" xxxxxx.  x.    ",
	" x.....x.x.     ",
	" x.     x.      ",
	" x.    xxxxxxxx ",
	" xxxxxxx..x.... ",
	"  ...x.x.  x.   ",
	"    x. xxxxxx.  ",
	"       x.....   ",
	"       x.       ",
	"       x.       ",
	"       xxxxxxxx ",
	"       ........ "
};

static const char *string_icon_xpm[] = {
	"16 16 3 1",
	" 	c None",
	"x	c #000000000000",
	".	c #FFFFFFFFFFFF",
	"                ",
	" x. x.    x. x. ",
	" x. x.    x. x. ",
	" x. x.    x. x. ",
	" x. x.    x. x. ",
	" x. x.    x. x. ",
	"                ",
	"                ",
	"                ",
	"                ",
	"                ",
	"                ",
	"                ",
	"                ",
	"                ",
	"                "
};

static const char *algebraic_icon_xpm[] = {
	"16 16 3 1",
	" 	c None",
	"x	c #000000000000",
	".	c #FFFFFFFFFFFF",
	"      x.x.      ",
	"     x.x.x.     ",
	"      x.x.      ",
	"   x.           ",
	"  x.            ",
	"  x.      x.    ",
	"  x.x.x. xx.x.x.",
	"  x. x. x.x. x. ",
	"  x.x.x. xx.x.x.",
	"  x.            ",
	"  x.            ",
	" x.             ",
	"    x.          ",
	"   x.x.         ",
	"    x.          ",
	"                "
};

static const char *array_icon_xpm[] = {
	"16 16 3 1",
	" 	c None",
	"x	c #000000000000",
	".	c #FFFFFFFFFFFF",
	"                ",
	"                ",
	" xx.        xx. ",
	" x.  x.   x. x. ",
	" x. xx.  x.x.x. ",
	" x.  x.  x.x.x. ",
	" x.  x.   x. x. ",
	" x.          x. ",
	" x.          x. ",
	" x.  x.   x. x. ",
	" x. x.x. xx. x. ",
	" x. x.x.  x. x. ",
	" x.  x.   x. x. ",
	" xx.        xx. ",
	"                ",
	"                "
};

static const char *real_icon_xpm[] = {
	"16 16 3 1",
	" 	c None",
	"x	c #000000000000",
	".	c #FFFFFFFFFFFF",
	"                ",
	" xxxxxxxxx.     ",
	"  x.x.   xxx.   ",
	"  x.x.     xx.  ",
	"  x.x.     xx.  ",
	"  x.x.     xx.  ",
	"  x.x.   xx.    ",
	"  xxxxxxx.      ",
	"  x.x.  xxx.    ",
	"  x.x.    xx.   ",
	"  x.x.    xx.   ",
	"  x.x.    xx.   ",
	"  x.x.     xxx. ",
	" xxxxx      xxx.",
	"                ",
	"                "
};

static const char *complex_icon_xpm[] = {
	"16 16 3 1",
	" 	c None",
	"x	c #000000000000",
	".	c #FFFFFFFFFFFF",
	"                ",
	"                ",
	"      xxxxx. x. ",
	"    xx     xxx. ",
	"   xx.       x. ",
	"  x.x.       x. ",
	"  x.x.          ",
	"  x.x.          ",
	"  x.x.          ",
	"  x.x.          ",
	"  x.x.          ",
	"   xx.       x. ",
	"    xx.....xx.  ",
	"      xxxxx.    ",
	"                ",
	"                "
};

void init_pixmaps ( GtkWidget *w ) {
	GtkStyle *style;
	static int inited = 0;
	
	if ( inited != 0 )
		return;
	inited++;

	style = gtk_widget_get_style( w );
	file_icon = gdk_pixmap_create_from_xpm_d( w->window, &file_mask, 
			&style->bg[GTK_STATE_NORMAL], (gchar **)file_icon_xpm );
	dir_icon = gdk_pixmap_create_from_xpm_d( w->window, &dir_mask, 
			&style->bg[GTK_STATE_NORMAL], (gchar **)dir_icon_xpm );
	list_icon = gdk_pixmap_create_from_xpm_d( w->window, &list_mask, 
			&style->bg[GTK_STATE_NORMAL], (gchar **)list_icon_xpm );
	library_icon = gdk_pixmap_create_from_xpm_d( w->window, &library_mask, 
			&style->bg[GTK_STATE_NORMAL], (gchar **)library_icon_xpm );
	program_icon = gdk_pixmap_create_from_xpm_d( w->window, &program_mask, 
			&style->bg[GTK_STATE_NORMAL], (gchar **)program_icon_xpm );
	string_icon = gdk_pixmap_create_from_xpm_d( w->window, &string_mask, 
			&style->bg[GTK_STATE_NORMAL], (gchar **)string_icon_xpm );
	algebraic_icon = gdk_pixmap_create_from_xpm_d( w->window, &algebraic_mask, 
			&style->bg[GTK_STATE_NORMAL], (gchar **)algebraic_icon_xpm );
	array_icon = gdk_pixmap_create_from_xpm_d( w->window, &array_mask, 
			&style->bg[GTK_STATE_NORMAL], (gchar **)array_icon_xpm );
	real_icon = gdk_pixmap_create_from_xpm_d( w->window, &real_mask, 
			&style->bg[GTK_STATE_NORMAL], (gchar **)real_icon_xpm );
	complex_icon = gdk_pixmap_create_from_xpm_d( w->window, &complex_mask, 
			&style->bg[GTK_STATE_NORMAL], (gchar **)complex_icon_xpm );
}

void close_pixmaps ( GtkWidget *w ) {
	gdk_pixmap_unref( dir_icon );
	gdk_pixmap_unref( file_icon );
	gdk_pixmap_unref( list_icon );
	gdk_pixmap_unref( library_icon );
	gdk_pixmap_unref( program_icon );
	gdk_pixmap_unref( string_icon );
	gdk_pixmap_unref( algebraic_icon );
	gdk_pixmap_unref( array_icon );
	gdk_pixmap_unref( real_icon );
	gdk_pixmap_unref( complex_icon );
}
