use ExtUtils::MakeMaker;

## If this is being installed with Atoms of with Ifeffit, then
## $ENV{INSTALLING_WITH} will be set by Atoms' topmost Makefile.PL.
my $blib;
SWITCH : {
  $blib = "blib",       last SWITCH if (not $ENV{INSTALLING_WITH});
  $blib = "../blib",    last SWITCH if ($ENV{INSTALLING_WITH} eq 'atoms');
  $blib = "../blib",    last SWITCH if ($ENV{INSTALLING_WITH} eq 'horae');
  $blib = "../../blib", last SWITCH if ($ENV{INSTALLING_WITH} eq 'ifeffit');
};

WriteMakefile(
	      'NAME'    => 'HoraeAtp',
	      'VERSION' => '2004.01.14',
	      'PM' =>
	      {
	       'absorption.atp' => "$blib/lib/Xray/atp/absorption.atp",
	       'alchemy.atp'    => "$blib/lib/Xray/atp/alchemy.atp",
	       'atoms.atp'      => "$blib/lib/Xray/atp/atoms.atp",
	       'dafs.atp'       => "$blib/lib/Xray/atp/dafs.atp",
	       'dafs_ri.atp'    => "$blib/lib/Xray/atp/dafs_ri.atp",
	       'feff.atp'       => "$blib/lib/Xray/atp/feff.atp",
	       'feff6.atp'      => "$blib/lib/Xray/atp/feff6.atp",
	       'feff7.atp'      => "$blib/lib/Xray/atp/feff7.atp",
	       'feff8_exafs.atp'=> "$blib/lib/Xray/atp/feff8_exafs.atp",
	       'feff8.atp'      => "$blib/lib/Xray/atp/feff8.atp",
	       'formulas.atp'   => "$blib/lib/Xray/atp/formulas.atp",
	       'geom.atp'       => "$blib/lib/Xray/atp/geom.atp",
	       'gnxas_cry.atp'  => "$blib/lib/Xray/atp/gnxas_cry.atp",
	       'gnxas_sym.atp'  => "$blib/lib/Xray/atp/gnxas_sym.atp",
	       #mol#'molecule6.atp'  => "$blib/lib/Xray/atp/molecule6.atp",
	       #mol#'molecule8.atp'  => "$blib/lib/Xray/atp/molecule8.atp",
	       'p1.atp'         => "$blib/lib/Xray/atp/p1.atp",
	       'p1_cartesian.atp' => "$blib/lib/Xray/atp/p1_cartesian.atp",
	       'pdb.atp'        => "$blib/lib/Xray/atp/pdb.atp",
	       'powder.atp'     => "$blib/lib/Xray/atp/powder.atp",
	       'symmetry.atp'   => "$blib/lib/Xray/atp/symmetry.atp",
	       'template6.atp'  => "$blib/lib/Xray/atp/template6.atp",
	       'template7.atp'  => "$blib/lib/Xray/atp/template7.atp",
	       'template8_exafs.atp'  => "$blib/lib/Xray/atp/template8_exafs.atp",
	       'template8.atp'  => "$blib/lib/Xray/atp/template8.atp",
	       'test.atp'       => "$blib/lib/Xray/atp/test.atp",
	       'unit.atp'       => "$blib/lib/Xray/atp/unit.atp",
	       'xyz.atp'        => "$blib/lib/Xray/atp/xyz.atp",
	      },
	     );
