## -*- cperl -*-
##
##  This file is part of Athena, copyright (c) 2001-2006 Bruce Ravel
##
##  This section of the code contains subroutines associated with
##  writing project files


sub save_project {
  Echo('No data!'), return unless ($current);
  my $save = lc($_[0]);
  if ($save eq 'marked') {
    my $m = 0;
    map {$m += $_} values %marked;
    Error("Saving marked groups aborted.  There are no marked groups."), return 1 unless ($m);
  };
  my $file;
  my $curr = $current;
  my $how  = 2;
  if (($save ne 'all quick') or ($project_name =~ /^\s*$/)) {
    my $path = $current_data_dir || Cwd::cwd;
    my $init = 'athena.prj';
    if ($project_name !~ /^\s*$/) {
      my $suff;
      ($init, $path, $suff) = fileparse($project_name);
    };
    local $Tk::FBox::a;
    local $Tk::FBox::b;
    my $types = [['Athena project files', '.prj'],
		 ['All Files', '*'],];
    $file = $top -> getSaveFile(-defaultextension=>'prj',
				-filetypes=>$types,
				#(not $is_windows) ?
				#  (-sortcmd=>sub{$Tk::FBox::a cmp $Tk::FBox::b}) : () ,
				-initialdir=>$path,
				-initialfile=>$init,
				-title => "Athena: Save project");
    return unless $file;
    #my ($name, $pth, $suffix) = fileparse($file);
    #$current_data_dir = $pth;
    if ($save eq 'marked') {
      &push_mru($file, 1, 0);
    } else {
      &push_mru($file, 1, 1);
    };
  } else {
    $file = $project_name;
  };
  ##open REC, '>'.$file or die $!;
  open REC, '>'.$file or do {
    Error("You cannot write to \"$file\"."); return
  };
  $top -> Busy(-recurse=>1,);
  local $| = 1;
  print REC "# Athena project file -- Athena version $VERSION\n";
  print REC $groups{$current} -> project_header;
  close REC;
  my $save_groupreplot = $config{general}{groupreplot};
  $config{general}{groupreplot} = 'none';
  my @keys = &sorted_group_list;
  foreach (@keys) {
    next if ($_ eq "Default Parameters");
    next if (($save eq 'marked') and (not $marked{$_}));
    set_properties(0, $_, 1);
    save_record($file, $how++, 0, $save);
  };
  open REC, '>>'.$file or die $!;
  my $journal = $notes{journal} -> get(qw(1.0 end));
  my $eol = $/;
  my $colon = ":";
  my $end = "End";
  my $lv = ucfirst("local ");
  my @journal = split(/$eol/, $journal);
  print REC Data::Dumper->Dump([\@journal], [qw/*journal/]), "\n\n";
  print REC Data::Dumper->Dump([\%plot_features], [qw/*plot_features/]), "\n\n";
  my @indic = (0);
  foreach (1 .. $#indicator) {
    push @indic, ["", $indicator[$_]->[1], $indicator[$_]->[2]]
  };
  print REC Data::Dumper->Dump([\@indic], [qw/*indicator/]), "\n\n";
  print REC Data::Dumper->Dump([\%lcf_data], [qw/*lcf_data/]), "\n\n";
  $lv .= "Var" . "iables";
  print REC "\n1;\n\n# $lv$colon\n# truncate-lines$colon t\n# End$colon\n";
  close REC;
  if ($config{general}{compress_prj}) {
    Echo("Compressing $file");
    my $stash = File::Spec->catfile($stash_dir, basename($file));
    move($file, $stash);
    my $gz    = gzopen($stash, 'rb');
    my $gzout = gzopen($file, 'wb9');
    my $buffer;
    $gzout->gzwrite($buffer) while $gz->gzread($buffer) > 0 ;
    $gz->gzclose;
    $gzout->gzclose;
    unlink $stash;
  };
  set_properties(1, $curr, 1);
  $config{general}{groupreplot} = $save_groupreplot;
  project_state(1) unless ($save eq 'marked');
  ($save =~ /all/)    and Echo("Saved entire project to $file", 0);
  ($save eq 'marked') and Echo("Saved all marked groups to $file", 0);
  $top->Unbusy;
};

sub read_record {
  my ($plot, $file, $old_group, $ra, $rx, $ry, $rstddev, $ri0) = @_;
  my $gp = "";
  my @args = @$ra; my @x = @$rx; my @y = @$ry; my @stddev = @$rstddev; my @i0 = @$ri0;

  ## deal with backward compatibility issues in the parameters
  ##
  ## need to accommodate the change to (groupname != listentry) in
  ## 0.8.009 without breaking old project files.  search ahead in
  ## @args for the label string and use it, if found.  otherwise use
  ## the old group name as the argument to group_name
  ##
  ## there is a chance that a project file comes from a version of
  ## athena between when I introduced peak fitting and when I made the
  ## main window modal.  I need to check that values of "fit
  ## amplitude" and "set amplitude" (from peak fitting) are changed to
  ## "fit amp."  and "set amp."
  ##
  ## then in 0.8.028 I change "arctangent" to "atan" and so on.
  my $old_label = $old_group;
  my $is_frozen = 0;
  foreach (0 .. $#args) {
    next unless defined $args[$_]; # undef is a possible value in @args
    if ($args[$_] eq 'label') {
      $old_label = $args[$_+1];
      next;
    } elsif ($args[$_] =~ /(fit|set) amplitude(.*)/) {
      $args[$_] = $1 . " amp." . $2;
    } elsif ($args[$_] =~ /peak_step/) { # this is to accommodate a
      $args[$_] =~ s/step/function/;     # small change to peakfitting
    				         # for 0.8.018
    } elsif (lc($args[$_]) =~ /arctangent/) {
      $args[$_] = 'atan';
    } elsif (lc($args[$_]) =~ /error/) {
      $args[$_] = 'erf';
    } elsif (lc($args[$_]) =~ /gauss/) {
      $args[$_] = 'gauss';
    } elsif (lc($args[$_]) =~ /loren/) {
      $args[$_] = 'loren';
    } elsif ($args[$_] eq 'frozen') { # need to turn off frozen-ness until the
      $is_frozen = $args[$_+1];       # record is imported
      $args[$_+1] = 0;
    };
  };

  my ($group, $label) = group_name($old_label);
  $label =~ s{[\"\']}{}g;
  ++$line_count;
  $groups{$group} = Ifeffit::Group -> new(file=>$file, group=>$group, label=>$label);
  $groups{$group} -> make(@args);
  $groups{$group} -> make(line=>$line_count, old_group=>$old_group);
  $groups{$group} -> make(is_rec=>1, is_raw=>0, update_bkg=>1, is_proj=>1);
  $groups{$group} -> make(i0 => "$group.i0") if (@i0);
  $groups{$group} -> put_titles;
  my ($x, $y, $z) = (0, 0, 0);
 SWITCH: {
    ($x,$y)    = ('.energy', '.det'),            last SWITCH if $groups{$group}->{not_data};
    ($x,$y)    = ('.energy', '.xmu'),            last SWITCH if $groups{$group}->{is_xmu};
    ($x,$y)    = ('.k',      '.chi'),            last SWITCH if $groups{$group}->{is_chi};
    ($x,$y,$z) = ('.r', '.chir_re', '.chir_im'), last SWITCH if $groups{$group}->{is_rsp};
    ($x,$y,$z) = ('.q', '.chiq_re', '.chiq_im'), last SWITCH if $groups{$group}->{is_qsp};
  };
  Ifeffit::put_array($group.$x, \@x);
  Ifeffit::put_array($group.$y, \@y);
  Ifeffit::put_array("$group.stddev", \@stddev) if (@stddev);
  Ifeffit::put_array("$group.i0",     \@i0)     if (@i0);
  ##($z) and Ifeffit::put_array($group.$z, \@z);

  ## fill_skinny unsets this parameter and it needs to be dealt with
  ## after the entire project is read
  my $save_stan = $groups{$group}->{bkg_stan};
  fill_skinny($list, $group, 1);
  $groups{$group}->make(bkg_stan=>$save_stan);
  if ($is_frozen) { # turn frozen-ness back on
    $groups{$group}->freeze;
    freeze_chores($group);
  };
  ($gp) or ($gp = $group);
  return $group unless $plot;
				# what about reading r or q records?
 SWITCH: {
    ($groups{$gp}->{is_xmu}) and do {
      $groups{$gp} -> plotE('emz',$dmode,\%plot_features, \@indicator);
      $last_plot = 'e';
      $last_plot_params = [$gp, 'group', 'e', 'emz'];
      last SWITCH;
    };
    ($groups{$gp}->{is_chi}) and do {
      #my $str = sprintf('k%1d', $groups{$gp}->{fft_kw});
      my $str = sprintf('k%1d', $plot_features{kw});
      $groups{$gp} -> plotk($str,$dmode,\%plot_features, \@indicator);
      $last_plot = 'k';
      $last_plot_params = [$gp, 'group', 'k', $str];
      last SWITCH;
    };
  };
  return $group;
};


## the call to save_record takes three arguments:
##  1st: filename or nil to prompt for filename
##  2nd: 0=open file to overwite, 1=open file to append
##  3rd: 0=save record as record type, 1=force saving as chi(k)

## save a record as a Data::Dumper file.  This contains four lvalues,
## 1) the group name from this session, 2) an array of parameters, 3)
## an x-array, 4) a y-array.  The x- and y-arrays are appropriate to
## the initial state of the data (i.e. the intial state of raw data is
## energy/xmu and the initial state of merged chi(k) data is k/chi).
sub save_record {
  Echo('No data!'), return unless ($current);
  Echo("Saving records is unsupported for R- and q-space data", 0), return
    if (($groups{$current}->{is_rsp}) or ($groups{$current}->{is_qsp}));
  Echonow("Saving record for group \"$groups{$current}->{label}\"", 0);
  my ($file, $how, $force_chik, $save) = @_;
  #my $how = ((defined $_[1]) and $_[1]) ? $_[1] : 0;
  #if (defined $_[0] and  $_[0]) {
  #  $file = $_[0]; # File::Spec->catfile($current_data_dir, $_[0].".rec");
  #} else {
  unless ($file) {
    local $Tk::FBox::a;
    local $Tk::FBox::b;
    my $path = $current_data_dir || Cwd::cwd;
    my $fname = ($force_chik) ? $current . "_chik.rec" : "$current.rec";
    my $types = [['Athena record files', '.rec'],
		 ['All Files', '*'],];
    $file = $top -> getSaveFile(-defaultextension=>'rec',
				-filetypes=>$types,
				#(not $is_windows) ?
				#  (-sortcmd=>sub{$Tk::FBox::a cmp $Tk::FBox::b}) : () ,
				-initialdir=>$path,
				-initialfile=>$fname,
				-title => "Athena: Save record");
    Echonow("Saving record for group \"$groups{$current}->{label}\" ... canceled", 0), return
      unless $file;
    my ($name, $pth, $suffix) = fileparse($file);
    $current_data_dir = $pth;
    ##&push_mru($file, 1);
  };
  refresh_titles($groups{$current}); # make sure titles are up-to-date
  my @args = ();
  foreach (sort keys(%{$groups{$current}})) {
    next if ($_ =~ /\b([ex]col|check(button)?|group|id|rect|text)\b/);
    next if ($_ eq 'made_pixel');
    next if ($_ =~ /^update/);
    next if ($_ eq "project_marked");
    ##next if ($_ =~ /^title/);
    if (($save eq 'marked') and ($_ eq 'reference') and ($groups{$current}->{reference})) {
      my $ref = $groups{$current}->{reference};
      next unless $marked{$ref};
    };
    push @args, $_, $groups{$current}->{$_};
  };
  push @args, "project_marked", $marked{$current};
  ## need to update from titles palette
  ## my @titles = @{$groups{$current}->{titles}};
  my (@x, @y, @z, @stddev, @i0);
 SWITCH: {
    ($force_chik) and do {
      $groups{$current}->dispatch_bkg($dmode) if $groups{$current}->{update_bkg};
      @x = Ifeffit::get_array($current.".k");
      @y = Ifeffit::get_array($current.".chi");
      ## need to flag this as a chi record -- appending new values to
      ## the end of @args is cheesy, but it works
      push @args, qw(is_chi 1 is_bkg 0 is_xmu 0 is_nor 0 is_merge 0);
      last SWITCH;
    };
    ($groups{$current}->{not_data}) and do {
      @x = Ifeffit::get_array($current.".energy");
      ## @x = map {$_ + $groups{$current}->{bkg_eshift}} @x;
      @y = Ifeffit::get_array($current.".det");
      last SWITCH;
    };
    ($groups{$current}->{is_xmu}) and do {
      @x = Ifeffit::get_array($current.".energy");
      ## @x = map {$_ + $groups{$current}->{bkg_eshift}} @x;
      @y = Ifeffit::get_array($current.".xmu");
      @i0 = Ifeffit::get_array($groups{$current}->{i0}) if ($groups{$current}->{i0});
      last SWITCH;
    };
    ($groups{$current}->{is_chi}) and do {
      @x = Ifeffit::get_array($current.".k");
      @y = Ifeffit::get_array($current.".chi");
      last SWITCH;
    };
    ($groups{$current}->{is_rsp}) and do {
      @x = Ifeffit::get_array($current.".r");
      @y = Ifeffit::get_array($current.".chir_re");
      @z = Ifeffit::get_array($current.".chir_im");
      last SWITCH;
    };
    ($groups{$current}->{is_qsp}) and do {
      @x = Ifeffit::get_array($current.".q");
      @y = Ifeffit::get_array($current.".chiq_re");
      @z = Ifeffit::get_array($current.".chiq_im");
      last SWITCH;
    };
  };
  ## what about chi(k) records with stddev???
  if ((not $force_chik) and $groups{$current}->{is_merge}) {
    @stddev = Ifeffit::get_array($current.".stddev");
  };
  my $open = ($how > 1) ? '>>' : '>';
  my $arg = (($how == 0) or ($how == 2)) ? 1 : 0;
  open REC, $open.$file or do {
    Error("You cannot write to \"$file\"."); return
  };
  ($how) or print REC "# Athena record file -- Athena version $VERSION\n";
  ($how) or print REC $groups{$current} -> project_header();
  print REC
    Data::Dumper->Dump([$current], [qw/old_group/]), "\n",
    Data::Dumper->Dump([\@args],   [qw/*args/]),     "\n",
    Data::Dumper->Dump([\@x],      [qw/*x/]),        "\n",
    Data::Dumper->Dump([\@y],      [qw/*y/]),        "\n";
  print REC Data::Dumper->Dump([\@stddev],[qw/*stddev/]), "\n" if @stddev;
  print REC Data::Dumper->Dump([\@i0],    [qw/*i0/]),     "\n" if $groups{$current}->{i0};
  print REC "[record]   # create object and set arrays in ifeffit\n\n";
  unless ($how) {

    my $colon = ":";
    my $end = "End";
    my $lv = ucfirst("local ");
    $lv .= "Var" . "iables";
    print REC "\n1;\n\n# $lv$colon\n# truncate-lines$colon t\n# End$colon\n";
  };
  close REC;
  Echonow("Wrote record to $file", 0);
};


sub close_project {
  reset_window($which_showing, $fat_showing, 0) unless ($fat_showing eq 'normal');
  delete_many($list, $dmode, 0);
  project_state(1);
};

## state=0 -> project needs to be saved  state=1 -> project has been saved
sub project_state {
  return unless $current;
  ##$_[0] || print join(" ", caller), $/;
  $project_saved = $_[0];
  $lab -> configure(-text=>($_[0]) ? "" : "modified");
  return if ($current eq "Default Parameters");
  autoreplot() if $config{general}{autoreplot};
  section_indicators();
};


sub section_indicators {
  return unless $current;
  return unless (exists $groups{$current});
  my ($blue, $cyan, $grey) = ($config{colors}{activehighlightcolor},
			      $config{colors}{requiresupdate},
			      $config{colors}{disabledforeground});
  #($blue, $cyan) = ($config{colors}{frozen}, $config{colors}{frozenrequiresupdate}) if $groups{$current}->{frozen};

 SWITCH:{
    ($groups{$current}->{is_xanes}) and do {
      $props{bkg} -> itemconfigure($header{bkg}, -fill=>($groups{$current}->{update_bkg}) ? $cyan : $blue);
      $props{bkg_secondary} -> itemconfigure($header{bkg_secondary}, -fill=>($groups{$current}->{update_bkg}) ? $cyan : $blue);
      $props{fft} -> itemconfigure($header{fft}, -fill=>$grey);
      $props{bft} -> itemconfigure($header{bft}, -fill=>$grey);
      last SWITCH;
    };
    ($groups{$current}->{is_xmu}) and do {
      $props{bkg} -> itemconfigure($header{bkg}, -fill=>($groups{$current}->{update_bkg}) ? $cyan : $blue);
      $props{bkg_secondary} -> itemconfigure($header{bkg_secondary}, -fill=>($groups{$current}->{update_bkg}) ? $cyan : $blue);
      $props{fft} -> itemconfigure($header{fft}, -fill=>($groups{$current}->{update_fft}) ? $cyan : $blue);
      $props{bft} -> itemconfigure($header{bft}, -fill=>($groups{$current}->{update_bft}) ? $cyan : $blue);
      last SWITCH;
    };
    ($groups{$current}->{is_chi}) and do {
      $props{bkg} -> itemconfigure($header{bkg}, -fill=>$grey);
      $props{bkg_secondary} -> itemconfigure($header{bkg_secondary}, -fill=>$grey);
      $props{fft} -> itemconfigure($header{fft}, -fill=>($groups{$current}->{update_fft}) ? $cyan : $blue);
      $props{bft} -> itemconfigure($header{bft}, -fill=>($groups{$current}->{update_bft}) ? $cyan : $blue);
      last SWITCH;
    };
    ($groups{$current}->{is_rsp}) and do {
      $props{bkg} -> itemconfigure($header{bkg}, -fill=>$grey);
      $props{bkg_secondary} -> itemconfigure($header{bkg_secondary}, -fill=>$grey);
      $props{fft} -> itemconfigure($header{fft}, -fill=>$grey);
      $props{bft} -> itemconfigure($header{bft}, -fill=>($groups{$current}->{update_bft}) ? $cyan : $blue);
      last SWITCH;
    };
    ($groups{$current}->{is_qsp}) and do {
      $props{bkg} -> itemconfigure($header{bkg}, -fill=>$grey);
      $props{bkg_secondary} -> itemconfigure($header{bkg_secondary}, -fill=>$grey);
      $props{fft} -> itemconfigure($header{fft}, -fill=>$grey);
      $props{bft} -> itemconfigure($header{bft}, -fill=>$grey);
      last SWITCH;
    };
    ($groups{$current}->{not_data}) and do {
      $props{bkg} -> itemconfigure($header{bkg}, -fill=>$grey);
      $props{bkg_secondary} -> itemconfigure($header{bkg_secondary}, -fill=>$grey);
      $props{fft} -> itemconfigure($header{fft}, -fill=>$grey);
      $props{bft} -> itemconfigure($header{bft}, -fill=>$grey);
      last SWITCH;
    };
  };

};

## END OF PROJECT FILE SUBSECTION
##########################################################################################
