/* 
	GXAnim : A GTK frontend to XAnim
	by Robert Warren
	(c) 1999

	This program is covered under the General Public License.
	See COPYING file for licensing information.
	
	===============================================

	gxanim.c

	main routines and startup

*/


#include "header.h" 


/*
	function : quit_event (pointer to widget, pointer to control struct)

	handle the "clicked the quit button" event and shut down GXAnim.
	free up shared memory.
*/

void quit_event (GtkWidget *widget, xcontrol *control)
{
	if (control->defaults->verbose)
		fprintf(stderr, "\nQuitting GXAnim..\n\n");

	control->defaults->holdonend = FALSE;
	stopxanim(widget, control);
	
	shmdt(control->play);
	shmctl(control->shmid, IPC_RMID, _NULL);

	gtk_main_quit();
}


/* 
	function : done_check (pointer to control struct)

	continually check control->play->playing (located in shared memory)
	for a situation where it is set to STOPPED and the window is still visible.
	this should only occur once XAnim has finished it's work and has exited,
	leaving behind the movie screen.

	when this point is reached, hide the movie screen and set to IDLE.

	this routine runs as a GTK timeout function every 20 milliseconds. 

	more will probably be added to this. (Sun 3/21/99 8:46a)
*/

gint done_check(xcontrol *control)
{
	I16 stat_val;

	if (control->play->playset == AUTOPLAY && control->play->playing == IDLE) {
		play_event(control);
	}

	if (control->play->playing == STOPPED) {
		gtk_statusbar_pop(GTK_STATUSBAR(control->main->statbar), control->main->context_id);

		if (control->play->playset != AUTOPLAY) {
			gtk_widget_hide_all(control->moviewin->window);
			show_window(_NULL, control->main->window);
		}
		
		wait ((int *)&stat_val);

		show_window(_NULL, control->main->window);
		control->play->playing = IDLE;
	}
	
	return (TRUE);
}



/*
	function : MAIN

	main routine.  set up everything.

*/

int main (I16 argc, char *argv[]) 
{
	xcontrol control;

	defaults_type *defaults = _NULL;
	defaults_type *config = _NULL;

	main_win topwindow;
	prefs_win prefwindow;
	about_win aboutwindow;
	screen_win moviewindow;

	stats *xstats = _NULL;
	void *shared_mem = _NULL;
	gint timeout_tag;

	I8 cnt = 0;
	
	config = dalloc(config, sizeof(defaults_type));
	defaults = dalloc(defaults, sizeof(defaults_type));
	xstats = dalloc(xstats, sizeof(stats));
 
	/* crank this sucker up! */
	
	gtk_init(&argc, &argv);


	/* get program defaults */
	
	control.defaults = defaults;
	get_config(&control);
	

	/* set config variables */

	control.movie = config;
	control.stats = xstats;
	control.stats->version = control.stats->type = _NULL;
	
	
	/* set up shared memory segments */

	control.shmkey = ftok((char *)getenv("HOME"), cnt);
	
	while ((control.shmid = shmget((key_t) control.shmkey, sizeof(play), 0666 | IPC_CREAT | IPC_EXCL)) && 
		cnt < 255 && control.shmid == -1) 
	{
		control.shmkey = ftok((char *)getenv("HOME"), ++cnt);
	}

	if (cnt < 255) {
		shared_mem = shmat(control.shmid, _NULL, 0);
		control.play = (play *) shared_mem;

		control.play->playing = IDLE; 	/* system defaults to IDLE playstate */
		control.play->playset = NOOP;	/* system defaults to NOOP play command */
	} 
	else
	{
		fprintf(stderr, "ERROR: Too many instances of GXAnim - 255 max!\n");
		_exit(FALSE);
	}

	/* check incoming parameters */

	if (argv[1]) {
		if (control.defaults->playonstart)
			control.play->playset = AUTOPLAY;
	}


	/* set up screens */

	
	
	control.about = &aboutwindow;
	make_about(control.about, &control);

	control.pref = &prefwindow;
	make_prefs(control.pref, &control);

	control.filew = make_filesel(control.filew, &control);
	
	control.main = &topwindow;
	make_top_win(control.main, &control);

	control.moviewin = &moviewindow;
	make_screen(control.moviewin, &control);

	set_defaults(_NULL, &control);
	
	
	if (control.play->playset == AUTOPLAY)
		gtk_entry_set_text (GTK_ENTRY(GTK_COMBO(control.main->combo)->entry), argv[1]);

		
	/* set timeout function running */

	timeout_tag = gtk_timeout_add(TIME_LEN, (GtkFunction) done_check, (gpointer) &control);


	/* drop into main cycle */
	
	gtk_main();
	return FALSE;
}






