/*
 * Main.java
 *
 * Created on December 13, 2000, 9:37 AM
 */

package com.sun.enterprise.config.backup.appserver;

import com.sun.enterprise.config.backup.status.StatusConstants;
import com.sun.enterprise.config.backup.*;
import com.sun.enterprise.config.backup.status.*;
import com.sun.enterprise.config.backup.EnvironmentConstants;
import com.sun.enterprise.config.backup.BackupRequest;
import com.sun.enterprise.config.backup.utils.SystemPropsHelper;

/**
 * This is the main class to be used for CLI in
 * the offline mode
 *
 * @author  sridatta
 */
public class Main {
    private static final int HISTORY_NUMBER = 6;
    
    /** Creates a new instance of Main */
    public Main() {
    }
    
    public static void main(String[] args) 
	{
		entry(args);
	}

	// bnevins TEMPORARY TBD
	public static void entry(BackupRequest br) 
	{
		br.verify();
		String[] dirs = br.getDirsToBackup();
		String allDirs = dirs[0];
		
		for(int i = 1; i < dirs.length; i++)
			allDirs += ',' + dirs[i];
		
		SystemPropsHelper.setProperty(EnvironmentConstants.DIRS_TO_BACKUP, allDirs);
		SystemPropsHelper.setProperty(EnvironmentConstants.DIR_TO_STORE_BACKUP_FILES, br.getDirToStoreBackupFiles());
		SystemPropsHelper.setProperty(EnvironmentConstants.BACKUP_STORAGE_TYPE, br.getBackupStorageType());

		try
		{
			BackupRestore bri = Util.getBackupRestore();
			Status s = bri.backup(null);
            System.out.println("==================");
            printStatus(s);
            System.out.println("==================");
            System.out.println(s.getExtraInfo());
            System.out.println("==================");
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
	}
	
    /**
     * @param args the command line arguments
     */
    private static void entry(String[] args) {
        try {
            if(args == null || args.length <1 || args[0] == null || "".equals(args[0])) {
                usage();
                return;
            }

			System.setProperty(EnvironmentConstants.DIRS_TO_BACKUP, "C:/tmp/tmp/tmp");
			System.setProperty(EnvironmentConstants.DIR_TO_STORE_BACKUP_FILES, "C:/temp/backup");
			System.setProperty(EnvironmentConstants.BACKUP_STORAGE_TYPE, "directory");
			//System.setProperty("backup_storage_type", "zip");
			BackupRestore bri = Util.getBackupRestore();
            Status s = null;
            if("backup".equals(args[0])) {
                String userInfo = null;
                if(args.length == 1) { // && (args[1] == null || "".equals(args[1]))) {
                    s = bri.backup(null);
                } else if(args.length == 2) { //&& (args[2] == null || "".equals(args[2]))) {
                    System.out.println("info=" + args[1]);
                    s =    bri.backup(args[1]);
                } else if(args.length == 3) {
                    s = bri.backup(args[1], args[2]);
                } else {
                    usage();
                    return;
                }
            } else if ("restore".equals(args[0])) {
                s = bri.restore();
            } else if("undorestore".equals(args[0])) {
                s = bri.undoRestore();
            } else if("listbackups".equals(args[0])) {
                BackupStatus[] bs = bri.listBackups();
                System.out.println("==================");
                
                printBackupStatus(bs);
                System.out.println("==================");
                
                return;
            } else if("listhistory".equals(args[0])) {
                int n=HISTORY_NUMBER;
                if(args.length==2) { // && args != null && !args[1].equals("") ) {
                    n = getHistoryNumber(args[1]);
                }
                BackupHistory bh = bri.getBackupHistory(n);
                System.out.println("==================");
                
                //printBackupStatus(bh);
                System.out.println(bh);
                System.out.println("==================");
                
                return;
            } else {
                System.out.println("sub-command invalid");
                usage();
                return;
            }
            System.out.println("==================");
            printStatus(s);
            System.out.println("==================");
            System.out.println(s.getExtraInfo());
            System.out.println("==================");
            
            //parse args
            
            //invoke on the right method
            
            //return correct values
            
        } catch(Exception e){
            e.printStackTrace();
        }
        
    }
    
    private static void printBackupStatus(BackupStatus[] bs) {
        if (bs == null || bs.length == 0) {
            System.out.println("There are no Backups");
        }
        System.out.println("Available Backups are:");
        for (int i = 0 ; i < bs.length; i ++) {
            System.out.println(bs[i]);
        }
    }
    private static void printStatus(Status s) {
        System.out.println(s);
    }
    
    private static void usage() {
        System.out.println("Usage: \n" +
         "asbackup backup <userInfo>\n" + 
         "asbackup backup absoluteFileName userInfo\n" + 
         "asbackup restore \n" + 
         "asbackup undorestore \n" +
         "asbackup listbackups \n" +
         "asbackup listhistory <numberOfHistories>");
    }
    
    private static int getHistoryNumber(String arg) {
        try {
            return new Integer(arg).intValue();
        } catch(Exception e) {
            return HISTORY_NUMBER;
        }
    }
}
