---
comments: false
---

# From 7.0 to 7.1
*Make sure you view this [upgrade guide from the `master` branch](https://gitlab.com/gitlab-org/gitlab-ce/tree/master/doc/update/7.0-to-7.1.md) for the most up to date instructions.*

### 0. Backup

```bash
cd /home/git/gitlab
sudo -u git -H bundle exec rake gitlab:backup:create RAILS_ENV=production
```

### 1. Stop server

```bash
sudo service gitlab stop
```

### 2. Update Ruby

If you are still using Ruby 1.9.3 or below, you will need to update Ruby.
You can check which version you are running with `ruby -v`.

If you are you running Ruby 2.0.x, you do not need to upgrade ruby, but can consider doing so for performance reasons.

If you are running Ruby 2.1.1 consider upgrading to 2.1.2, because of the high memory usage of Ruby 2.1.1.

Install, update dependencies:

```bash
sudo apt-get install build-essential zlib1g-dev libyaml-dev libssl-dev libgdbm-dev libreadline-dev libncurses5-dev libffi-dev curl
```

Download and compile Ruby:

```bash
mkdir /tmp/ruby && cd /tmp/ruby
curl --location --progress ftp://ftp.ruby-lang.org/pub/ruby/2.1/ruby-2.1.2.tar.gz | tar xz
cd ruby-2.1.2
./configure --disable-install-rdoc
make
sudo make install
```

Install Bundler:

```bash
sudo gem install bundler --no-ri --no-rdoc
```

### 3. Get latest code

```bash
cd /home/git/gitlab
sudo -u git -H git fetch --all
```

For GitLab Community Edition:

```bash
sudo -u git -H git checkout 7-1-stable
```

OR

For GitLab Enterprise Edition:

```bash
sudo -u git -H git checkout 7-1-stable-ee
```

### 4. Update gitlab-shell (and its config)

```bash
cd /home/git/gitlab-shell
sudo -u git -H git fetch
sudo -u git -H git checkout v1.9.6
```

### 5. Install libs, migrations, etc.

```bash
cd /home/git/gitlab

# MySQL installations (note: the line below states '--without ... postgres')
sudo -u git -H bundle install --without development test postgres --deployment

# PostgreSQL installations (note: the line below states '--without ... mysql')
sudo -u git -H bundle install --without development test mysql --deployment

# Run database migrations
sudo -u git -H bundle exec rake db:migrate RAILS_ENV=production

# Clean up assets and cache
sudo -u git -H bundle exec rake assets:clean assets:precompile cache:clear RAILS_ENV=production

# Update init.d script
sudo cp lib/support/init.d/gitlab /etc/init.d/gitlab
```

### 6. Update config files

#### New configuration options for gitlab.yml

There are new configuration options available for gitlab.yml. View them with the command below and apply them to your current gitlab.yml if desired.

```
git diff 7-0-stable:config/gitlab.yml.example 7-1-stable:config/gitlab.yml.example
```

### 7. Start application

    sudo service gitlab start
    sudo service nginx restart

### 8. Check application status

Check if GitLab and its environment are configured correctly:

    sudo -u git -H bundle exec rake gitlab:env:info RAILS_ENV=production

To make sure you didn't miss anything run a more thorough check with:

    sudo -u git -H bundle exec rake gitlab:check RAILS_ENV=production

If all items are green, then congratulations upgrade is complete!

## Things went south? Revert to previous version (7.0)

### 1. Revert the code to the previous version
Follow the [upgrade guide from 6.9 to 7.0](6.9-to-7.0.md), except for the database migration
(The backup is already migrated to the previous version)

### 2. Restore from the backup:

```bash
cd /home/git/gitlab
sudo -u git -H bundle exec rake gitlab:backup:restore RAILS_ENV=production
```
If you have more than one backup *.tar file(s) please add `BACKUP=timestamp_of_backup` to the command above.

[yaml]: https://gitlab.com/gitlab-org/gitlab-ce/blob/7-1-stable/config/gitlab.yml.example
