/*  Festalon - NSF Player
 *  Copyright (C) 2002 Ben Parnell
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "common.h"

static uint8 VPSG[8];
static uint8 VPSG2[3];

static void DoSQV1(void);
static void DoSQV2(void);
static void DoSawV(void);

static DECLFW(VRC6PSGW90)
{
 DoSQV1();VPSG[0]=V;
}
static DECLFW(VRC6PSGW91)
{
 DoSQV1();VPSG[2]=V;
}
static DECLFW(VRC6PSGW92)
{
 DoSQV1();VPSG[3]=V;
}
static DECLFW(VRC6PSGWA0)
{
 DoSQV2();VPSG[4]=V;
}
static DECLFW(VRC6PSGWA1)
{
 DoSQV2();VPSG[6]=V;
}
static DECLFW(VRC6PSGWA2)
{
 DoSQV2();VPSG[7]=V;
}
static DECLFW(VRC6PSGWB0)
{
 DoSawV();VPSG2[0]=V;
}
static DECLFW(VRC6PSGWB1)
{
 DoSawV();VPSG2[1]=V;
}
static DECLFW(VRC6PSGWB2)
{
 DoSawV();VPSG2[2]=V;
}

static int32 CVBC[3]={0,0,0};
static int32 dcount[2]={0,0};
static int32 vcount[3]={0,0,0};

static INLINE void DoSQV(int x)
{
 int32 V;
 int32 amp=((VPSG[x<<2]&15)<<8)*5/8;

 if(VPSG[(x<<2)|0x3]&0x80 && !(FSettings.disabled&(0x20<<x)))
 {
  if(VPSG[x<<2]&0x80)
  {
   for(V=CVBC[x];V<timestamp;V++)
    WaveHi[V]+=amp;
  }
  else
  {
   int32 thresh=(VPSG[x<<2]>>4)&7;
   for(V=CVBC[x];V<timestamp;V++)
   {
    if(dcount[x]>thresh)	/* Greater than, not >=.  Important. */
     WaveHi[V]+=amp;
    vcount[x]--;
    if(vcount[x]<=0)		/* Should only be <0 in a few circumstances. */
    {
     vcount[x]=(VPSG[(x<<2)|0x2]|((VPSG[(x<<2)|0x3]&15)<<8))+1;
     dcount[x]=(dcount[x]+1)&15;
    }
   }
  }
 }
 CVBC[x]=timestamp;
}

static void DoSQV1(void)
{
 DoSQV(0);
}

static void DoSQV2(void)
{
 DoSQV(1);
}

static void DoSawV(void)
{
 static uint8 b3=0;
 static int32 phaseacc=0;
 int32 V;

 if(VPSG2[2]&0x80 && !(FSettings.disabled&(0x80)))
 {
  for(V=CVBC[2];V<timestamp;V++)
  {
   WaveHi[V]+=(((phaseacc>>3)&0x1f)<<8)*5/8;
   vcount[2]--;
   if(vcount[2]<=0)
   {
    vcount[2]=(VPSG2[1]+((VPSG2[2]&15)<<8)+1)<<1;
    phaseacc+=VPSG2[0]&0x3f;
    b3++;
    if(b3==7)
    {
     b3=0;
     phaseacc=0;
    }

   }
  }
 }
 CVBC[2]=timestamp;
}
void VRC6Sound(void)
{
    DoSQV1();
    DoSQV2();
    DoSawV();
}

static void VRC6Sync(int32 ts)
{
 int x;
 for(x=0;x<3;x++) CVBC[x]=ts;
}

void VRC6SoundC(void)
{
  VRC6_ESI();
}

void VRC6_ESI(void)
{
        int x;

        GameExpSound.RChange=VRC6SoundC;
        GameExpSound.HiFill=VRC6Sound;
	GameExpSound.HiSync=VRC6Sync;
	GameExpSound.volmul=(1<<16)*7/8;
         for(x=000;x<0x1000;x+=4)
         {
          uint32 a;

          a=0x9000+x;
          SetWriteHandler(a,a,VRC6PSGW90);
          SetWriteHandler(a+1,a+1,VRC6PSGW91);
          SetWriteHandler(a+2,a+2,VRC6PSGW92);

          a=0xa000+x;
          SetWriteHandler(a,a,VRC6PSGWA0);
          SetWriteHandler(a+1,a+1,VRC6PSGWA1);
          SetWriteHandler(a+2,a+2,VRC6PSGWA2);

          a=0xb000+x;
          SetWriteHandler(a,a,VRC6PSGWB0);
          SetWriteHandler(a+1,a+1,VRC6PSGWB1);
          SetWriteHandler(a+2,a+2,VRC6PSGWB2);
         }
}


