/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFGI_UIP.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	char *cfgi_userINIpath(void)

	Return the base path where the user INI files resides

	The found path is cached within the heap to ensure it does not
	change during the life-time of the program

	Return:
		NULL: on out-of-memory

ob(ject): cfgi_userINIpath
su(bsystem): inifile
ty(pe): H
sy(nopsis): 
sh(ort description): Return the path to the user INI file
he(ader files): 
lo(ng description): Returns the name of the path to the user INI file
	dynamically allocates in the heap. The path is cached through the
	whole lifetime of the program once aquired. That shall ensure that
	the program access the same INI file, even if the environment or
	other parameters changed. \par
	Note: Unlike the system INI file there is only one possible path
	to user INI files.
pr(erequistes): 
va(lue): "" (pointer to '\0' character): on failure; \em{not} cached
	\item else: pointer to path
re(lated to): 
se(condary subsystems): 
xr(ef): 
im(port): 
fi(le): cfgi_uip.c
in(itialized by): 
bu(gs): This function CANNOT be used within the program to access user
	INI files of users other than the current one. Though, usually there is
	no save way to aquire the path to other user's profiles/home directories
	without making huge assumptions in DOS/Win environments.

*/

#include "initsupl.loc"

#ifndef _MICROC_
#include <stdlib.h>
#endif
#include "inifile.loc"
#include "environ.h"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFGI_UIP.C 1.5 2001/02/27 01:27:57 ska Exp ska $";
#endif

char *cfgi_userINIpath(void)
{	static char *p = 0;

	DBG_ENTER("cfgi_userINIpath", Suppl_inifile)

	chkHeap
	if(p == 0
	 && (p = dupvar("HOME")) == 0			/* Unix-like */
	 && (p = dupvar("USERPROFILE")) == 0)	/* WinNT-like */
	 	DBG_RETURN_S( "")

	chkHeap
	DBG_RETURN_S( p)
}
