/*
 * ColorPanel.java
 *
 * Created on 3 de marzo de 2005, 05:39 AM
 */

package dguitar.gui;

import i18n.Internationalized;

import javax.swing.JDialog;
import javax.swing.JFrame;


/**
 * This class allows the user to select the different Color Options
 * 
 * @author Mauricio Gracia Gutirrez
 */
public class ColorDialog extends JDialog 
implements Internationalized {
	protected ColorPanelNote fretColors;

	protected ColorPanelRhythm rhythmColors;

	private boolean okClicked;

	/**
	 * Creates new form ColorPanel that allow the user to select the different
	 * DisplayOptions
	 */
	public ColorDialog() {
		super();
		commonConstructor();
	}

	public ColorDialog(JFrame parent) {
		super(parent);
		commonConstructor();
	}

	private void commonConstructor() {
		initComponents();
		okClicked = false;
		fretColors = new ColorPanelNote();
		rhythmColors = new ColorPanelRhythm();
		this.tabs.add(DGuitar.lang.getString("colorFrets_Notes"), fretColors);
		this.tabs
				.add(DGuitar.lang.getString("colorRhythm_Lines"), rhythmColors);
		this.pack();
	}

	public boolean OKclicked() {
		return okClicked;
	}

	/**
	 * This method is called from within the constructor to initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is always
	 * regenerated by the Form Editor.
	 */
	private void initComponents() {//GEN-BEGIN:initComponents
		componentsCreate();
	}//GEN-END:initComponents

	private void componentsCreate() {
		tabs = new javax.swing.JTabbedPane();
		buttons = new javax.swing.JPanel();
		ok = new javax.swing.JButton();
		cancel = new javax.swing.JButton();

		setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
		setModal(true);
		getAccessibleContext().setAccessibleParent(null);
		getContentPane().add(tabs, java.awt.BorderLayout.CENTER);

		ok.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				okActionPerformed(evt);
			}
		});

		buttons.add(ok);

		cancel.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				cancelActionPerformed(evt);
			}
		});

		buttons.add(cancel);

		getContentPane().add(buttons, java.awt.BorderLayout.SOUTH);

		//INTERNATIONALIZATION here
		setLangText() ;
	}

	public void setLangText() {
		ok.setText(DGuitar.lang.getString("OK"));
		cancel.setText(DGuitar.lang.getString("CANCEL"));
	}

	private void cancelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelActionPerformed
		okClicked = false;
		this.dispose();
	}//GEN-LAST:event_cancelActionPerformed

	private void okActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okActionPerformed
		okClicked = true;
		this.dispose();
	}//GEN-LAST:event_okActionPerformed

	// Variables declaration - do not modify//GEN-BEGIN:variables
	private javax.swing.JPanel buttons;

	private javax.swing.JButton cancel;

	private javax.swing.JButton ok;

	private javax.swing.JTabbedPane tabs;
	// End of variables declaration//GEN-END:variables

}