/*
 * Decompiled with CFR 0.152.
 */
package dguitar.gui;

import dguitar.gui.DGuitar;
import dguitar.gui.DisplayOptions;
import dguitar.gui.listeners.MenuIndexedListener;
import i18n.Internationalized;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class SongOptionsMenu
extends JMenu
implements ActionListener,
Internationalized {
    private String keyName;
    private JMenuItem menuViewColorOptions;
    private JCheckBoxMenuItem menuViewMinPiece;
    private JCheckBoxMenuItem menuViewMultiTrack;
    private JCheckBoxMenuItem menuViewMusicCursors;
    private JCheckBoxMenuItem menuViewSingleMusicCursorsColor;
    private JCheckBoxMenuItem menuViewUnsupportedEffects;
    public static final int COLOR_OPTIONS = 1;
    public static final int MIN_PIECE = 2;
    public static final int MULTI_TRACK = 3;
    public static final int MUSIC_CURSORS = 4;
    public static final int SINGLE_MUSIC_CURSORS_COLOR = 5;
    public static final int UNSUPPORTED_EFFECTS = 99;
    private int selectedOption;
    private MenuIndexedListener songOptionsListener;
    private DisplayOptions displayOptions;

    public SongOptionsMenu() {
    }

    public SongOptionsMenu(String aKeyName) {
        if (aKeyName == null) {
            throw new NullPointerException("aDisplayOptions or aFrame is null");
        }
        this.keyName = aKeyName;
        this.selectedOption = -99;
        this.songOptionsListener = null;
        this.initComponents();
    }

    public void setMenuIndexedListener(MenuIndexedListener aSongOptionsListener) {
        this.songOptionsListener = aSongOptionsListener;
    }

    public void setDisplayOptions(DisplayOptions aDisplayOptions) {
        this.displayOptions = aDisplayOptions;
        this.menuViewMultiTrack.setSelected(this.displayOptions.multiTrackView);
        this.menuViewMinPiece.setSelected(this.displayOptions.minPieceSpacing);
        this.menuViewMusicCursors.setSelected(this.displayOptions.displayMusicCursor);
        this.menuViewSingleMusicCursorsColor.setSelected(!this.displayOptions.singleMusicCursorColor);
        this.menuViewUnsupportedEffects.setSelected(this.displayOptions.displayUnsupportedEffects);
    }

    private void initComponents() {
        this.menuViewMinPiece = new JCheckBoxMenuItem();
        this.menuViewMultiTrack = new JCheckBoxMenuItem();
        this.menuViewColorOptions = new JMenuItem();
        this.menuViewUnsupportedEffects = new JCheckBoxMenuItem();
        this.menuViewMusicCursors = new JCheckBoxMenuItem();
        this.menuViewSingleMusicCursorsColor = new JCheckBoxMenuItem();
        this.menuViewMinPiece.addActionListener(this);
        this.add(this.menuViewMinPiece);
        this.menuViewMultiTrack.addActionListener(this);
        this.add(this.menuViewMultiTrack);
        this.menuViewColorOptions.addActionListener(this);
        this.add(this.menuViewColorOptions);
        this.menuViewMusicCursors.addActionListener(this);
        this.add(this.menuViewMusicCursors);
        this.menuViewSingleMusicCursorsColor.addActionListener(this);
        this.add(this.menuViewSingleMusicCursorsColor);
        this.menuViewUnsupportedEffects.addActionListener(this);
        this.add(this.menuViewUnsupportedEffects);
        this.setLangText();
    }

    public void setLangText() {
        this.setText(DGuitar.lang.getString(this.keyName));
        this.menuViewMinPiece.setText(DGuitar.lang.getString("menuPIFMinDurPiece"));
        this.menuViewMultiTrack.setText(DGuitar.lang.getString("menuPIFMultiTrack"));
        this.menuViewColorOptions.setText(DGuitar.lang.getString("menuPIFColors"));
        this.menuViewMusicCursors.setText(DGuitar.lang.getString("menuViewMusicCursors"));
        this.menuViewUnsupportedEffects.setText(DGuitar.lang.getString("menuViewUnsupportedEffects"));
        this.menuViewSingleMusicCursorsColor.setText(DGuitar.lang.getString("menuSingleMusicCursorsColor"));
    }

    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        Class<?> c = obj.getClass();
        if (c.isInstance(this.menuViewColorOptions)) {
            this.selectedOption = 1;
        } else if (c.isInstance(this.menuViewMinPiece)) {
            this.selectedOption = 2;
        } else if (c.isInstance(this.menuViewMultiTrack)) {
            this.selectedOption = 3;
        } else if (c.isInstance(this.menuViewMusicCursors)) {
            this.selectedOption = 4;
        } else if (c.isInstance(this.menuViewSingleMusicCursorsColor)) {
            this.selectedOption = 5;
        } else if (c.isInstance(this.menuViewUnsupportedEffects)) {
            this.selectedOption = 99;
        }
        if (this.songOptionsListener != null) {
            this.songOptionsListener.menuClicked(this, this.selectedOption);
        }
    }

    public int getSelectedOption() {
        return this.selectedOption;
    }
}

