/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.datatypes;

import org.apache.fop.fo.Property;

public class Length {
    protected int millipoints = 0;
    protected double fontsize = 12.0;
    boolean auto = false;

    public Length(double d, Property property) {
        this.millipoints = (int)(d * (double)property.getLength().mvalue());
    }

    public Length(String string) {
        this.convert(string);
    }

    public Length(String string, int n) {
        this.fontsize = n;
        this.convert(string);
    }

    protected void convert(String string) {
        boolean bl = true;
        int n = string.length();
        if (n == 0) {
            System.err.println("WARNING: empty length");
            this.millipoints = 0;
        } else if (string.equals("auto")) {
            this.auto = true;
        } else {
            String string2 = string.substring(n - 2);
            double d = Double.valueOf(string.substring(0, n - 2));
            if (string2.equals("in")) {
                d *= 72.0;
            } else if (string2.equals("cm")) {
                d *= 28.35;
            } else if (string2.equals("mm")) {
                d *= 2.84;
            } else if (!string2.equals("pt")) {
                if (string2.equals("pc")) {
                    d *= 12.0;
                } else if (string2.equals("em")) {
                    d *= this.fontsize;
                } else if (string2.equals("px")) {
                    d *= (double)bl;
                } else {
                    d = 0.0;
                    System.err.println("ERROR: unknown length units in " + string);
                }
            }
            this.millipoints = (int)(d * 1000.0);
        }
    }

    public int mvalue() {
        return this.millipoints;
    }

    public String toString() {
        String string = String.valueOf(this.millipoints) + "mpt";
        return string;
    }
}

