/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.PrintStream;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;

public class DefaultLogger
implements BuildListener {
    private static int LEFT_COLUMN_SIZE = 12;
    private PrintStream out;
    private int msgOutputLevel;
    private long startTime = System.currentTimeMillis();

    public DefaultLogger(PrintStream out, int msgOutputLevel) {
        this.out = out;
        this.msgOutputLevel = msgOutputLevel;
    }

    public void buildFinished(BuildEvent event) {
        Throwable error = event.getException();
        if (error == null) {
            this.out.println("\nBUILD SUCCESSFUL");
        } else {
            this.out.println("\nBUILD FAILED\n");
            if (error instanceof BuildException) {
                this.out.println(error.toString());
                Throwable nested = ((BuildException)error).getException();
                if (nested != null) {
                    nested.printStackTrace(this.out);
                }
            } else {
                error.printStackTrace(this.out);
            }
        }
        this.out.println("\nTotal time: " + DefaultLogger.formatTime(System.currentTimeMillis() - this.startTime));
    }

    public void buildStarted(BuildEvent event) {
        this.startTime = System.currentTimeMillis();
    }

    private static String formatTime(long millis) {
        long seconds = millis / 1000L;
        long minutes = seconds / 60L;
        if (minutes > 0L) {
            return String.valueOf(Long.toString(minutes)) + " minutes " + Long.toString(seconds % 60L) + " seconds";
        }
        return String.valueOf(Long.toString(seconds)) + " seconds";
    }

    public void messageLogged(BuildEvent event) {
        if (event.getPriority() <= this.msgOutputLevel) {
            if (event.getTask() != null) {
                String name = event.getTask().getTaskName();
                String msg = "[" + name + "] ";
                int i = 0;
                while (i < LEFT_COLUMN_SIZE - msg.length()) {
                    this.out.print(" ");
                    ++i;
                }
                this.out.print(msg);
            }
            this.out.println(event.getMessage());
        }
    }

    public void targetFinished(BuildEvent event) {
    }

    public void targetStarted(BuildEvent event) {
        if (this.msgOutputLevel <= 2) {
            this.out.println("\n" + event.getTarget().getName() + ":");
        }
    }

    public void taskFinished(BuildEvent event) {
    }

    public void taskStarted(BuildEvent event) {
    }
}

