/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformer;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import org.apache.cocoon.framework.AbstractActor;
import org.apache.cocoon.framework.Director;
import org.apache.cocoon.framework.Status;
import org.apache.cocoon.parser.Parser;
import org.apache.cocoon.transformer.Transformer;
import org.apache.xalan.xpath.XObject;
import org.apache.xalan.xpath.xml.TreeWalker;
import org.apache.xalan.xpath.xml.XMLParserLiaison;
import org.apache.xalan.xpath.xml.XMLParserLiaisonDefault;
import org.apache.xalan.xslt.XSLTInputSource;
import org.apache.xalan.xslt.XSLTProcessor;
import org.apache.xalan.xslt.XSLTProcessorFactory;
import org.apache.xalan.xslt.XSLTResultTarget;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XalanTransformer
extends AbstractActor
implements Transformer,
Status {
    Parser parser;

    public String getStatus() {
        return "Xalan XSLT Processor";
    }

    public void init(Director director) {
        super.init(director);
        this.parser = (Parser)director.getActor("parser");
    }

    public Document transform(Document in, String inBase, Document sheet, String sheetBase, Document out, Dictionary params) throws Exception {
        XSLTProcessor processor = XSLTProcessorFactory.getProcessor((XMLParserLiaison)new XMLParser(this.parser));
        Enumeration enumeration = params.keys();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            String value = (String)params.get(name);
            processor.setStylesheetParam(name, (XObject)processor.createXString(value));
        }
        XSLTInputSource i = new XSLTInputSource((Node)in);
        XSLTInputSource s = new XSLTInputSource((Node)sheet);
        s.setSystemId(sheetBase);
        XSLTResultTarget o = new XSLTResultTarget((Node)out);
        processor.process(i, s, o);
        return out;
    }

    class XMLParser
    extends XMLParserLiaisonDefault {
        Parser parser;
        Document document;

        public XMLParser(Parser parser) {
            this.parser = parser;
        }

        public Document createDocument() {
            return this.parser.createEmptyDocument();
        }

        public Document getDocument() {
            return this.document;
        }

        public boolean getShouldExpandEntityRefs() {
            return true;
        }

        public void parse(InputSource in) throws IOException, SAXException {
            this.document = this.parser.parse(in, false);
            if (this.m_docHandler != null) {
                new TreeWalker(this.m_docHandler).traverse((Node)this.document);
            }
        }

        public boolean supportsSAX() {
            return true;
        }
    }
}

