/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.processor.ldap;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import org.apache.cocoon.framework.AbstractActor;
import org.apache.cocoon.framework.Status;
import org.apache.cocoon.processor.Processor;
import org.apache.cocoon.processor.ldap.LdapDefs;
import org.apache.cocoon.processor.ldap.LdapQueryCreator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LdapProcessor
extends AbstractActor
implements Processor,
Status {
    public String getStatus() {
        return "Ldap Processor";
    }

    public boolean hasChanged(Object o) {
        return true;
    }

    public Document process(Document doc, Dictionary parameters) throws Exception {
        LdapDefs ldefs = new LdapDefs(doc);
        NodeList query_nodes = doc.getElementsByTagName("ldap-query");
        Node[] query_nodes_ary = new Node[query_nodes.getLength()];
        int i = 0;
        while (i < query_nodes.getLength()) {
            query_nodes_ary[i] = query_nodes.item(i);
            ++i;
        }
        int i2 = 0;
        while (i2 < query_nodes_ary.length) {
            Node query_node = query_nodes_ary[i2];
            if (query_node.getNodeType() == 1) {
                Element query_element = (Element)query_node;
                String defs = query_element.getAttribute("defs");
                Properties query_props = ldefs.getQueryProperties(defs);
                NamedNodeMap query_attributes = query_element.getAttributes();
                int j = 0;
                while (j < query_attributes.getLength()) {
                    Node query_attribute = query_attributes.item(j);
                    ((Hashtable)query_props).put(query_attribute.getNodeName(), query_attribute.getNodeValue());
                    ++j;
                }
                LdapContext ctx = ldefs.getLdapContext(query_props.getProperty("server"));
                this.processQuery(doc, parameters, query_element, query_props, ctx);
            }
            ++i2;
        }
        return doc;
    }

    protected void processQuery(Document doc, Dictionary parameters, Element query_element, Properties query_props, LdapContext ctx) throws Exception {
        String doc_element_name = query_props.getProperty("doc-element");
        String row_element_name = query_props.getProperty("row-element");
        String id_attribute_name = query_props.getProperty("id-attribute");
        Element results_node = doc.createElement(doc_element_name);
        String ldap_searchbase = query_props.getProperty("ldap-searchbase");
        ldap_searchbase = ldap_searchbase == null ? "" : ldap_searchbase;
        NodeList query_text_nodes = query_element.getChildNodes();
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < query_text_nodes.getLength()) {
            Node query_text_node = query_text_nodes.item(i);
            if (query_text_node.getNodeType() == 3) {
                buf.append(query_text_node.getNodeValue());
            }
            ++i;
        }
        try {
            String query = LdapQueryCreator.getQuery(buf.toString(), query_props, parameters);
            SearchControls constraints = new SearchControls();
            constraints.setSearchScope(2);
            NamingEnumeration<SearchResult> ldapresults = ctx.search(ldap_searchbase, query, constraints);
            Element searchNode = results_node;
            Element searchElement = null;
            while (ldapresults != null && ldapresults.hasMore()) {
                SearchResult si = ldapresults.next();
                searchNode = searchElement = doc.createElement(row_element_name);
                searchElement.setAttribute(id_attribute_name, si.getName());
                Attributes attrs = si.getAttributes();
                if (attrs != null) {
                    NamingEnumeration<? extends Attribute> ae = attrs.getAll();
                    while (ae.hasMoreElements()) {
                        Attribute attr = ae.next();
                        String attrId = attr.getID();
                        NamingEnumeration<?> vals = attr.getAll();
                        while (vals.hasMoreElements()) {
                            Element attrElement = doc.createElement(attrId);
                            attrElement.appendChild(doc.createTextNode((String)vals.nextElement()));
                            searchNode.appendChild(attrElement);
                        }
                    }
                }
                results_node.appendChild(searchNode);
            }
            query_element.getParentNode().replaceChild(results_node, query_element);
        }
        catch (Exception e) {
            System.err.println("Exception: " + e);
        }
    }
}

