/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.rpc.core.java.util.logging;

import com.google.gwt.core.client.impl.SerializableThrowable;
import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.client.rpc.SerializationStreamReader;
import com.google.gwt.user.client.rpc.SerializationStreamWriter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class LogRecord_CustomFieldSerializer {
    public static void deserialize(SerializationStreamReader reader, LogRecord instance) throws SerializationException {
        String loggerName = reader.readString();
        Long millis = reader.readLong();
        Object throwable = reader.readObject();
        instance.setLoggerName(loggerName);
        instance.setMillis(millis);
        if (throwable != null && throwable instanceof SerializableThrowable) {
            instance.setThrown(((SerializableThrowable)throwable).getThrowable());
        }
    }

    public static LogRecord instantiate(SerializationStreamReader reader) throws SerializationException {
        String levelString = reader.readString();
        String msg = reader.readString();
        Level level = Level.parse(levelString);
        LogRecord toReturn = new LogRecord(level, msg);
        return toReturn;
    }

    public static void serialize(SerializationStreamWriter writer, LogRecord lr) throws SerializationException {
        writer.writeString(lr.getLevel().getName());
        writer.writeString(lr.getMessage());
        writer.writeString(lr.getLoggerName());
        writer.writeLong(lr.getMillis());
        if (lr.getThrown() != null) {
            writer.writeObject(new SerializableThrowable(lr.getThrown()));
        } else {
            writer.writeObject(null);
        }
    }
}

