// 
// File:          sort_SortTest_Impl.cc
// Symbol:        sort.SortTest-v0.1
// Symbol Type:   class
// Babel Version: 0.10.2
// Description:   Server-side implementation for sort.SortTest
// 
// WARNING: Automatically generated; only changes within splicers preserved
// 
// babel-version = 0.10.2
// 
#include "sort_SortTest_Impl.hh"

// 
// Includes for all method dependencies.
// 
#ifndef included_sidl_BaseInterface_hh
#include "sidl_BaseInterface.hh"
#endif
#ifndef included_sidl_ClassInfo_hh
#include "sidl_ClassInfo.hh"
#endif
#ifndef included_sort_SortingAlgorithm_hh
#include "sort_SortingAlgorithm.hh"
#endif
#line 26 "../../../../babel/regression/sort/libUCxx/sort_SortTest_Impl.cc"
// DO-NOT-DELETE splicer.begin(sort.SortTest._includes)
#ifndef included_sort_Counter_hh
#include "sort_Counter.hh"
#endif
#include <stdlib.h>
#include <sstream>
#include "sort_CompInt.hh"
#include "sort_IntegerContainer.hh"
#include "synch_RegOut.hh"

static const int32_t s_testSizes[] = {
  0,
  1,
  2,
  3,
  4,
  7,
  10,
  51,
  100,
  -1
};

static bool
notSorted(ucxx::sort::Container  &cont,
          ucxx::sort::Comparator &comp)
{
  const int32_t length = cont.getLength();
  for(int32_t i = 1 ; i < length ; ++i ){
    if (cont.compare(i-1, i, comp) > 0) return true;
  }
  return false;
}

static void
sortAndReport(ucxx::sort::SortingAlgorithm &alg,
	      ucxx::sort::Container        &cont,
	      ucxx::sort::Comparator       &comp, 
	      bool                   &result)
{
  ucxx::sort::Counter swpCnt;
  ucxx::sort::Counter cmpCnt;
  alg.reset();
  alg.sort(cont, comp);
  swpCnt = alg.getSwapCounter();
  cmpCnt = alg.getCompareCounter();
  std::ostringstream buf;
  buf << "compares (" << cmpCnt.getCount() << ") swaps ("
	    << swpCnt.getCount() << ")";
  ucxx::synch::RegOut::getInstance().writeComment(buf.str());
  if (notSorted(cont, comp)) {
    ucxx::synch::RegOut::getInstance().writeComment("sort failed!!");
    result = false;
  }
}
// DO-NOT-DELETE splicer.end(sort.SortTest._includes)
#line 83 "sort_SortTest_Impl.cc"

// user defined constructor
void sort::SortTest_impl::_ctor() {
#line 85 "../../../../babel/regression/sort/libUCxx/sort_SortTest_Impl.cc"
  // DO-NOT-DELETE splicer.begin(sort.SortTest._ctor)
  // add construction details here
  // DO-NOT-DELETE splicer.end(sort.SortTest._ctor)
#line 91 "sort_SortTest_Impl.cc"
}

// user defined destructor
void sort::SortTest_impl::_dtor() {
#line 92 "../../../../babel/regression/sort/libUCxx/sort_SortTest_Impl.cc"
  // DO-NOT-DELETE splicer.begin(sort.SortTest._dtor)
  // add destruction details here
  // DO-NOT-DELETE splicer.end(sort.SortTest._dtor)
#line 100 "sort_SortTest_Impl.cc"
}

// static class initializer
void sort::SortTest_impl::_load() {
#line 99 "../../../../babel/regression/sort/libUCxx/sort_SortTest_Impl.cc"
  // DO-NOT-DELETE splicer.begin(sort.SortTest._load)
  // guaranteed to be called at most once before any other method in this class
  // DO-NOT-DELETE splicer.end(sort.SortTest._load)
#line 109 "sort_SortTest_Impl.cc"
}

// user defined static methods:
/**
 * Perform the array stress test.
 * 
 * Return true if all the algorithms work okay.
 */
bool
sort::SortTest_impl::stressTest_impl (
  /* in */::ucxx::sidl::array< ::ucxx::sort::SortingAlgorithm> algs ) 
throw () 
{
#line 115 "../../../../babel/regression/sort/libUCxx/sort_SortTest_Impl.cc"
  // DO-NOT-DELETE splicer.begin(sort.SortTest.stressTest)
  bool result = false;
  if (algs._not_nil()) {
    const int32_t lower = algs.lower(0);
    const int32_t upper = algs.upper(0);
    int32_t i,j;
    result = true;
    for(i = lower; i <= upper; ++i) {
      ucxx::sort::SortingAlgorithm alg = algs.get(i);
      if (alg._not_nil()) {
        ucxx::sort::IntegerContainer data = ucxx::sort::IntegerContainer::_create();
        ucxx::sort::Container cont = data;
	ucxx::sort::CompInt intcomp = ucxx::sort::CompInt::_create();
        ucxx::sort::Comparator comp = intcomp;
        std::string name = alg.getName();
        j = 0;
	std::ostringstream buf;
	buf <<"****ALGORITHM IS " << name << "****";
	ucxx::synch::RegOut::getInstance().writeComment(buf.str());
        while (s_testSizes[j] >= 0) {
	  ucxx::synch::RegOut tracker = ucxx::synch::RegOut::getInstance();
	  std::ostringstream buf2;
	  intcomp.setSortIncreasing(true);
	  buf2 << "DATA SIZE " << s_testSizes[j] << '\n';
	  tracker.writeComment(buf2.str());
	  data.setLength(s_testSizes[j]);
	  sortAndReport(alg, cont, comp, result);
	  tracker.writeComment("pre-sorted list");
	  sortAndReport(alg, cont, comp, result);
	  tracker.writeComment("reverse sorted list");
          intcomp.setSortIncreasing(false);
	  sortAndReport(alg, cont, comp, result);
          ++j;
        }
      }
      else{
        result = false;
      }
    }
  }
  return result;
  // DO-NOT-DELETE splicer.end(sort.SortTest.stressTest)
#line 166 "sort_SortTest_Impl.cc"
}


// user defined non-static methods: (none)

#line 162 "../../../../babel/regression/sort/libUCxx/sort_SortTest_Impl.cc"
// DO-NOT-DELETE splicer.begin(sort.SortTest._misc)
// Put miscellaneous code here
// DO-NOT-DELETE splicer.end(sort.SortTest._misc)
#line 176 "sort_SortTest_Impl.cc"

