##
## File:        make.libPython
## Package:     Babel regression checks
## Revision:    $Revision: 4434 $
## Modified:    $Date: 2005-03-17 09:05:29 -0800 (Thu, 17 Mar 2005) $
## Description: automake makefile for C regression tests
##
## Copyright (c) 2000-2002, The Regents of the University of Calfornia.
## Produced at the Lawrence Livermore National Laboratory.
## Written by the Components Team <components@llnl.gov>
## UCRL-CODE-2002-054
## All rights reserved.
##
## This file is part of Babel. For more information, see
## http:##www.llnl.gov/CASC/components/. Please read the COPYRIGHT file
## for Our Notice and the LICENSE file for the GNU Lesser General Public
## License.
##
## This program is free software; you can redistribute it and/or modify it
## under the terms of the GNU Lesser General Public License (as published by
## the Free Software Foundation) version 2.1 dated February 1999.
##
## This program is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the IMPLIED WARRANTY OF
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the terms and
## conditions of the GNU Lesser General Public License for more details.
##
## You should have recieved a copy of the GNU Lesser General Public License
## along with this program; if not, write to the Free Software Foundation,
## Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA


OUTPUTSIDL=$(srcdir)/../../output/output.sidl

EXTRA_DIST = babel.make synch_babel.make $(PYTHONIMPL)/babel.make \
	synch/synch_babel.make

BABELGEN = $(IORSRCS) $(IORHDRS) $(SKELSRCS) $(LAUNCHSRCS) $(PYMOD_HDRS) \
	$(synch_IORHDRS) $(synch_IORSRCS) $(synch_PYMOD_HDRS) \
	setup.py synch_setup.py
CLEANFILES = $(BABELGEN) babel-stamp babel-temp \
	libImplPy.scl libImpl.scl core stamp-installcheck

PYTHONLIB = @PYTHONLIB@
PYTHONINC = @PYTHONINC@
PYTHONDIR=$(top_builddir)/runtime/python
SIDLPYTHONLIB=$(top_builddir)/runtime/sidl/.libs

libImpl_la_LDFLAGS        = -no-undefined -rpath `pwd`/.libs -release @VERSION@ -module
libImplPy_la_LDFLAGS      = -no-undefined -rpath `pwd`/.libs -release @VERSION@ -module

if SERVER_PYTHON
check_LTLIBRARIES = libImpl.la libImplPy.la

nodist_libImpl_la_SOURCES = $(IORSRCS) $(IORHDRS) $(LAUNCHSRCS) 
libImpl_la_LIBADD	  = $(LIBSIDL)

nodist_libImplPy_la_SOURCES = $(SKELSRCS)
libImplPy_la_LIBADD       = -L@PYTHON_SHARED_LIBRARY_DIR@	\
			    -lpython@PYTHON_VERSION@ $(LIBSIDL)

BABELDIR     = $(top_builddir)/bin
INCLUDEDIR   = $(top_builddir)/runtime/sidl
INCLUDEDIR2  = .
PYINCLUDEDIR = $(top_builddir)/runtime/python
LIBSIDL      = $(top_builddir)/runtime/sidl/libsidl.la

AM_CPPFLAGS   = -I. -I$(INCLUDEDIR) -I$(INCLUDEDIR2) \
		-I$(PYINCLUDEDIR) -I$(PYTHONINC)

$(BABELGEN) : babel-stamp
	@if test -f $@; then \
	    touch $@; \
	else \
	    rm -f babel-stamp; \
	    $(MAKE) $(AM_MAKEFLAGS) babel-stamp; \
	fi

babel-stamp libImpl.scl libImplPy.scl : $(SIDLFILE) $(OUTPUTSIDL)
	test -d $(PYTHONIMPL) || mkdir -p $(PYTHONIMPL) || exit 1
	@rm -f babel-temp
	@touch babel-temp
	$(SHELL) $(BABELDIR)/babel --vpath="$(srcdir)" --server=python \
	  --suppress-timestamp $(SIDLFILE)
	$(SHELL) $(BABELDIR)/babel --client=python --make-prefix=synch_ \
	  --suppress-timestamp --exclude-external $(OUTPUTSIDL)
	$(SHELL) $(top_srcdir)/bin/generate_scl libImpl.scl `pwd`/libImpl.la \
	   $(IORSRCS)
	$(SHELL) $(top_srcdir)/bin/generate_pyscl libImplPy.scl \
	   `pwd`/libImplPy.la $(IORSRCS)
	$(PYTHON) setup.py build_ext	\
	  --include-dirs=`cd $(INCLUDEDIR) && pwd`		\
	  --include-dirs=`cd $(INCLUDEDIR2) && pwd`		\
	  --include-dirs=`cd $(PYINCLUDEDIR) && pwd`		\
	  --library-dirs=`cd $(SIDLPYTHONLIB) && pwd`		\
	  --rpath=`cd $(SIDLPYTHONLIB) && pwd`			\
	  $(PYTHON_SETUP_ARGS) 					\
	  --inplace
	$(PYTHON) synch_setup.py build_ext	\
	  --include-dirs=`cd $(INCLUDEDIR) && pwd`		\
	  --include-dirs=`cd $(INCLUDEDIR2) && pwd`		\
	  --include-dirs=`cd $(PYINCLUDEDIR) && pwd`		\
	  --library-dirs=`cd $(SIDLPYTHONLIB) && pwd`		\
	  --rpath=`cd $(SIDLPYTHONLIB) && pwd`			\
	  $(PYTHON_SETUP_ARGS) 					\
	  --inplace
	@mv -f babel-temp babel-stamp

update-babel-make: babel-stamp
	if test "X$(srcdir)" != "X."; then \
	   cp babel.make synch_babel.make $(srcdir); \
	fi

check-local:
	@if test -f stamp-installcheck; then		\
	  echo $(MAKE) $(AM_MAKEFLAGS) clean;		\
	  $(MAKE) $(AM_MAKEFLAGS) clean;		\
	fi
	$(MAKE) $(AM_MAKEFLAGS) $(check_LTLIBRARIES)

installcheck-local:
	@if test ! -f stamp-installcheck; then		\
	  echo $(MAKE) $(AM_MAKEFLAGS) clean;		\
	  $(MAKE) $(AM_MAKEFLAGS) clean;		\
	fi
	$(MAKE) $(AM_MAKEFLAGS)				\
	  BABELDIR=$(bindir)				\
	  INCLUDEDIR=$(includedir)			\
	  INCLUDEDIR2=$(exec_prefix)/include 		\
	  PYINCLUDEDIR=$(prefix)/include/python$(PYTHON_VERSION)/babel \
	  LIBSIDL=$(libdir)/libsidl.la			\
	  SIDLPYTHONLIB=$(libdir)			\
	  PYTHONDIR=$(exec_prefix)/lib/python$(PYTHON_VERSION)/site-packages \
	  $(check_LTLIBRARIES) 
	touch stamp-installcheck
else
check-local:
installcheck-local:
endif

clean-local:
	rm -rf build synch
	test "X$(srcdir)" = "X." || rm -f babel.make synch_babel.make
	@if test -d $(sidlSUBDIR); then					\
	  cd $(sidlSUBDIR);						\
	  echo rm -f sedscript Makefile Makefile.pre Setup config.c;	\
	  rm -f sedscript Makefile Makefile.pre Setup config.c;		\
	  echo rm -f Setup.in *.so *.o *~ *.c *.h __init__.*;		\
	  rm -f Setup.in *.so *.o *~ *.c *.h __init__.*;		\
	fi

dist-hook:
	@for file in $(PYTHONSRC); do		\
	  d=`dirname $(distdir)/$(PYTHONIMPL)/$$file`;			\
	  test -f $$d || mkdir -p $$d || exit 1;			\
	  echo cp -p $(srcdir)/$(PYTHONIMPL)/$$file $(distdir)/$(PYTHONIMPL)/$$file;\
	  cp -p $(srcdir)/$(PYTHONIMPL)/$$file $(distdir)/$(PYTHONIMPL)/$$file;\
	done
	touch -c $(distdir)/Makefile.in

distclean-local:
	test "X$(srcdir)" = "X." || rm -rf $(PYTHONIMPL)

