/*
 * File:          Fib_Impl.java
 * Symbol:        ExceptionTest.Fib-v1.0
 * Symbol Type:   class
 * Babel Version: 0.10.2
 * Description:   Server-side implementation for ExceptionTest.Fib
 * 
 * WARNING: Automatically generated; only changes within splicers preserved
 * 
 * babel-version = 0.10.2
 */

package ExceptionTest;

import ExceptionTest.NegativeValueException;
import ExceptionTest.FibException;
import sidl.ClassInfo;
import sidl.BaseInterface;
import sidl.BaseClass;

// DO-NOT-DELETE splicer.begin(ExceptionTest.Fib._imports)
// Put additional imports here...
// DO-NOT-DELETE splicer.end(ExceptionTest.Fib._imports)

/**
 * Symbol "ExceptionTest.Fib" (version 1.0)
 * 
 * This class holds the method <code>getFib</code> that generates the
 * requested Fibonacci numbers.
 */
public class Fib_Impl extends Fib
{

  // DO-NOT-DELETE splicer.begin(ExceptionTest.Fib._data)
  // Put additional private data here...
  // DO-NOT-DELETE splicer.end(ExceptionTest.Fib._data)

  static { 
  // DO-NOT-DELETE splicer.begin(ExceptionTest.Fib._load)
  // Put load function implementation here...
  // DO-NOT-DELETE splicer.end(ExceptionTest.Fib._load)
  }

  /**
   * User defined constructor
   */
  public Fib_Impl(long IORpointer){
    super(IORpointer);
    // DO-NOT-DELETE splicer.begin(ExceptionTest.Fib.Fib)
    // add construction details here
    // DO-NOT-DELETE splicer.end(ExceptionTest.Fib.Fib)
  }

  /**
   * User defined destructing method
   */
  public void finalize() throws Throwable{
    super.finalize();
    // DO-NOT-DELETE splicer.begin(ExceptionTest.Fib._dtor)
    // add destruction details here
    // DO-NOT-DELETE splicer.end(ExceptionTest.Fib._dtor)
  }

  // user defined static methods: (none)

  // user defined non-static methods:
  /**
   * <p>
   * Generate the requested Fibonacci number or generate exceptions if
   * the input Fibonacci number is invalid or if any of the maximum depth
   * or maximum value parameters are exceeded.  The last argument of the
   * method should be zero.
   * </p>
   * <p>
   * The algorithm should be similar to the <code>Java</code> code below.
   * </p>
   * <pre>
   * public int getFib(int n, int max_depth, int max_value, int depth)
   *     throws NegativeValueException, FibException {
   * 
   *   if (n < 0) {
   *     throw new NegativeValueException("n negative");
   * 
   *   } else if (depth > max_depth) {
   *     throw new TooDeepException("too deep");
   * 
   *   } else if (n == 0) {
   *     return 1;
   * 
   *   } else if (n == 1) {
   *     return 1;
   * 
   *   } else {
   *     int a = getFib(n-1, max_depth, max_value, depth+1);
   *     int b = getFib(n-2, max_depth, max_value, depth+1);
   *     if (a + b > max_value) {
   *       throw new TooBigException("too big");
   *     }
   *     return a + b;
   *   }
   * } 
   * </pre>
   */
  public int getFib_Impl (
    /*in*/ int n,
    /*in*/ int max_depth,
    /*in*/ int max_value,
    /*in*/ int depth ) 
    throws ExceptionTest.NegativeValueException, 
    ExceptionTest.FibException
  {
    // DO-NOT-DELETE splicer.begin(ExceptionTest.Fib.getFib)
    // insert implementation here
     
    if (n < 0) {
      NegativeValueException neg = new NegativeValueException();
      neg.setNote("n negative");
      throw neg;

    } else if (depth > max_depth) {
      TooDeepException t = new TooDeepException();
      t.setNote("Too Deep");
      throw t;

    } else if (n == 0) {
      return 1;
      
    } else if (n == 1) {
      return 1;
      
    } else {
      int a = getFib(n-1, max_depth, max_value, depth+1);
      int b = getFib(n-2, max_depth, max_value, depth+1);
      if (a + b > max_value) {
        TooBigException t = new TooBigException();
        t.setNote("Too Big");
        throw t;
      }
      return a + b;
    }

    // DO-NOT-DELETE splicer.end(ExceptionTest.Fib.getFib)
  }


  // DO-NOT-DELETE splicer.begin(ExceptionTest.Fib._misc)
  // Put miscellaneous code here
  // DO-NOT-DELETE splicer.end(ExceptionTest.Fib._misc)

} // end class Fib

