// 
// File:          ExceptionTest_Fib_Impl.hh
// Symbol:        ExceptionTest.Fib-v1.0
// Symbol Type:   class
// Babel Version: 0.10.2
// Description:   Server-side implementation for ExceptionTest.Fib
// 
// WARNING: Automatically generated; only changes within splicers preserved
// 
// babel-version = 0.10.2
// 

#ifndef included_ExceptionTest_Fib_Impl_hh
#define included_ExceptionTest_Fib_Impl_hh

#ifndef included_sidl_cxx_hh
#include "sidl_cxx.hh"
#endif
#ifndef included_ExceptionTest_Fib_IOR_h
#include "ExceptionTest_Fib_IOR.h"
#endif
// 
// Includes for all method dependencies.
// 
#ifndef included_ExceptionTest_Fib_hh
#include "ExceptionTest_Fib.hh"
#endif
#ifndef included_ExceptionTest_FibException_hh
#include "ExceptionTest_FibException.hh"
#endif
#ifndef included_ExceptionTest_NegativeValueException_hh
#include "ExceptionTest_NegativeValueException.hh"
#endif
#ifndef included_sidl_BaseInterface_hh
#include "sidl_BaseInterface.hh"
#endif
#ifndef included_sidl_ClassInfo_hh
#include "sidl_ClassInfo.hh"
#endif


#line 42 "../../../../babel/regression/exceptions/libCxx/ExceptionTest_Fib_Impl.hh"
// DO-NOT-DELETE splicer.begin(ExceptionTest.Fib._includes)
// Put additional includes or other arbitrary code here...
// DO-NOT-DELETE splicer.end(ExceptionTest.Fib._includes)
#line 46 "ExceptionTest_Fib_Impl.hh"

namespace ExceptionTest { 

  /**
   * Symbol "ExceptionTest.Fib" (version 1.0)
   * 
   * This class holds the method <code>getFib</code> that generates the
   * requested Fibonacci numbers.
   */
  class Fib_impl
#line 55 "../../../../babel/regression/exceptions/libCxx/ExceptionTest_Fib_Impl.hh"
  // DO-NOT-DELETE splicer.begin(ExceptionTest.Fib._inherits)
  // Put additional inheritance here...
  // DO-NOT-DELETE splicer.end(ExceptionTest.Fib._inherits)
#line 61 "ExceptionTest_Fib_Impl.hh"
  {

  private:
    // Pointer back to IOR.
    // Use this to dispatch back through IOR vtable.
    Fib self;

#line 65 "../../../../babel/regression/exceptions/libCxx/ExceptionTest_Fib_Impl.hh"
    // DO-NOT-DELETE splicer.begin(ExceptionTest.Fib._implementation)
    // Put additional implementation details here...
    // DO-NOT-DELETE splicer.end(ExceptionTest.Fib._implementation)
#line 73 "ExceptionTest_Fib_Impl.hh"

  private:
    // private default constructor (required)
    Fib_impl() 
    {} 

  public:
    // sidl constructor (required)
    // Note: alternate Skel constructor doesn't call addref()
    // (fixes bug #275)
    Fib_impl( struct ExceptionTest_Fib__object * s ) : self(s,true) { _ctor(); }

    // user defined construction
    void _ctor();

    // virtual destructor (required)
    virtual ~Fib_impl() { _dtor(); }

    // user defined destruction
    void _dtor();

    // static class initializer
    static void _load();

  public:


    /**
     * <p>
     * Generate the requested Fibonacci number or generate exceptions if
     * the input Fibonacci number is invalid or if any of the maximum depth
     * or maximum value parameters are exceeded.  The last argument of the
     * method should be zero.
     * </p>
     * <p>
     * The algorithm should be similar to the <code>Java</code> code below.
     * </p>
     * <pre>
     * public int getFib(int n, int max_depth, int max_value, int depth)
     *     throws NegativeValueException, FibException {
     * 
     *   if (n < 0) {
     *     throw new NegativeValueException("n negative");
     * 
     *   } else if (depth > max_depth) {
     *     throw new TooDeepException("too deep");
     * 
     *   } else if (n == 0) {
     *     return 1;
     * 
     *   } else if (n == 1) {
     *     return 1;
     * 
     *   } else {
     *     int a = getFib(n-1, max_depth, max_value, depth+1);
     *     int b = getFib(n-2, max_depth, max_value, depth+1);
     *     if (a + b > max_value) {
     *       throw new TooBigException("too big");
     *     }
     *     return a + b;
     *   }
     * } 
     * </pre>
     */
    int32_t
    getFib (
      /* in */ int32_t n,
      /* in */ int32_t max_depth,
      /* in */ int32_t max_value,
      /* in */ int32_t depth
    )
    throw ( 
      ::ExceptionTest::NegativeValueException, 
      ::ExceptionTest::FibException
    );

  };  // end class Fib_impl

} // end namespace ExceptionTest

#line 148 "../../../../babel/regression/exceptions/libCxx/ExceptionTest_Fib_Impl.hh"
// DO-NOT-DELETE splicer.begin(ExceptionTest.Fib._misc)
// Put miscellaneous things here...
// DO-NOT-DELETE splicer.end(ExceptionTest.Fib._misc)
#line 158 "ExceptionTest_Fib_Impl.hh"

#endif
