/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.update;

import com.aelitis.azureus.core.clientstats.StreamDecoder;
import com.aelitis.azureus.core.clientstats.StreamEncoder;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.html.HTMLPageFactory;
import org.gudy.azureus2.core3.logging.LGLogger;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.update.UpdatableComponent;
import org.gudy.azureus2.plugins.update.UpdateChecker;
import org.gudy.azureus2.plugins.update.UpdateInstaller;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderAdapter;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderDelayedFactory;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderFactory;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderListener;

public class CoreUpdateChecker
implements Plugin,
UpdatableComponent {
    public static final String LATEST_VERSION_PROPERTY = "latest_version";
    public static final int RD_GET_DETAILS_RETRIES = 3;
    public static final int RD_GET_MIRRORS_RETRIES = 3;
    public static final int RD_SIZE_RETRIES = 3;
    public static final int RD_SIZE_TIMEOUT = 10000;
    protected static CoreUpdateChecker singleton;
    protected PluginInterface plugin_interface;
    protected ResourceDownloaderFactory rdf;
    protected LoggerChannel log;
    protected ResourceDownloaderListener rd_logger;

    public static void doUsageStats() {
        singleton.doUsageStatsSupport();
    }

    public CoreUpdateChecker() {
        singleton = this;
    }

    protected void doUsageStatsSupport() {
        try {
            if (COConfigurationManager.getBooleanParameter("Send Version Info")) {
                this.performStatsServerUpdate();
                this.log.log("Anonymous ID usage report ok");
            }
        }
        catch (Throwable e) {
            this.log.log("Anonymous ID usage report fails", e);
        }
    }

    public void initialize(PluginInterface _plugin_interface) {
        this.plugin_interface = _plugin_interface;
        this.plugin_interface.getPluginProperties().setProperty("plugin.name", "Core Updater");
        this.log = this.plugin_interface.getLogger().getChannel("CoreUpdater");
        this.rd_logger = new ResourceDownloaderAdapter(){

            public void reportActivity(ResourceDownloader downloader, String activity) {
                CoreUpdateChecker.this.log.log(activity);
            }
        };
        Properties props = this.plugin_interface.getPluginProperties();
        props.setProperty("plugin.version", this.plugin_interface.getAzureusVersion());
        this.rdf = this.plugin_interface.getUtilities().getResourceDownloaderFactory();
        this.plugin_interface.getUpdateManager().registerUpdatableComponent(this, true);
    }

    public String getName() {
        return "Azureus Core";
    }

    public int getMaximumCheckTime() {
        return 30;
    }

    public void checkForUpdate(final UpdateChecker checker) {
        try {
            try {
                String current_version = this.plugin_interface.getAzureusVersion();
                this.log.log("Update check starts: current = " + current_version);
                boolean TESTING = false;
                if (TESTING) {
                    System.out.println("CoreUpdater: !!!! Testing mode !!!!");
                }
                Map decoded = this.performStatsServerUpdate();
                String latest_version = null;
                String latest_file_name = null;
                byte[] b_version = (byte[])decoded.get("version");
                if (b_version == null) {
                    throw new Exception("No version found in reply");
                }
                latest_version = new String(b_version);
                this.plugin_interface.getPluginProperties().setProperty(LATEST_VERSION_PROPERTY, latest_version);
                byte[] b_filename = (byte[])decoded.get("filename");
                if (b_filename != null) {
                    latest_file_name = new String(b_filename);
                }
                String msg = "Core: latest_version = '" + latest_version + "', file = '" + latest_file_name + "'";
                checker.reportProgress(msg);
                this.log.log(msg);
                boolean latest_is_cvs = Constants.isCVSVersion(latest_version);
                String latest_base = Constants.getBaseVersion(latest_version);
                String current_base = Constants.getBaseVersion();
                if (latest_is_cvs && !TESTING) {
                    checker.completed();
                    return;
                }
                if (Constants.compareVersions(current_base, latest_base) >= 0 && !TESTING) {
                    checker.completed();
                    return;
                }
                final String f_latest_version = latest_version;
                final String f_latest_file_name = latest_file_name;
                ResourceDownloader[] primary_mirrors = TESTING ? this.getTestMirrors() : this.getPrimaryDownloaders(latest_file_name);
                ResourceDownloader random_primary_mirrors = this.rdf.getRandomDownloader(primary_mirrors);
                ResourceDownloader backup_downloader = this.rdf.create(new ResourceDownloaderDelayedFactory(){

                    public ResourceDownloader create() {
                        ResourceDownloader[] backup_mirrors = CoreUpdateChecker.this.getBackupDownloaders(f_latest_file_name);
                        return CoreUpdateChecker.this.rdf.getRandomDownloader(backup_mirrors);
                    }
                });
                ResourceDownloader top_downloader = this.rdf.getAlternateDownloader(new ResourceDownloader[]{random_primary_mirrors, backup_downloader});
                top_downloader.addListener(this.rd_logger);
                top_downloader.getSize();
                top_downloader.addListener(new ResourceDownloaderAdapter(){

                    public boolean completed(ResourceDownloader downloader, InputStream data) {
                        CoreUpdateChecker.this.installUpdate(checker, downloader, f_latest_version, data);
                        return true;
                    }
                });
                byte[] info_b = (byte[])decoded.get("info");
                String info = null;
                if (info_b != null) {
                    try {
                        info = new String(info_b);
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
                String[] desc = info == null ? new String[]{"Core Azureus Version"} : new String[]{"Core Azureus Version", info};
                checker.addUpdate("Core Azureus Version", desc, latest_version, top_downloader, 2);
            }
            catch (Throwable e) {
                this.log.log(e);
                Debug.printStackTrace(e);
                checker.failed();
            }
        }
        finally {
            checker.completed();
        }
    }

    protected Map performStatsServerUpdate() throws Exception {
        SocketChannel channel = null;
        try {
            ByteBuffer reply;
            channel = SocketChannel.open();
            channel.configureBlocking(true);
            channel.connect(new InetSocketAddress("azureus.aelitis.com", 6868));
            channel.finishConnect();
            ByteBuffer message = ByteBuffer.wrap(BEncoder.encode(this.constructStatsServerMessage()));
            StreamEncoder encoder = new StreamEncoder("AZH", message);
            while (!encoder.encode(channel)) {
            }
            StreamDecoder decoder = new StreamDecoder("AZR");
            while ((reply = decoder.decode(channel)) == null) {
            }
            Map reply_message = BDecoder.decode(reply.array());
            this.displayUserMessage(reply_message);
            Map map = reply_message;
            if (channel != null) {
                channel.close();
            }
            return map;
        }
        catch (Throwable throwable) {
            if (channel != null) {
                channel.close();
            }
            throw throwable;
        }
    }

    private Map constructStatsServerMessage() {
        HashMap<String, Object> message = new HashMap<String, Object>();
        String id = COConfigurationManager.getStringParameter("ID", null);
        if (id != null && COConfigurationManager.getBooleanParameter("Send Version Info")) {
            message.put("id", id);
            message.put("version", "2.2.0.2");
            message.put("os", Constants.OSName);
            String java_version = System.getProperty("java.version");
            if (java_version == null) {
                java_version = "unknown";
            }
            message.put("java", java_version);
            String java_vendor = System.getProperty("java.vm.vendor");
            if (java_vendor == null) {
                java_vendor = "unknown";
            }
            message.put("javavendor", java_vendor);
            long max_mem = Runtime.getRuntime().maxMemory() / 0x100000L;
            message.put("javamx", new Long(max_mem));
            PluginInterface[] plugins = this.plugin_interface.getPluginManager().getPluginInterfaces();
            ArrayList<String> pids = new ArrayList<String>();
            int i = 0;
            while (i < plugins.length) {
                String pid = plugins[i].getPluginID();
                if (!(pid.startsWith("<") || pid.startsWith("azupdater") || pid.startsWith("azplatform") || pids.contains(pid))) {
                    pids.add(pid);
                }
                ++i;
            }
            message.put("plugins", pids);
        }
        return message;
    }

    private void displayUserMessage(Map reply) {
        try {
            String last;
            String s_message;
            byte[] message = (byte[])reply.get("message");
            if (message != null && !(s_message = new String(message)).equals(last = COConfigurationManager.getStringParameter("CoreUpdateChecker.lastmessage", ""))) {
                int alert_type = 1;
                String alert_text = s_message;
                if (alert_text.startsWith("i:")) {
                    alert_type = 0;
                    alert_text = alert_text.substring(2);
                }
                LGLogger.logUnrepeatableAlert(alert_type, alert_text);
                COConfigurationManager.setParameter("CoreUpdateChecker.lastmessage", s_message);
                COConfigurationManager.save();
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    protected ResourceDownloader[] getPrimaryDownloaders(String latest_file_name) {
        ArrayList<URL> res;
        block8: {
            this.log.log("Downloading primary mirrors");
            res = new ArrayList<URL>();
            try {
                if (latest_file_name == null) {
                    res.add(new URL("http://azureus.sourceforge.net/Azureus2.jar"));
                    break block8;
                }
                URL mirrors_url = new URL("http://prdownloads.sourceforge.net/azureus/" + latest_file_name + "?download");
                ResourceDownloader rd = this.rdf.create(mirrors_url);
                rd = this.rdf.getRetryDownloader(rd, 3);
                rd.addListener(this.rd_logger);
                String page = HTMLPageFactory.loadPage(rd.download()).getContent();
                String pattern = "/azureus/" + latest_file_name + "?use_mirror=";
                int position = page.indexOf(pattern);
                while (position > 0) {
                    int end = page.indexOf(">", position);
                    if (end < 0) {
                        position = -1;
                        continue;
                    }
                    String mirror = page.substring(position, end);
                    try {
                        res.add(new URL("http://prdownloads.sourceforge.net" + mirror));
                    }
                    catch (Throwable e) {
                        this.log.log("Invalid URL read:" + mirror, e);
                    }
                    position = page.indexOf(pattern, position + 1);
                }
            }
            catch (Throwable e) {
                this.log.log("Failed to read primary mirror list", e);
            }
        }
        ResourceDownloader[] dls = new ResourceDownloader[res.size()];
        int i = 0;
        while (i < res.size()) {
            URL url = (URL)res.get(i);
            this.log.log("    Primary mirror:" + url.toString());
            ResourceDownloader dl = this.rdf.create(url);
            dl = this.rdf.getMetaRefreshDownloader(dl);
            dls[i] = dl = this.rdf.getSuffixBasedDownloader(dl);
            ++i;
        }
        return dls;
    }

    protected ResourceDownloader[] getBackupDownloaders(String latest_file_name) {
        ArrayList<URL> res;
        block6: {
            res = new ArrayList<URL>();
            try {
                if (latest_file_name == null) break block6;
                this.log.log("Downloading backup mirrors");
                URL mirrors_url = new URL("http://azureus.sourceforge.net/mirrors.php");
                ResourceDownloader rd = this.rdf.create(mirrors_url);
                rd = this.rdf.getRetryDownloader(rd, 3);
                rd.addListener(this.rd_logger);
                BufferedInputStream data = new BufferedInputStream(rd.download());
                Map decoded = BDecoder.decode(data);
                data.close();
                List mirrors = (List)decoded.get("mirrors");
                int i = 0;
                while (i < mirrors.size()) {
                    String mirror = new String((byte[])mirrors.get(i));
                    try {
                        res.add(new URL(String.valueOf(mirror) + latest_file_name));
                    }
                    catch (Throwable e) {
                        this.log.log("Invalid URL read:" + mirror, e);
                    }
                    ++i;
                }
            }
            catch (Throwable e) {
                this.log.log("Failed to read backup mirror list", e);
            }
        }
        ResourceDownloader[] dls = new ResourceDownloader[res.size()];
        int i = 0;
        while (i < res.size()) {
            URL url = (URL)res.get(i);
            this.log.log("    Primary mirror:" + url.toString());
            ResourceDownloader dl = this.rdf.create(url);
            dls[i] = dl = this.rdf.getSuffixBasedDownloader(dl);
            ++i;
        }
        return dls;
    }

    protected ResourceDownloader[] getTestMirrors() {
        try {
            ResourceDownloader[] dls = new ResourceDownloader[1];
            ResourceDownloader rd = this.rdf.create(new URL("http://66.90.75.92/suprnova//torrents/1822/DivX511-exe.torrent"));
            dls[0] = rd = this.rdf.getSuffixBasedDownloader(rd);
            return dls;
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return new ResourceDownloader[0];
        }
    }

    protected void installUpdate(UpdateChecker checker, ResourceDownloader rd, String version, InputStream data) {
        try {
            String temp_jar_name = "Azureus2_" + version + ".jar";
            String target_jar_name = "Azureus2.jar";
            UpdateInstaller installer = checker.createInstaller();
            installer.addResource(temp_jar_name, data);
            if (Constants.isOSX) {
                installer.addMoveAction(temp_jar_name, String.valueOf(installer.getInstallDir()) + "/Azureus.app/Contents/Resources/Java/" + target_jar_name);
            } else {
                installer.addMoveAction(temp_jar_name, String.valueOf(installer.getInstallDir()) + File.separator + target_jar_name);
            }
        }
        catch (Throwable e) {
            rd.reportActivity("Update install failed:" + e.getMessage());
        }
    }
}

