/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class PeersItem
extends CoreTableColumn
implements TableCellRefreshListener {
    public PeersItem(String sTableID) {
        super("peers", 3, -2, 60, sTableID);
        this.setRefreshInterval(-2);
    }

    public void refresh(TableCell cell) {
        long value;
        long lConnectedPeers = 0L;
        long lTotalPeers = -1L;
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        if (dm != null) {
            lConnectedPeers = dm.getNbPeers();
            TRTrackerScraperResponse hd = dm.getTrackerScrapeResponse();
            if (hd != null && hd.isValid()) {
                lTotalPeers = hd.getPeers();
            }
        }
        if (!cell.setSortValue(value = lConnectedPeers * 10000000L + lTotalPeers) && cell.isValid()) {
            return;
        }
        String tmp = String.valueOf(lConnectedPeers);
        if (lTotalPeers != -1L) {
            tmp = String.valueOf(tmp) + " (" + lTotalPeers + ")";
        } else {
            lTotalPeers = 0L;
        }
        cell.setText(tmp);
    }
}

