/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.table.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TableItem;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPiece;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrent;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.pluginsimpl.local.disk.DiskManagerFileInfoImpl;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.peers.PeerImpl;
import org.gudy.azureus2.pluginsimpl.local.tracker.TrackerTorrentImpl;
import org.gudy.azureus2.ui.swt.components.BufferedTableRow;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;
import org.gudy.azureus2.ui.swt.views.TableView;
import org.gudy.azureus2.ui.swt.views.table.TableCellCore;
import org.gudy.azureus2.ui.swt.views.table.TableColumnCore;
import org.gudy.azureus2.ui.swt.views.table.TableRowCore;
import org.gudy.azureus2.ui.swt.views.table.impl.TableCellImpl;

public class TableRowImpl
extends BufferedTableRow
implements TableRowCore {
    private Map mTableCells;
    private String sTableID;
    private Object coreDataSource;
    private Object pluginDataSource;

    public TableRowImpl(TableView tableView, Object dataSource, boolean bSkipFirstColumn) {
        this(tableView, dataSource, bSkipFirstColumn, -1);
    }

    public TableRowImpl(TableView tableView, Object dataSource, boolean bSkipFirstColumn, int index) {
        super(tableView.getTable(), index);
        this.sTableID = tableView.getTableID();
        this.coreDataSource = dataSource;
        this.mTableCells = new HashMap();
        TableColumnCore[] tableColumns = tableView.getAllTableColumnCore();
        int i = 0;
        while (i < tableColumns.length) {
            this.mTableCells.put(tableColumns[i].getName(), new TableCellImpl(this, tableColumns[i], bSkipFirstColumn));
            ++i;
        }
        TableItem ti = this.getItem();
        if (ti != null) {
            ti.setData("TableRow", (Object)this);
        }
    }

    public boolean isValid() {
        boolean valid = true;
        Iterator iter = this.mTableCells.values().iterator();
        while (iter.hasNext()) {
            TableCellCore cell = (TableCellCore)iter.next();
            if (cell == null) continue;
            valid &= cell.isValid();
        }
        return valid;
    }

    public Object getDataSource() {
        return this.getDataSource(false);
    }

    public String getTableID() {
        return this.sTableID;
    }

    public TableCell getTableCell(String field) {
        return (TableCell)this.mTableCells.get(field);
    }

    public void setValid(boolean valid) {
        Iterator iter = this.mTableCells.values().iterator();
        while (iter.hasNext()) {
            TableCellCore cell = (TableCellCore)iter.next();
            if (cell == null) continue;
            cell.setValid(valid);
        }
    }

    public void delete() {
        Display display = SWTThread.getInstance().getDisplay();
        if (display == null || display.isDisposed()) {
            return;
        }
        display.asyncExec((Runnable)new AERunnable(){

            public void runSupport() {
                Iterator iter = TableRowImpl.this.mTableCells.values().iterator();
                while (iter.hasNext()) {
                    TableCellCore item = (TableCellCore)iter.next();
                    item.dispose();
                }
                TableItem ti = TableRowImpl.this.getItem();
                if (ti != null && !ti.isDisposed()) {
                    ti.setData("TableRow", null);
                }
                TableRowImpl.this.dispose();
            }
        });
    }

    public void refresh(boolean bDoGraphics) {
        if (this.isDisposed()) {
            return;
        }
        Iterator iter = this.mTableCells.values().iterator();
        while (iter.hasNext()) {
            TableCellCore item = (TableCellCore)iter.next();
            item.refresh();
        }
    }

    public void locationChanged(int iStartColumn) {
        if (this.isDisposed()) {
            return;
        }
        Iterator iter = this.mTableCells.values().iterator();
        while (iter.hasNext()) {
            TableCellCore item = (TableCellCore)iter.next();
            if (item.getTableColumn().getPosition() <= iStartColumn) continue;
            item.locationChanged();
        }
    }

    public void doPaint(GC gc) {
        if (this.isDisposed()) {
            return;
        }
        Iterator iter = this.mTableCells.values().iterator();
        while (iter.hasNext()) {
            TableCellCore item = (TableCellCore)iter.next();
            if (!item.needsPainting()) continue;
            item.doPaint(gc);
        }
    }

    public TableCellCore getTableCellCore(String field) {
        return (TableCellCore)this.mTableCells.get(field);
    }

    public void setHeight(int iHeight) {
        TableItem ti = this.getItem();
        if (ti == null) {
            return;
        }
        Image image = new Image((Device)ti.getDisplay(), 1, iHeight);
        ti.setImage(0, image);
        ti.setImage(0, null);
        image.dispose();
    }

    public Object getDataSource(boolean bCoreObject) {
        TRHostTorrent item;
        DiskManagerFileInfo fileInfo2;
        PEPiece piece;
        PEPeer peer;
        DownloadManager dm;
        TableItem ti = this.getItem();
        if (ti == null || ti.isDisposed()) {
            return null;
        }
        if (bCoreObject) {
            return this.coreDataSource;
        }
        if (this.pluginDataSource != null) {
            return this.pluginDataSource;
        }
        if ((this.sTableID.equals("MySeeders") || this.sTableID.equals("MyTorrents")) && (dm = (DownloadManager)this.coreDataSource) != null) {
            try {
                this.pluginDataSource = DownloadManagerImpl.getDownloadStatic(dm);
            }
            catch (DownloadException downloadException) {
                // empty catch block
            }
        }
        if (this.sTableID.equals("Peers") && (peer = (PEPeer)this.coreDataSource) != null) {
            this.pluginDataSource = new PeerImpl(peer);
        }
        if (this.sTableID.equals("Pieces") && (piece = (PEPiece)this.coreDataSource) != null) {
            this.pluginDataSource = null;
        }
        if (this.sTableID.equals("Files") && (fileInfo2 = (DiskManagerFileInfo)this.coreDataSource) != null) {
            this.pluginDataSource = new DiskManagerFileInfoImpl(fileInfo2);
        }
        if (this.sTableID.equals("MyShares")) {
            this.pluginDataSource = this.coreDataSource;
        }
        if (this.sTableID.equals("MyTracker") && (item = (TRHostTorrent)this.coreDataSource) != null) {
            this.pluginDataSource = new TrackerTorrentImpl(item);
        }
        return this.pluginDataSource;
    }

    public boolean setIndex(int newIndex) {
        if (super.setIndex(newIndex)) {
            this.getItem().setData("TableRow", (Object)this);
            return true;
        }
        return false;
    }

    public boolean setDataSource(Object dataSource) {
        if (this.getDataSource(true) != dataSource) {
            this.coreDataSource = dataSource;
            this.pluginDataSource = null;
            this.setValid(false);
            return true;
        }
        return false;
    }
}

