/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import com.aelitis.azureus.core.AzureusCore;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.tracker.host.TRHostListener;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrent;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrentRemovalVetoException;
import org.gudy.azureus2.ui.swt.Alerts;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.mainwindow.MainWindow;
import org.gudy.azureus2.ui.swt.views.TableView;
import org.gudy.azureus2.ui.swt.views.table.TableColumnCore;
import org.gudy.azureus2.ui.swt.views.table.TableRowCore;
import org.gudy.azureus2.ui.swt.views.tableitems.mytracker.AnnounceCountItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytracker.AverageBytesInItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytracker.AverageBytesOutItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytracker.BadNATCountItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytracker.CompletedCountItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytracker.DownloadedItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytracker.LeftItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytracker.NameItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytracker.PeerCountItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytracker.ScrapeCountItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytracker.SeedCountItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytracker.StatusItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytracker.TotalBytesInItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytracker.TotalBytesOutItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytracker.TrackerItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytracker.UploadedItem;

public class MyTrackerView
extends TableView
implements TRHostListener {
    private static final TableColumnCore[] basicItems = new TableColumnCore[]{new NameItem(), new TrackerItem(), new StatusItem(), new SeedCountItem(), new PeerCountItem(), new BadNATCountItem(), new AnnounceCountItem(), new ScrapeCountItem(), new CompletedCountItem(), new UploadedItem(), new DownloadedItem(), new LeftItem(), new TotalBytesInItem(), new AverageBytesInItem(), new TotalBytesOutItem(), new AverageBytesOutItem()};
    private AzureusCore azureus_core;
    private boolean start;
    private boolean stop;
    private boolean remove;

    public MyTrackerView(AzureusCore _azureus_core) {
        super("MyTracker", "MyTrackerView", basicItems, "name", 67586);
        this.azureus_core = _azureus_core;
    }

    public void initialize(Composite composite0) {
        super.initialize(composite0);
        this.azureus_core.getTrackerHost().addListener(this);
        Table table = this.getTable();
        table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent mEvent) {
                TRHostTorrent torrent = (TRHostTorrent)MyTrackerView.this.getFirstSelectedDataSource();
                if (torrent == null) {
                    return;
                }
                DownloadManager dm = MyTrackerView.this.azureus_core.getGlobalManager().getDownloadManager(torrent.getTorrent());
                if (dm != null) {
                    MainWindow.getWindow().openManagerView(dm);
                }
            }
        });
    }

    public void tableStructureChanged() {
        this.azureus_core.getTrackerHost().removeListener(this);
        super.tableStructureChanged();
        this.azureus_core.getTrackerHost().addListener(this);
    }

    public void fillMenu(Menu menu) {
        final MenuItem itemStart = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemStart, "MyTorrentsView.menu.start");
        itemStart.setImage(ImageRepository.getImage("start"));
        final MenuItem itemStop = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemStop, "MyTorrentsView.menu.stop");
        itemStop.setImage(ImageRepository.getImage("stop"));
        final MenuItem itemRemove = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemRemove, "MyTorrentsView.menu.remove");
        itemRemove.setImage(ImageRepository.getImage("delete"));
        menu.addListener(22, new Listener(){

            public void handleEvent(Event e) {
                Object[] hostTorrents = MyTrackerView.this.getSelectedDataSources();
                itemStart.setEnabled(false);
                itemStop.setEnabled(false);
                itemRemove.setEnabled(false);
                if (hostTorrents.length > 0) {
                    boolean start_ok = true;
                    boolean stop_ok = true;
                    boolean remove_ok = true;
                    int i = 0;
                    while (i < hostTorrents.length) {
                        TRHostTorrent host_torrent = (TRHostTorrent)hostTorrents[i];
                        int status = host_torrent.getStatus();
                        if (status != 1) {
                            start_ok = false;
                        }
                        if (status != 2) {
                            stop_ok = false;
                        }
                        ++i;
                    }
                    itemStart.setEnabled(start_ok);
                    itemStop.setEnabled(stop_ok);
                    itemRemove.setEnabled(remove_ok);
                }
            }
        });
        itemStart.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                MyTrackerView.this.startSelectedTorrents();
            }
        });
        itemStop.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                MyTrackerView.this.stopSelectedTorrents();
            }
        });
        itemRemove.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                MyTrackerView.this.removeSelectedTorrents();
            }
        });
        new MenuItem(menu, 2);
        super.fillMenu(menu);
    }

    public void torrentAdded(TRHostTorrent host_torrent) {
        this.addDataSource(host_torrent);
    }

    public void torrentChanged(TRHostTorrent t) {
    }

    public void torrentRemoved(TRHostTorrent host_torrent) {
        this.removeDataSource(host_torrent);
    }

    public boolean handleExternalRequest(String client, String url, String header, InputStream is, OutputStream os) throws IOException {
        return false;
    }

    public void refresh() {
        if (this.getComposite() == null || this.getComposite().isDisposed()) {
            return;
        }
        this.computePossibleActions();
        MainWindow.getWindow().refreshIconBar();
        TableRowCore[] rows = this.getRowsUnordered();
        int x = 0;
        while (x < rows.length) {
            TRHostTorrent host_torrent;
            if (rows[x] != null && (host_torrent = (TRHostTorrent)rows[x].getDataSource(true)) != null) {
                long uploaded = host_torrent.getTotalUploaded();
                long downloaded = host_torrent.getTotalDownloaded();
                long left = host_torrent.getTotalLeft();
                int seed_count = host_torrent.getSeedCount();
                host_torrent.setData("GUI_PeerCount", new Long(host_torrent.getLeecherCount()));
                host_torrent.setData("GUI_SeedCount", new Long(seed_count));
                host_torrent.setData("GUI_BadNATCount", new Long(host_torrent.getBadNATCount()));
                host_torrent.setData("GUI_Uploaded", new Long(uploaded));
                host_torrent.setData("GUI_Downloaded", new Long(downloaded));
                host_torrent.setData("GUI_Left", new Long(left));
                if (seed_count != 0 && !rows[x].getForeground().equals((Object)Colors.blues[7])) {
                    rows[x].setForeground(Colors.blues[7]);
                }
            }
            ++x;
        }
        super.refresh();
    }

    public void delete() {
        super.delete();
        this.azureus_core.getTrackerHost().removeListener(this);
    }

    private void computePossibleActions() {
        this.remove = false;
        this.stop = false;
        this.start = false;
        Object[] hostTorrents = this.getSelectedDataSources();
        if (hostTorrents.length > 0) {
            this.remove = true;
            int i = 0;
            while (i < hostTorrents.length) {
                TRHostTorrent host_torrent = (TRHostTorrent)hostTorrents[i];
                int status = host_torrent.getStatus();
                if (status == 1) {
                    this.start = true;
                }
                if (status == 2) {
                    this.stop = true;
                }
                ++i;
            }
        }
    }

    public boolean isEnabled(String itemKey) {
        if (itemKey.equals("start")) {
            return this.start;
        }
        if (itemKey.equals("stop")) {
            return this.stop;
        }
        if (itemKey.equals("remove")) {
            return this.remove;
        }
        return false;
    }

    public void itemActivated(String itemKey) {
        if (itemKey.equals("start")) {
            this.startSelectedTorrents();
            return;
        }
        if (itemKey.equals("stop")) {
            this.stopSelectedTorrents();
            return;
        }
        if (itemKey.equals("remove")) {
            this.removeSelectedTorrents();
            return;
        }
    }

    private void stopSelectedTorrents() {
        this.runForSelectedRows(new TableView.GroupTableRowRunner(this){

            public void run(TableRowCore row) {
                TRHostTorrent torrent = (TRHostTorrent)row.getDataSource(true);
                if (torrent.getStatus() == 2) {
                    torrent.stop();
                }
            }
        });
    }

    private void startSelectedTorrents() {
        this.runForSelectedRows(new TableView.GroupTableRowRunner(this){

            public void run(TableRowCore row) {
                TRHostTorrent torrent = (TRHostTorrent)row.getDataSource(true);
                if (torrent.getStatus() == 1) {
                    torrent.start();
                }
            }
        });
    }

    private void removeSelectedTorrents() {
        this.runForSelectedRows(new TableView.GroupTableRowRunner(this){

            public void run(TableRowCore row) {
                TRHostTorrent torrent = (TRHostTorrent)row.getDataSource(true);
                try {
                    torrent.remove();
                }
                catch (TRHostTorrentRemovalVetoException f) {
                    Alerts.showErrorMessageBoxUsingResourceString("globalmanager.download.remove.veto", f);
                }
            }
        });
    }
}

