/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.sharing;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.gudy.azureus2.core3.config.COConfigurationListener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.logging.LGLogger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentCreator;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.torrent.TOTorrentProgressListener;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.sharing.ShareException;
import org.gudy.azureus2.plugins.sharing.ShareManager;
import org.gudy.azureus2.plugins.sharing.ShareManagerListener;
import org.gudy.azureus2.plugins.sharing.ShareResource;
import org.gudy.azureus2.plugins.sharing.ShareResourceDeletionVetoException;
import org.gudy.azureus2.plugins.sharing.ShareResourceDir;
import org.gudy.azureus2.plugins.sharing.ShareResourceDirContents;
import org.gudy.azureus2.plugins.sharing.ShareResourceFile;
import org.gudy.azureus2.plugins.torrent.TorrentException;
import org.gudy.azureus2.pluginsimpl.local.sharing.ShareConfigImpl;
import org.gudy.azureus2.pluginsimpl.local.sharing.ShareItemImpl;
import org.gudy.azureus2.pluginsimpl.local.sharing.ShareResourceDirContentsImpl;
import org.gudy.azureus2.pluginsimpl.local.sharing.ShareResourceDirImpl;
import org.gudy.azureus2.pluginsimpl.local.sharing.ShareResourceFileImpl;
import org.gudy.azureus2.pluginsimpl.local.sharing.ShareResourceFileOrDirImpl;
import org.gudy.azureus2.pluginsimpl.local.sharing.ShareResourceImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentImpl;

public class ShareManagerImpl
implements ShareManager,
TOTorrentProgressListener,
ParameterListener {
    public static final String TORRENT_STORE = "shares";
    public static final String TORRENT_SUBSTORE = "cache";
    public static final int MAX_FILES_PER_DIR = 1000;
    public static final int MAX_DIRS = 1000;
    protected static ShareManagerImpl singleton;
    private static AEMonitor class_mon;
    protected AEMonitor this_mon = new AEMonitor("ShareManager");
    protected TOTorrentCreator to_creator;
    protected boolean initialised;
    protected File share_dir;
    protected URL announce_url;
    protected ShareConfigImpl config;
    protected Map shares = new HashMap();
    protected shareScanner current_scanner;
    protected List listeners = new ArrayList();

    static {
        class_mon = new AEMonitor("ShareManager:class");
    }

    public static ShareManagerImpl getSingleton() throws ShareException {
        try {
            class_mon.enter();
            if (singleton == null) {
                singleton = new ShareManagerImpl();
            }
            ShareManagerImpl shareManagerImpl = singleton;
            class_mon.exit();
            return shareManagerImpl;
        }
        catch (Throwable throwable) {
            class_mon.exit();
            throw throwable;
        }
    }

    protected ShareManagerImpl() throws ShareException {
        COConfigurationManager.addListener(new COConfigurationListener(){

            public void configurationSaved() {
                ShareManagerImpl.this.announce_url = null;
            }
        });
    }

    /*
     * Unable to fully structure code
     */
    public void initialise() throws ShareException {
        block12: {
            try {
                this.this_mon.enter();
                if (this.initialised) break block12;
                this.initialised = true;
                this.share_dir = FileUtil.getUserFile("shares");
                this.share_dir.mkdirs();
                this.config = new ShareConfigImpl();
                try {
                    this.config.suspendSaving();
                    this.config.loadConfig(this);
                    this.checkConsistency();
                }
                finally {
                    it = this.shares.values().iterator();
                    ** while (it.hasNext())
                }
lbl-1000:
                // 1 sources

                {
                    resource = (ShareResourceImpl)it.next();
                    if (resource.getType() != 3) continue;
                    i = 0;
                    while (i < this.listeners.size()) {
                        try {
                            ((ShareManagerListener)this.listeners.get(i)).resourceAdded(resource);
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                        ++i;
                    }
                    continue;
                }
lbl29:
                // 1 sources

                this.config.resumeSaving();
                this.readAZConfig();
            }
            finally {
                this.this_mon.exit();
            }
        }
    }

    protected void readAZConfig() {
        COConfigurationManager.addParameterListener("Sharing Rescan Enable", this);
        this.readAZConfigSupport();
    }

    public void parameterChanged(String name) {
        this.readAZConfigSupport();
    }

    protected void readAZConfigSupport() {
        try {
            this.this_mon.enter();
            boolean scan_enabled = COConfigurationManager.getBooleanParameter("Sharing Rescan Enable");
            if (!scan_enabled) {
                this.current_scanner = null;
            } else if (this.current_scanner == null) {
                this.current_scanner = new shareScanner();
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected ShareConfigImpl getShareConfig() {
        return this.config;
    }

    protected void checkConsistency() throws ShareException {
        Iterator it = new HashSet(this.shares.values()).iterator();
        while (it.hasNext()) {
            ShareResourceImpl resource = (ShareResourceImpl)it.next();
            resource.checkConsistency();
        }
    }

    protected void deserialiseResource(Map map) {
        block6: {
            try {
                ShareResourceImpl new_resource = null;
                int type = ((Long)map.get("type")).intValue();
                new_resource = type == 1 || type == 2 ? ShareResourceFileOrDirImpl.deserialiseResource(this, map, type) : ShareResourceDirContentsImpl.deserialiseResource(this, map);
                if (new_resource == null) break block6;
                ShareResourceImpl old_resource = (ShareResourceImpl)this.shares.get(new_resource.getName());
                if (old_resource != null) {
                    old_resource.delete(true);
                }
                this.shares.put(new_resource.getName(), new_resource);
                if (type == 3) break block6;
                int i = 0;
                while (i < this.listeners.size()) {
                    try {
                        ((ShareManagerListener)this.listeners.get(i)).resourceAdded(new_resource);
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                    ++i;
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    protected String getNewTorrentLocation() throws ShareException {
        Random rand = new Random(SystemTime.getCurrentTime());
        int i = 1;
        while (i <= 1000) {
            String cache_dir_str = this.share_dir + File.separator + TORRENT_SUBSTORE + i;
            File cache_dir = new File(cache_dir_str);
            if (!cache_dir.exists()) {
                cache_dir.mkdirs();
            }
            if (cache_dir.listFiles().length < 1000) {
                int j = 0;
                while (j < 1000) {
                    long file = Math.abs(rand.nextLong());
                    File file_name = new File(String.valueOf(cache_dir_str) + File.separator + file + ".torrent");
                    if (!file_name.exists()) {
                        return TORRENT_SUBSTORE + i + File.separator + file + ".torrent";
                    }
                    ++j;
                }
            }
            ++i;
        }
        throw new ShareException("ShareManager: failed to allocate cache file");
    }

    protected void writeTorrent(ShareItemImpl item) throws ShareException {
        try {
            item.getTorrent().writeToFile(this.getTorrentFile(item));
        }
        catch (TorrentException e) {
            throw new ShareException("ShareManager: torrent write fails", e);
        }
    }

    protected void readTorrent(ShareItemImpl item) throws ShareException {
        try {
            TOTorrent torrent = TOTorrentFactory.deserialiseFromBEncodedFile(this.getTorrentFile(item));
            item.setTorrent(new TorrentImpl(torrent));
        }
        catch (TOTorrentException e) {
            throw new ShareException("ShareManager: torrent read fails", e);
        }
    }

    protected void deleteTorrent(ShareItemImpl item) {
        File torrent_file = this.getTorrentFile(item);
        System.out.println("deleting torrent '".concat(torrent_file.toString()).concat("'"));
        torrent_file.delete();
    }

    protected boolean torrentExists(ShareItemImpl item) {
        return this.getTorrentFile(item).exists();
    }

    protected File getTorrentFile(ShareItemImpl item) {
        return new File(this.share_dir + File.separator + item.getTorrentLocation());
    }

    protected URL getAnnounceURL() throws ShareException {
        if (this.announce_url == null) {
            String tracker_ip = COConfigurationManager.getStringParameter("Tracker IP", "");
            if (tracker_ip.length() == 0) {
                throw new ShareException("ShareManager: tracker must be configured");
            }
            boolean use_ssl = COConfigurationManager.getBooleanParameter("Sharing Use SSL", false);
            int port = use_ssl ? COConfigurationManager.getIntParameter("Tracker Port SSL", 7000) : COConfigurationManager.getIntParameter("Tracker Port", 6969);
            try {
                this.announce_url = new URL((use_ssl ? "https" : "http").concat("://").concat(tracker_ip).concat(":").concat(String.valueOf(port)).concat("/announce"));
            }
            catch (MalformedURLException e) {
                throw new ShareException("Announce URL invalid", e);
            }
        }
        return this.announce_url;
    }

    protected boolean getAddHashes() {
        return COConfigurationManager.getBooleanParameter("Sharing Add Hashes", true);
    }

    public ShareResource[] getShares() {
        ShareResource[] res = new ShareResource[this.shares.size()];
        this.shares.values().toArray(res);
        return res;
    }

    protected ShareResourceImpl getResource(File file) {
        return (ShareResourceImpl)this.shares.get(file.toString());
    }

    public ShareResource getShare(File file_or_dir) {
        return this.getResource(file_or_dir);
    }

    public ShareResourceFile addFile(File file) throws ShareException, ShareResourceDeletionVetoException {
        LGLogger.log("ShareManager: addFile '" + file.toString() + "'");
        try {
            return (ShareResourceFile)this.addFileOrDir(file, 1, false);
        }
        catch (ShareException e) {
            this.reportError(e);
            throw e;
        }
    }

    public ShareResourceFile getFile(File file) throws ShareException {
        return ShareResourceFileImpl.getResource(this, file);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ShareResourceDir addDir(File dir) throws ShareException, ShareResourceDeletionVetoException {
        LGLogger.log("ShareManager: addDir '" + dir.toString() + "'");
        try {
            try {
                this.this_mon.enter();
                ShareResourceDir shareResourceDir = (ShareResourceDir)this.addFileOrDir(dir, 2, false);
                this.this_mon.exit();
                return shareResourceDir;
            }
            catch (ShareException e) {
                this.reportError(e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            this.this_mon.exit();
            throw throwable;
        }
    }

    public ShareResourceDir getDir(File file) throws ShareException {
        return ShareResourceDirImpl.getResource(this, file);
    }

    protected ShareResource addFileOrDir(File file, int type, boolean modified) throws ShareException, ShareResourceDeletionVetoException {
        try {
            ShareResourceFileOrDirImpl new_resource;
            this.this_mon.enter();
            String name = file.toString();
            ShareResource old_resource = (ShareResource)this.shares.get(name);
            if (old_resource != null) {
                old_resource.delete();
            }
            if (type == 1) {
                this.reportCurrentTask("Adding file '" + name + "'");
                new_resource = new ShareResourceFileImpl(this, file);
            } else {
                this.reportCurrentTask("Adding dir '" + name + "'");
                new_resource = new ShareResourceDirImpl(this, file);
            }
            this.shares.put(name, new_resource);
            this.config.saveConfig();
            int i = 0;
            while (i < this.listeners.size()) {
                try {
                    if (modified) {
                        ((ShareManagerListener)this.listeners.get(i)).resourceModified(new_resource);
                    } else {
                        ((ShareManagerListener)this.listeners.get(i)).resourceAdded(new_resource);
                    }
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
                ++i;
            }
            ShareResourceFileOrDirImpl shareResourceFileOrDirImpl = new_resource;
            this.this_mon.exit();
            return shareResourceFileOrDirImpl;
        }
        catch (Throwable throwable) {
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ShareResourceDirContents addDirContents(File dir, boolean recursive) throws ShareException, ShareResourceDeletionVetoException {
        LGLogger.log("ShareManager: addDirContents '" + dir.toString() + "'");
        try {
            try {
                this.this_mon.enter();
                String name = dir.toString();
                this.reportCurrentTask("Adding dir contents '" + name + "', recursive = " + recursive);
                ShareResource old_resource = (ShareResource)this.shares.get(name);
                if (old_resource != null) {
                    old_resource.delete();
                }
                ShareResourceDirContentsImpl new_resource = new ShareResourceDirContentsImpl(this, dir, recursive);
                this.shares.put(name, new_resource);
                this.config.saveConfig();
                int i = 0;
                while (true) {
                    if (i >= this.listeners.size()) {
                        ShareResourceDirContentsImpl shareResourceDirContentsImpl = new_resource;
                        this.this_mon.exit();
                        return shareResourceDirContentsImpl;
                    }
                    try {
                        ((ShareManagerListener)this.listeners.get(i)).resourceAdded(new_resource);
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                    ++i;
                }
            }
            catch (ShareException e) {
                this.reportError(e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            this.this_mon.exit();
            throw throwable;
        }
    }

    protected void delete(ShareResourceImpl resource) throws ShareException {
        LGLogger.log("ShareManager: resource '" + resource.getName() + "' deleted");
        try {
            this.this_mon.enter();
            this.shares.remove(resource.getName());
            resource.deleteInternal();
            this.config.saveConfig();
            int i = 0;
            while (i < this.listeners.size()) {
                try {
                    ((ShareManagerListener)this.listeners.get(i)).resourceDeleted(resource);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
                ++i;
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected void scanShares() throws ShareException {
        LGLogger.log("ShareManager: scanning resources for changes");
        this.checkConsistency();
    }

    protected void setTorrentCreator(TOTorrentCreator _to_creator) {
        this.to_creator = _to_creator;
    }

    public void cancelOperation() {
        TOTorrentCreator temp = this.to_creator;
        if (temp != null) {
            temp.cancel();
        }
    }

    public void reportProgress(int percent_complete) {
        int i = 0;
        while (i < this.listeners.size()) {
            try {
                ((ShareManagerListener)this.listeners.get(i)).reportProgress(percent_complete);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
    }

    public void reportCurrentTask(String task_description) {
        int i = 0;
        while (i < this.listeners.size()) {
            try {
                ((ShareManagerListener)this.listeners.get(i)).reportCurrentTask(task_description);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
    }

    protected void reportError(Throwable e) {
        String message = e.getMessage();
        if (message != null) {
            this.reportCurrentTask(message);
        } else {
            this.reportCurrentTask(e.toString());
        }
    }

    public void addListener(ShareManagerListener l) {
        this.listeners.add(l);
    }

    public void removeListener(ShareManagerListener l) {
        this.listeners.remove(l);
    }

    protected class shareScanner {
        boolean run = true;

        protected shareScanner() {
            ShareManagerImpl.this.current_scanner = this;
            AEThread t = new AEThread(this, "ShareManager::scanner"){
                final /* synthetic */ shareScanner this$1;
                {
                    this.this$1 = shareScanner2;
                    super($anonymous0);
                }

                public void runSupport() {
                    while (shareScanner.access$0((shareScanner)this.this$1).current_scanner == this.this$1) {
                        try {
                            int scan_period = COConfigurationManager.getIntParameter("Sharing Rescan Period");
                            if (scan_period < 1) {
                                scan_period = 1;
                            }
                            Thread.sleep(scan_period * 1000);
                            if (shareScanner.access$0((shareScanner)this.this$1).current_scanner != this.this$1) continue;
                            shareScanner.access$0(this.this$1).scanShares();
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                }
            };
            t.setDaemon(true);
            t.start();
        }

        static /* synthetic */ ShareManagerImpl access$0(shareScanner shareScanner2) {
            return shareScanner2.ShareManagerImpl.this;
        }
    }
}

