/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.MessageDigest;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Md5Hasher;

public class MD5 {
    private int h0;
    private int h1;
    private int h2;
    private int h3;
    private int length;
    private ByteBuffer finalBuffer = ByteBuffer.allocateDirect(64);

    public MD5() {
        this.finalBuffer.position(0);
        this.finalBuffer.limit(64);
        this.reset();
    }

    public void transform(ByteBuffer M) {
        ByteOrder order = M.order();
        M.order(ByteOrder.LITTLE_ENDIAN);
        int x0 = M.getInt();
        int x1 = M.getInt();
        int x2 = M.getInt();
        int x3 = M.getInt();
        int x4 = M.getInt();
        int x5 = M.getInt();
        int x6 = M.getInt();
        int x7 = M.getInt();
        int x8 = M.getInt();
        int x9 = M.getInt();
        int x10 = M.getInt();
        int x11 = M.getInt();
        int x12 = M.getInt();
        int x13 = M.getInt();
        int x14 = M.getInt();
        int x15 = M.getInt();
        M.order(order);
        int a = this.h0;
        int b = this.h1;
        int c = this.h2;
        int d = this.h3;
        a += (b & c | ~b & d) + x0 + -680876936;
        a = b + (a << 7 | a >>> 25);
        d += (a & b | ~a & c) + x1 + -389564586;
        d = a + (d << 12 | d >>> 20);
        c += (d & a | ~d & b) + x2 + 606105819;
        c = d + (c << 17 | c >>> 15);
        b += (c & d | ~c & a) + x3 + -1044525330;
        b = c + (b << 22 | b >>> 10);
        a += (b & c | ~b & d) + x4 + -176418897;
        a = b + (a << 7 | a >>> 25);
        d += (a & b | ~a & c) + x5 + 1200080426;
        d = a + (d << 12 | d >>> 20);
        c += (d & a | ~d & b) + x6 + -1473231341;
        c = d + (c << 17 | c >>> 15);
        b += (c & d | ~c & a) + x7 + -45705983;
        b = c + (b << 22 | b >>> 10);
        a += (b & c | ~b & d) + x8 + 1770035416;
        a = b + (a << 7 | a >>> 25);
        d += (a & b | ~a & c) + x9 + -1958414417;
        d = a + (d << 12 | d >>> 20);
        c += (d & a | ~d & b) + x10 + -42063;
        c = d + (c << 17 | c >>> 15);
        b += (c & d | ~c & a) + x11 + -1990404162;
        b = c + (b << 22 | b >>> 10);
        a += (b & c | ~b & d) + x12 + 1804603682;
        a = b + (a << 7 | a >>> 25);
        d += (a & b | ~a & c) + x13 + -40341101;
        d = a + (d << 12 | d >>> 20);
        c += (d & a | ~d & b) + x14 + -1502002290;
        c = d + (c << 17 | c >>> 15);
        b += (c & d | ~c & a) + x15 + 1236535329;
        b = c + (b << 22 | b >>> 10);
        a += (b & d | c & ~d) + x1 + -165796510;
        a = b + (a << 5 | a >>> 27);
        d += (a & c | b & ~c) + x6 + -1069501632;
        d = a + (d << 9 | d >>> 23);
        c += (d & b | a & ~b) + x11 + 643717713;
        c = d + (c << 14 | c >>> 18);
        b += (c & a | d & ~a) + x0 + -373897302;
        b = c + (b << 20 | b >>> 12);
        a += (b & d | c & ~d) + x5 + -701558691;
        a = b + (a << 5 | a >>> 27);
        d += (a & c | b & ~c) + x10 + 38016083;
        d = a + (d << 9 | d >>> 23);
        c += (d & b | a & ~b) + x15 + -660478335;
        c = d + (c << 14 | c >>> 18);
        b += (c & a | d & ~a) + x4 + -405537848;
        b = c + (b << 20 | b >>> 12);
        a += (b & d | c & ~d) + x9 + 568446438;
        a = b + (a << 5 | a >>> 27);
        d += (a & c | b & ~c) + x14 + -1019803690;
        d = a + (d << 9 | d >>> 23);
        c += (d & b | a & ~b) + x3 + -187363961;
        c = d + (c << 14 | c >>> 18);
        b += (c & a | d & ~a) + x8 + 1163531501;
        b = c + (b << 20 | b >>> 12);
        a += (b & d | c & ~d) + x13 + -1444681467;
        a = b + (a << 5 | a >>> 27);
        d += (a & c | b & ~c) + x2 + -51403784;
        d = a + (d << 9 | d >>> 23);
        c += (d & b | a & ~b) + x7 + 1735328473;
        c = d + (c << 14 | c >>> 18);
        b += (c & a | d & ~a) + x12 + -1926607734;
        b = c + (b << 20 | b >>> 12);
        a += (b ^ c ^ d) + x5 + -378558;
        a = b + (a << 4 | a >>> 28);
        d += (a ^ b ^ c) + x8 + -2022574463;
        d = a + (d << 11 | d >>> 21);
        c += (d ^ a ^ b) + x11 + 1839030562;
        c = d + (c << 16 | c >>> 16);
        b += (c ^ d ^ a) + x14 + -35309556;
        b = c + (b << 23 | b >>> 9);
        a += (b ^ c ^ d) + x1 + -1530992060;
        a = b + (a << 4 | a >>> 28);
        d += (a ^ b ^ c) + x4 + 1272893353;
        d = a + (d << 11 | d >>> 21);
        c += (d ^ a ^ b) + x7 + -155497632;
        c = d + (c << 16 | c >>> 16);
        b += (c ^ d ^ a) + x10 + -1094730640;
        b = c + (b << 23 | b >>> 9);
        a += (b ^ c ^ d) + x13 + 681279174;
        a = b + (a << 4 | a >>> 28);
        d += (a ^ b ^ c) + x0 + -358537222;
        d = a + (d << 11 | d >>> 21);
        c += (d ^ a ^ b) + x3 + -722521979;
        c = d + (c << 16 | c >>> 16);
        b += (c ^ d ^ a) + x6 + 76029189;
        b = c + (b << 23 | b >>> 9);
        a += (b ^ c ^ d) + x9 + -640364487;
        a = b + (a << 4 | a >>> 28);
        d += (a ^ b ^ c) + x12 + -421815835;
        d = a + (d << 11 | d >>> 21);
        c += (d ^ a ^ b) + x15 + 530742520;
        c = d + (c << 16 | c >>> 16);
        b += (c ^ d ^ a) + x2 + -995338651;
        b = c + (b << 23 | b >>> 9);
        a += (c ^ (b | ~d)) + x0 + -198630844;
        a = b + (a << 6 | a >>> 26);
        d += (b ^ (a | ~c)) + x7 + 1126891415;
        d = a + (d << 10 | d >>> 22);
        c += (a ^ (d | ~b)) + x14 + -1416354905;
        c = d + (c << 15 | c >>> 17);
        b += (d ^ (c | ~a)) + x5 + -57434055;
        b = c + (b << 21 | b >>> 11);
        a += (c ^ (b | ~d)) + x12 + 1700485571;
        a = b + (a << 6 | a >>> 26);
        d += (b ^ (a | ~c)) + x3 + -1894986606;
        d = a + (d << 10 | d >>> 22);
        c += (a ^ (d | ~b)) + x10 + -1051523;
        c = d + (c << 15 | c >>> 17);
        b += (d ^ (c | ~a)) + x1 + -2054922799;
        b = c + (b << 21 | b >>> 11);
        a += (c ^ (b | ~d)) + x8 + 1873313359;
        a = b + (a << 6 | a >>> 26);
        d += (b ^ (a | ~c)) + x15 + -30611744;
        d = a + (d << 10 | d >>> 22);
        c += (a ^ (d | ~b)) + x6 + -1560198380;
        c = d + (c << 15 | c >>> 17);
        b += (d ^ (c | ~a)) + x13 + 1309151649;
        b = c + (b << 21 | b >>> 11);
        a += (c ^ (b | ~d)) + x4 + -145523070;
        a = b + (a << 6 | a >>> 26);
        d += (b ^ (a | ~c)) + x11 + -1120210379;
        d = a + (d << 10 | d >>> 22);
        c += (a ^ (d | ~b)) + x2 + 718787259;
        c = d + (c << 15 | c >>> 17);
        b += (d ^ (c | ~a)) + x9 + -343485551;
        b = c + (b << 21 | b >>> 11);
        this.h0 += a;
        this.h1 += b;
        this.h2 += c;
        this.h3 += d;
    }

    public void reset() {
        this.h0 = 1732584193;
        this.h1 = -271733879;
        this.h2 = -1732584194;
        this.h3 = 271733878;
        this.length = 0;
        this.finalBuffer.clear();
    }

    /*
     * Unable to fully structure code
     */
    private void completeFinalBuffer(ByteBuffer buffer) {
        if (this.finalBuffer.position() != 0) ** GOTO lbl5
        return;
lbl-1000:
        // 1 sources

        {
            this.finalBuffer.put(buffer.get());
lbl5:
            // 2 sources

            ** while (buffer.remaining() > 0 && this.finalBuffer.remaining() > 0)
        }
lbl6:
        // 1 sources

        if (this.finalBuffer.remaining() == 0) {
            this.finalBuffer.position(0);
            this.transform(this.finalBuffer);
            this.finalBuffer.position(0);
        }
    }

    public void update(ByteBuffer buffer) {
        this.length += buffer.remaining();
        int position = buffer.position();
        this.completeFinalBuffer(buffer);
        while (buffer.remaining() >= 64) {
            this.transform(buffer);
        }
        if (buffer.remaining() != 0) {
            this.finalBuffer.put(buffer);
        }
        buffer.position(position);
    }

    public byte[] digest() {
        byte[] result = new byte[16];
        this.finalBuffer.put((byte)-128);
        if (this.finalBuffer.remaining() < 8) {
            while (this.finalBuffer.remaining() > 0) {
                this.finalBuffer.put((byte)0);
            }
            this.finalBuffer.position(0);
            this.transform(this.finalBuffer);
            this.finalBuffer.position(0);
        }
        while (this.finalBuffer.remaining() > 8) {
            this.finalBuffer.put((byte)0);
        }
        this.finalBuffer.putLong(this.length << 3);
        this.finalBuffer.position(0);
        this.transform(this.finalBuffer);
        this.finalBuffer.position(0);
        this.finalBuffer.putInt(this.h3);
        this.finalBuffer.putInt(this.h2);
        this.finalBuffer.putInt(this.h1);
        this.finalBuffer.putInt(this.h0);
        this.finalBuffer.position(0);
        int i = 0;
        while (i < 16) {
            result[15 - i] = this.finalBuffer.get();
            ++i;
        }
        return result;
    }

    public byte[] digest(ByteBuffer buffer) {
        this.update(buffer);
        return this.digest();
    }

    public static void main(String[] args) throws Exception {
        MD5 md5Gudy = new MD5();
        Md5Hasher md5Jmule = new Md5Hasher();
        MessageDigest md5Sun = MessageDigest.getInstance("MD5");
        ByteBuffer bhashJ = ByteBuffer.allocate(16);
        System.out.println("Gudy : " + ByteFormatter.nicePrint(md5Gudy.digest()));
        md5Gudy.reset();
        md5Jmule.finalDigest(bhashJ);
        bhashJ.rewind();
        byte[] hashJ = bhashJ.array();
        System.out.println("Jmule: " + ByteFormatter.nicePrint(hashJ));
        System.out.println("Sun: " + ByteFormatter.nicePrint(md5Sun.digest()));
        int i = 0;
        while (i < 1) {
            ByteBuffer test = ByteBuffer.allocate(i);
            while (test.remaining() > 0) {
                test.put((byte)(Math.random() * 256.0));
            }
            test.rewind();
            byte[] hashG = md5Gudy.digest(test);
            md5Gudy.reset();
            md5Jmule.update(test);
            bhashJ.rewind();
            md5Jmule.finalDigest(bhashJ);
            bhashJ.rewind();
            hashJ = bhashJ.array();
            test.rewind();
            md5Sun.update(test.array());
            byte[] hashS = md5Sun.digest();
            System.out.println("Gudy : " + ByteFormatter.nicePrint(hashG));
            System.out.println("Jmule: " + ByteFormatter.nicePrint(hashJ));
            System.out.println("Sun: " + ByteFormatter.nicePrint(hashS));
            ++i;
        }
    }
}

