/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.util.impl;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationListener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.tracker.client.classic.TRTrackerClientClassicImpl;
import org.gudy.azureus2.core3.util.Debug;

public class TRTrackerUtilsImpl {
    private static String[] BLACKLISTED_HOSTS = new String[]{"krypt.dyndns.org"};
    private static int[] BLACKLISTED_PORTS = new int[]{81};
    private static String tracker_ip;
    private static String override_ip;
    private static String bind_ip;

    static {
        COConfigurationManager.addListener(new COConfigurationListener(){

            public void configurationSaved() {
                TRTrackerUtilsImpl.readConfig();
            }
        });
        TRTrackerUtilsImpl.readConfig();
    }

    static void readConfig() {
        tracker_ip = COConfigurationManager.getStringParameter("Tracker IP", "");
        override_ip = COConfigurationManager.getStringParameter("Override Ip", "");
        bind_ip = COConfigurationManager.getStringParameter("Bind IP", "");
    }

    public static boolean isHosting(URL url_in) {
        return tracker_ip.length() > 0 && url_in.getHost().equalsIgnoreCase(tracker_ip);
    }

    public static String getTrackerIP() {
        return tracker_ip;
    }

    public static URL adjustURLForHosting(URL url_in) {
        if (TRTrackerUtilsImpl.isHosting(url_in)) {
            String url = String.valueOf(url_in.getProtocol()) + "://";
            url = bind_ip.length() < 7 ? String.valueOf(url) + "127.0.0.1" : String.valueOf(url) + bind_ip;
            int port = url_in.getPort();
            if (port != -1) {
                url = String.valueOf(url) + ":" + url_in.getPort();
            }
            url = String.valueOf(url) + url_in.getPath();
            String query = url_in.getQuery();
            if (query != null) {
                url = String.valueOf(url) + "?" + query;
            }
            try {
                return new URL(url);
            }
            catch (MalformedURLException e) {
                Debug.printStackTrace(e);
            }
        }
        return url_in;
    }

    public static String adjustHostFromHosting(String host_in) {
        if (tracker_ip.length() > 0) {
            String target_ip = override_ip;
            if (target_ip.length() == 0) {
                target_ip = tracker_ip;
            }
            if (host_in.equals("127.0.0.1")) {
                return target_ip;
            }
            if (host_in.equals(bind_ip)) {
                return target_ip;
            }
        }
        return host_in;
    }

    public static void checkForBlacklistedURLs(URL url) throws IOException {
        int i = 0;
        while (i < BLACKLISTED_HOSTS.length) {
            if (url.getHost().equalsIgnoreCase(BLACKLISTED_HOSTS[i]) && url.getPort() == BLACKLISTED_PORTS[i]) {
                throw new IOException("http://" + BLACKLISTED_HOSTS[i] + ":" + BLACKLISTED_PORTS[i] + "/ is not a tracker");
            }
            ++i;
        }
    }

    public static Map mergeResponseCache(Map map1, Map map2) {
        return TRTrackerClientClassicImpl.mergeResponseCache(map1, map2);
    }
}

