/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.disk.impl;

import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.disk.impl.DiskManagerImpl;
import org.gudy.azureus2.core3.util.SystemTime;

public class DiskManagerPieceImpl
implements DiskManagerPiece {
    protected DiskManagerImpl disk_manager;
    protected int piece_index;
    protected boolean done;
    protected boolean[] written;
    protected long last_write_time;

    protected DiskManagerPieceImpl(DiskManagerImpl _disk_manager, int _piece_index) {
        this.disk_manager = _disk_manager;
        this.piece_index = _piece_index;
    }

    public int getPieceNumber() {
        return this.piece_index;
    }

    public int getLength() {
        if (this.piece_index == this.disk_manager.getNumberOfPieces() - 1) {
            return this.disk_manager.getLastPieceLength();
        }
        return this.disk_manager.getPieceLength();
    }

    public int getBlockCount() {
        return (this.getLength() + 16384 - 1) / 16384;
    }

    public boolean getDone() {
        return this.done;
    }

    public void setDone(boolean _done) {
        if (this.done != _done) {
            this.done = _done;
            this.disk_manager.setPieceDone(this);
            if (this.done) {
                this.written = null;
            }
        }
    }

    public void setWritten(int blocNumber) {
        if (this.written == null) {
            this.written = new boolean[this.getBlockCount()];
        }
        this.written[blocNumber] = true;
        this.last_write_time = SystemTime.getCurrentTime();
    }

    public boolean getWritten(int bn) {
        if (this.done) {
            return true;
        }
        if (this.written == null) {
            return false;
        }
        return this.written[bn];
    }

    public long getLastWriteTime() {
        return this.last_write_time;
    }

    public int getCompleteCount() {
        if (this.done) {
            return this.getBlockCount();
        }
        if (this.written == null) {
            return 0;
        }
        int res = 0;
        int i = 0;
        while (i < this.written.length) {
            if (this.written[i]) {
                ++res;
            }
            ++i;
        }
        return res;
    }

    public boolean getCompleted() {
        if (this.written == null) {
            return this.done;
        }
        int i = 0;
        while (i < this.written.length) {
            if (!this.written[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean[] getWritten() {
        return this.written;
    }

    public void reset() {
        this.written = null;
        this.setDone(false);
        this.last_write_time = SystemTime.getCurrentTime();
    }

    public void setInitialWriteTime() {
        this.last_write_time = SystemTime.getCurrentTime();
    }
}

