/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.proxy.impl;

import com.aelitis.azureus.core.proxy.AEProxyAddressMapper;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;

public class AEProxyAddressMapperImpl
implements AEProxyAddressMapper {
    protected static AEProxyAddressMapper singleton = new AEProxyAddressMapperImpl();
    protected boolean enabled;
    protected String prefix;
    protected long next_value;
    protected Map map = new HashMap();
    protected Map reverse_map = new HashMap();

    public static AEProxyAddressMapper getSingleton() {
        return singleton;
    }

    protected AEProxyAddressMapperImpl() {
        if (COConfigurationManager.getBooleanParameter("Enable.Proxy", false) && COConfigurationManager.getBooleanParameter("Enable.SOCKS", false)) {
            String host = COConfigurationManager.getStringParameter("Proxy.Host");
            try {
                if (host.length() > 0 && InetAddress.getByName(host).isLoopbackAddress()) {
                    this.enabled = true;
                    byte[] b = new byte[120];
                    int i = 0;
                    while (i < b.length) {
                        b[i] = (byte)(Math.random() * 256.0);
                        ++i;
                    }
                    this.prefix = ByteFormatter.encodeString(b);
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String internalise(String address) {
        String target;
        if (!this.enabled) {
            return address;
        }
        if (address.length() < 256) {
            return address;
        }
        AEProxyAddressMapperImpl aEProxyAddressMapperImpl = this;
        synchronized (aEProxyAddressMapperImpl) {
            target = (String)this.reverse_map.get(address);
            if (target == null) {
                target = String.valueOf(this.prefix) + this.next_value++;
                while (target.length() < 255) {
                    target = String.valueOf(target) + "0";
                }
                this.map.put(target, address);
                this.reverse_map.put(address, target);
            }
        }
        System.out.println("AEProxyAddressMapper: internalise " + address + " -> " + target);
        return target;
    }

    public String externalise(String address) {
        if (!this.enabled || address.length() < 255) {
            return address;
        }
        String target = (String)this.map.get(address);
        if (target == null) {
            target = address;
        }
        System.out.println("AEProxyAddressMapper: internalise " + address + " -> " + target);
        return target;
    }

    public URL internalise(URL url) {
        if (!this.enabled) {
            return url;
        }
        String host = url.getHost();
        if (host.length() < 256) {
            return url;
        }
        String new_host = this.internalise(host);
        String url_str = url.toString();
        int pos = url_str.indexOf(host);
        if (pos == -1) {
            Debug.out("inconsistent url '" + url_str + "' / '" + host + "'");
            return url;
        }
        String new_url_str = String.valueOf(url_str.substring(0, pos)) + new_host + url_str.substring(pos + host.length());
        try {
            return new URL(new_url_str);
        }
        catch (MalformedURLException e) {
            Debug.printStackTrace(e);
            return url;
        }
    }

    public URL externalise(URL url) {
        if (!this.enabled) {
            return url;
        }
        String host = url.getHost();
        if (host.length() < 255) {
            return url;
        }
        String new_host = this.externalise(host);
        String url_str = url.toString();
        int pos = url_str.indexOf(host);
        if (pos == -1) {
            Debug.out("inconsistent url '" + url_str + "' / '" + host + "'");
            return url;
        }
        String new_url_str = String.valueOf(url_str.substring(0, pos)) + new_host + url_str.substring(pos + host.length());
        try {
            return new URL(new_url_str);
        }
        catch (MalformedURLException e) {
            Debug.printStackTrace(e);
            return url;
        }
    }
}

